// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#pragma once

#include "commitdata.h"

#include <coreplugin/iversioncontrol.h>
#include <texteditor/syntaxhighlighter.h>
#include <vcsbase/submiteditorwidget.h>
#include <utils/filepath.h>

#include <QSyntaxHighlighter>

QT_BEGIN_NAMESPACE
class QCheckBox;
class QValidator;
QT_END_NAMESPACE

namespace Git::Internal {

class GitSubmitPanel;
class GitSubmitEditorPanelInfo;
class GitSubmitEditorPanelData;
class GitSubmitHighlighter;
class LogChangeWidget;

/* Submit editor widget with 2 additional panes:
 * 1) Info with branch, description, etc
 * 2) Data, with author and email to edit.
 * The file contents is the submit message.
 * The previously added files will be added 'checked' to the file list, the
 * remaining un-added and untracked files will be added 'unchecked' for the
 * user to click. */

class GitSubmitEditorWidget : public VcsBase::SubmitEditorWidget
{
    Q_OBJECT

public:
    GitSubmitEditorWidget();

    GitSubmitEditorPanelData panelData() const;
    QString amendHash() const;
    void setHasUnmerged(bool e);
    void initialize(const Utils::FilePath &repository, const CommitData &data);
    void refreshLog(const Utils::FilePath &repository);

protected:
    Utils::Result<> canSubmit() const override;
    QString cleanupDescription(const QString &) const override;
    QString commitName() const override;
    void addFileContextMenuActions(QMenu *menu, const QModelIndex &index) override;

signals:
    void showRequested(const QString &commit);
    void logRequested(const QStringList &range);
    void fileActionRequested(const Utils::FilePath &filePath, Core::IVersionControl::FileAction action);

private:
    void authorInformationChanged();
    void commitOnlySlot();
    void commitAndPushSlot();
    void commitAndPushToGerritSlot();

    bool emailIsValid() const;
    void setPanelData(const GitSubmitEditorPanelData &data);
    void setPanelInfo(const GitSubmitEditorPanelInfo &info);

    PushAction m_pushAction = NoPush;
    GitSubmitPanel *m_gitSubmitPanel = nullptr;
    GitSubmitHighlighter *m_highlighter = nullptr;
    LogChangeWidget *m_logChangeWidget = nullptr;
    QCheckBox *m_editMessageCheckBox = nullptr;
    QValidator *m_emailValidator = nullptr;
    QString m_originalAuthor;
    QString m_originalEmail;
    QStringList m_range;
    bool m_hasUnmerged = false;
    bool m_isInitialized = false;
};

} // Git::Internal
