import QtQuick 2.0

Item {
    width: 320
    height: 680

    Component {
        id: component
        Column {
            property variant listModel: model
            Repeater {
                model: [Text.NativeRendering, Text.QtRendering, Text.CurveRendering]
                Rectangle {
                    width: text.implicitWidth
                    height: text.implicitHeight
                    color: listModel.backGroundColor ? listModel.backGroundColor : "white"

                    Text {
                        id: text
                        font.pixelSize: 32
                        renderType: modelData
                        text: "א😃א😇א😍א😜א😸!"

                        color: listModel.color ? listModel.color : "black"
                        opacity: listModel.opacity ? listModel.opacity : 1.0
                    }
                }
            }
        }
    }

    Column {
        anchors.centerIn: parent
        Repeater {
            model: ListModel {
                ListElement { color: "black" }
                ListElement { color: "blue" }
                ListElement { color: "#990000ff" }
                ListElement { opacity: 0.5 }
                ListElement { backGroundColor: "green" }
            }
            delegate: component
        }
    }
}
