/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.Set;

public class RedundantImportCheck
extends Check {
    private String mPkgName;
    private final Set<FullIdent> mImports = Sets.newHashSet();
    private final Set<FullIdent> mStaticImports = Sets.newHashSet();

    public void beginTree(DetailAST aRootAST) {
        this.mPkgName = null;
        this.mImports.clear();
        this.mStaticImports.clear();
    }

    public int[] getDefaultTokens() {
        return new int[]{31, 154, 16};
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 16) {
            this.mPkgName = FullIdent.createFullIdent(aAST.getLastChild().getPreviousSibling()).getText();
        } else if (aAST.getType() == 31) {
            FullIdent imp = FullIdent.createFullIdentBelow(aAST);
            if (RedundantImportCheck.fromPackage(imp.getText(), "java.lang")) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "import.lang", imp.getText());
            } else if (RedundantImportCheck.fromPackage(imp.getText(), this.mPkgName)) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "import.same", imp.getText());
            }
            for (FullIdent full : this.mImports) {
                if (!imp.getText().equals(full.getText())) continue;
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "import.duplicate", full.getLineNo(), imp.getText());
            }
            this.mImports.add(imp);
        } else {
            FullIdent imp = FullIdent.createFullIdent(aAST.getLastChild().getPreviousSibling());
            for (FullIdent full : this.mStaticImports) {
                if (!imp.getText().equals(full.getText())) continue;
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "import.duplicate", full.getLineNo(), imp.getText());
            }
            this.mStaticImports.add(imp);
        }
    }

    private static boolean fromPackage(String aImport, String aPkg) {
        boolean retVal = false;
        if (aPkg == null) {
            retVal = aImport.indexOf(46) == -1;
        } else {
            int index = aImport.lastIndexOf(46);
            if (index != -1) {
                String front = aImport.substring(0, index);
                retVal = front.equals(aPkg);
            }
        }
        return retVal;
    }
}

