/*
 *  example.c
 * 
 *  Calculate the sum of a given range of integer numbers. The range is
 *  specified by providing two integer numbers as command line argument.
 *  If no arguments are specified, assume the predefined range [0..9].
 *  Abort with an error message if the resulting number is too big to be
 *  stored as int variable.
 *
 *  This program example is similar to the one found in the GCOV documentation.
 *  It is used to demonstrate the HTML output generated by LCOV.
 *
 *  The program is split into 3 modules to better demonstrate the 'directory
 *  overview' function. There are also a lot of bloated comments inserted to
 *  artificially increase the source code size so that the 'source code
 *  overview' function makes at least a minimum of sense.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "iterate.h"
#include "gauss.h"

static int start = 0;
static int end = 9;


int main (int argc, char* argv[])
{
	int total1, total2;

	/* Accept a pair of numbers as command line arguments. */

	if (argc == 3)
	{
		start	= atoi(argv[1]);
		end	= atoi(argv[2]);
	}


	/* Use both methods to calculate the result. */

	total1 = iterate_get_sum (start, end);
	total2 = gauss_get_sum (start, end);


	/* Make sure both results are the same. */

	if (total1 != total2)
	{
		printf ("Failure (%d != %d)!\n", total1, total2);
	}
	else
	{
		printf ("Success, sum[%d..%d] = %d\n", start, end, total1);
	}

	return 0;
}
