/* Copyright (c) 2014, Google Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. */

#include <openssl/err.h>

#include <openssl/x509v3.h>

const ERR_STRING_DATA X509V3_error_string_data[] = {
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_SXNET_add_id_INTEGER, 0), "SXNET_add_id_INTEGER"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_SXNET_add_id_asc, 0), "SXNET_add_id_asc"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_SXNET_add_id_ulong, 0), "SXNET_add_id_ulong"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_SXNET_get_id_asc, 0), "SXNET_get_id_asc"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_SXNET_get_id_ulong, 0), "SXNET_get_id_ulong"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509V3_EXT_add, 0), "X509V3_EXT_add"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509V3_EXT_add_alias, 0), "X509V3_EXT_add_alias"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509V3_EXT_free, 0), "X509V3_EXT_free"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509V3_EXT_i2d, 0), "X509V3_EXT_i2d"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509V3_EXT_nconf, 0), "X509V3_EXT_nconf"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509V3_add1_i2d, 0), "X509V3_add1_i2d"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509V3_add_value, 0), "X509V3_add_value"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509V3_get_section, 0), "X509V3_get_section"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509V3_get_string, 0), "X509V3_get_string"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509V3_get_value_bool, 0), "X509V3_get_value_bool"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509V3_parse_list, 0), "X509V3_parse_list"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509_PURPOSE_add, 0), "X509_PURPOSE_add"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_X509_PURPOSE_set, 0), "X509_PURPOSE_set"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_a2i_GENERAL_NAME, 0), "a2i_GENERAL_NAME"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_copy_email, 0), "copy_email"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_copy_issuer, 0), "copy_issuer"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_do_dirname, 0), "do_dirname"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_do_ext_i2d, 0), "do_ext_i2d"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_do_ext_nconf, 0), "do_ext_nconf"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_gnames_from_sectname, 0), "gnames_from_sectname"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_hex_to_string, 0), "hex_to_string"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_i2s_ASN1_ENUMERATED, 0), "i2s_ASN1_ENUMERATED"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_i2s_ASN1_IA5STRING, 0), "i2s_ASN1_IA5STRING"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_i2s_ASN1_INTEGER, 0), "i2s_ASN1_INTEGER"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_i2v_AUTHORITY_INFO_ACCESS, 0), "i2v_AUTHORITY_INFO_ACCESS"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_notice_section, 0), "notice_section"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_nref_nos, 0), "nref_nos"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_policy_section, 0), "policy_section"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_process_pci_value, 0), "process_pci_value"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_r2i_certpol, 0), "r2i_certpol"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_r2i_pci, 0), "r2i_pci"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_s2i_ASN1_IA5STRING, 0), "s2i_ASN1_IA5STRING"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_s2i_ASN1_INTEGER, 0), "s2i_ASN1_INTEGER"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_s2i_ASN1_OCTET_STRING, 0), "s2i_ASN1_OCTET_STRING"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_s2i_skey_id, 0), "s2i_skey_id"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_set_dist_point_name, 0), "set_dist_point_name"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_string_to_hex, 0), "string_to_hex"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_ASN1_BIT_STRING, 0), "v2i_ASN1_BIT_STRING"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_AUTHORITY_INFO_ACCESS, 0), "v2i_AUTHORITY_INFO_ACCESS"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_AUTHORITY_KEYID, 0), "v2i_AUTHORITY_KEYID"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_BASIC_CONSTRAINTS, 0), "v2i_BASIC_CONSTRAINTS"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_EXTENDED_KEY_USAGE, 0), "v2i_EXTENDED_KEY_USAGE"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_GENERAL_NAMES, 0), "v2i_GENERAL_NAMES"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_GENERAL_NAME_ex, 0), "v2i_GENERAL_NAME_ex"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_NAME_CONSTRAINTS, 0), "v2i_NAME_CONSTRAINTS"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_POLICY_CONSTRAINTS, 0), "v2i_POLICY_CONSTRAINTS"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_POLICY_MAPPINGS, 0), "v2i_POLICY_MAPPINGS"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_crld, 0), "v2i_crld"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_idp, 0), "v2i_idp"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_issuer_alt, 0), "v2i_issuer_alt"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v2i_subject_alt, 0), "v2i_subject_alt"},
  {ERR_PACK(ERR_LIB_X509V3, X509V3_F_v3_generic_extension, 0), "v3_generic_extension"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_BAD_IP_ADDRESS), "BAD_IP_ADDRESS"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_BAD_OBJECT), "BAD_OBJECT"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_BN_DEC2BN_ERROR), "BN_DEC2BN_ERROR"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_BN_TO_ASN1_INTEGER_ERROR), "BN_TO_ASN1_INTEGER_ERROR"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_CANNOT_FIND_FREE_FUNCTION), "CANNOT_FIND_FREE_FUNCTION"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_DIRNAME_ERROR), "DIRNAME_ERROR"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_DISTPOINT_ALREADY_SET), "DISTPOINT_ALREADY_SET"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_DUPLICATE_ZONE_ID), "DUPLICATE_ZONE_ID"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_ERROR_CONVERTING_ZONE), "ERROR_CONVERTING_ZONE"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_ERROR_CREATING_EXTENSION), "ERROR_CREATING_EXTENSION"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_ERROR_IN_EXTENSION), "ERROR_IN_EXTENSION"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EXPECTED_A_SECTION_NAME), "EXPECTED_A_SECTION_NAME"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EXTENSION_EXISTS), "EXTENSION_EXISTS"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EXTENSION_NAME_ERROR), "EXTENSION_NAME_ERROR"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EXTENSION_NOT_FOUND), "EXTENSION_NOT_FOUND"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EXTENSION_SETTING_NOT_SUPPORTED), "EXTENSION_SETTING_NOT_SUPPORTED"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_EXTENSION_VALUE_ERROR), "EXTENSION_VALUE_ERROR"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_ILLEGAL_EMPTY_EXTENSION), "ILLEGAL_EMPTY_EXTENSION"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_ILLEGAL_HEX_DIGIT), "ILLEGAL_HEX_DIGIT"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INCORRECT_POLICY_SYNTAX_TAG), "INCORRECT_POLICY_SYNTAX_TAG"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_ASNUMBER), "INVALID_ASNUMBER"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_ASRANGE), "INVALID_ASRANGE"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_BOOLEAN_STRING), "INVALID_BOOLEAN_STRING"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_EXTENSION_STRING), "INVALID_EXTENSION_STRING"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_INHERITANCE), "INVALID_INHERITANCE"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_IPADDRESS), "INVALID_IPADDRESS"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_MULTIPLE_RDNS), "INVALID_MULTIPLE_RDNS"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_NAME), "INVALID_NAME"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_NULL_ARGUMENT), "INVALID_NULL_ARGUMENT"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_NULL_NAME), "INVALID_NULL_NAME"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_NULL_VALUE), "INVALID_NULL_VALUE"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_NUMBER), "INVALID_NUMBER"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_NUMBERS), "INVALID_NUMBERS"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_OBJECT_IDENTIFIER), "INVALID_OBJECT_IDENTIFIER"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_OPTION), "INVALID_OPTION"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_POLICY_IDENTIFIER), "INVALID_POLICY_IDENTIFIER"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_PROXY_POLICY_SETTING), "INVALID_PROXY_POLICY_SETTING"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_PURPOSE), "INVALID_PURPOSE"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_SAFI), "INVALID_SAFI"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_SECTION), "INVALID_SECTION"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_INVALID_SYNTAX), "INVALID_SYNTAX"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_ISSUER_DECODE_ERROR), "ISSUER_DECODE_ERROR"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_MISSING_VALUE), "MISSING_VALUE"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NEED_ORGANIZATION_AND_NUMBERS), "NEED_ORGANIZATION_AND_NUMBERS"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_CONFIG_DATABASE), "NO_CONFIG_DATABASE"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_ISSUER_CERTIFICATE), "NO_ISSUER_CERTIFICATE"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_ISSUER_DETAILS), "NO_ISSUER_DETAILS"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_POLICY_IDENTIFIER), "NO_POLICY_IDENTIFIER"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_PROXY_CERT_POLICY_LANGUAGE_DEFINED), "NO_PROXY_CERT_POLICY_LANGUAGE_DEFINED"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_PUBLIC_KEY), "NO_PUBLIC_KEY"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_NO_SUBJECT_DETAILS), "NO_SUBJECT_DETAILS"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_ODD_NUMBER_OF_DIGITS), "ODD_NUMBER_OF_DIGITS"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_OPERATION_NOT_DEFINED), "OPERATION_NOT_DEFINED"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_OTHERNAME_ERROR), "OTHERNAME_ERROR"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_POLICY_LANGUAGE_ALREADY_DEFINED), "POLICY_LANGUAGE_ALREADY_DEFINED"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_POLICY_PATH_LENGTH), "POLICY_PATH_LENGTH"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_POLICY_PATH_LENGTH_ALREADY_DEFINED), "POLICY_PATH_LENGTH_ALREADY_DEFINED"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_POLICY_SYNTAX_NOT_CURRENTLY_SUPPORTED), "POLICY_SYNTAX_NOT_CURRENTLY_SUPPORTED"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_POLICY_WHEN_PROXY_LANGUAGE_REQUIRES_NO_POLICY), "POLICY_WHEN_PROXY_LANGUAGE_REQUIRES_NO_POLICY"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_SECTION_NOT_FOUND), "SECTION_NOT_FOUND"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNABLE_TO_GET_ISSUER_DETAILS), "UNABLE_TO_GET_ISSUER_DETAILS"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNABLE_TO_GET_ISSUER_KEYID), "UNABLE_TO_GET_ISSUER_KEYID"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNKNOWN_BIT_STRING_ARGUMENT), "UNKNOWN_BIT_STRING_ARGUMENT"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNKNOWN_EXTENSION), "UNKNOWN_EXTENSION"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNKNOWN_EXTENSION_NAME), "UNKNOWN_EXTENSION_NAME"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNKNOWN_OPTION), "UNKNOWN_OPTION"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNSUPPORTED_OPTION), "UNSUPPORTED_OPTION"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_UNSUPPORTED_TYPE), "UNSUPPORTED_TYPE"},
  {ERR_PACK(ERR_LIB_X509V3, 0, X509V3_R_USER_TOO_LONG), "USER_TOO_LONG"},
  {0, NULL},
};
