// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * @fileoverview Implements a check whether an origin is allowed to assert an
 * app id.
 *
 */
'use strict';

/**
 * Implements half of the app id policy: whether an origin is allowed to claim
 * an app id. For checking whether the app id also lists the origin,
 * @see AppIdChecker.
 * @interface
 */
function OriginChecker() {}

/**
 * Checks whether the origin is allowed to claim the app ids.
 * @param {string} origin The origin claiming the app id.
 * @param {!Array.<string>} appIds The app ids being claimed.
 * @return {Promise.<boolean>} A promise for the result of the check.
 */
OriginChecker.prototype.canClaimAppIds = function(origin, appIds) {};
