# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'chromium_code': 1,
    'grit_out_dir': '<(SHARED_INTERMEDIATE_DIR)/chrome',
    # These files lists are shared with the GN build.
    'ash_sources': [
      'accelerators/accelerator_commands.cc',
      'accelerators/accelerator_commands.h',
      'accelerators/accelerator_controller.cc',
      'accelerators/accelerator_controller.h',
      'accelerators/nested_accelerator_delegate.cc',
      'accelerators/nested_accelerator_delegate.h',
      'accelerators/accelerator_delegate.cc',
      'accelerators/accelerator_delegate.h',
      'accelerators/accelerator_table.cc',
      'accelerators/accelerator_table.h',
      'accelerators/debug_commands.cc',
      'accelerators/debug_commands.h',
      'accelerators/exit_warning_handler.cc',
      'accelerators/exit_warning_handler.h',
      'accelerators/key_hold_detector.cc',
      'accelerators/key_hold_detector.h',
      'accelerators/focus_manager_factory.cc',
      'accelerators/focus_manager_factory.h',
      'accelerators/magnifier_key_scroller.cc',
      'accelerators/magnifier_key_scroller.h',
      'accelerators/spoken_feedback_toggler.cc',
      'accelerators/spoken_feedback_toggler.h',
      'accelerometer/accelerometer_controller.cc',
      'accelerometer/accelerometer_controller.h',
      'accelerometer/accelerometer_observer.h',
      'accessibility_delegate.h',
      'audio/sounds.cc',
      'audio/sounds.h',
      'autoclick/autoclick_controller.cc',
      'autoclick/autoclick_controller.h',
      'ash_constants.cc',
      'ash_constants.h',
      'ash_export.h',
      'ash_switches.cc',
      'ash_switches.h',
      'ash_touch_exploration_manager_chromeos.cc',
      'ash_touch_exploration_manager_chromeos.h',
      'cancel_mode.cc',
      'cancel_mode.h',
      'debug.cc',
      'debug.h',
      'default_accessibility_delegate.cc',
      'default_accessibility_delegate.h',
      'default_user_wallpaper_delegate.cc',
      'default_user_wallpaper_delegate.h',
      'desktop_background/desktop_background_controller.cc',
      'desktop_background/desktop_background_controller.h',
      'desktop_background/desktop_background_controller_observer.h',
      'desktop_background/desktop_background_view.cc',
      'desktop_background/desktop_background_view.h',
      'desktop_background/desktop_background_widget_controller.cc',
      'desktop_background/desktop_background_widget_controller.h',
      'desktop_background/user_wallpaper_delegate.h',
      'desktop_background/wallpaper_resizer.cc',
      'desktop_background/wallpaper_resizer.h',
      'desktop_background/wallpaper_resizer_observer.h',
      'display/cursor_window_controller.cc',
      'display/cursor_window_controller.h',
      'display/display_change_observer_chromeos.cc',
      'display/display_change_observer_chromeos.h',
      'display/display_configurator_animation.cc',
      'display/display_configurator_animation.h',
      'display/display_controller.cc',
      'display/display_controller.h',
      'display/display_error_observer_chromeos.cc',
      'display/display_error_observer_chromeos.h',
      'display/display_info.h',
      'display/display_info.cc',
      'display/display_layout.h',
      'display/display_layout.cc',
      'display/display_layout_store.h',
      'display/display_layout_store.cc',
      'display/display_manager.cc',
      'display/display_manager.h',
      'display/display_pref_util.h',
      'display/event_transformation_handler.cc',
      'display/event_transformation_handler.h',
      'display/mirror_window_controller.cc',
      'display/mirror_window_controller.h',
      'display/mouse_cursor_event_filter.cc',
      'display/mouse_cursor_event_filter.h',
      'display/projecting_observer_chromeos.cc',
      'display/projecting_observer_chromeos.h',
      'display/resolution_notification_controller.cc',
      'display/resolution_notification_controller.h',
      'display/root_window_transformers.cc',
      'display/root_window_transformers.h',
      'display/screen_ash.cc',
      'display/screen_ash.h',
      'display/screen_position_controller.cc',
      'display/screen_position_controller.h',
      'display/shared_display_edge_indicator.cc',
      'display/shared_display_edge_indicator.h',
      'drag_drop/drag_drop_controller.cc',
      'drag_drop/drag_drop_controller.h',
      'drag_drop/drag_drop_tracker.cc',
      'drag_drop/drag_drop_tracker.h',
      'drag_drop/drag_image_view.cc',
      'drag_drop/drag_image_view.h',
      'first_run/desktop_cleaner.cc',
      'first_run/desktop_cleaner.h',
      'first_run/first_run_helper.cc',
      'first_run/first_run_helper.h',
      'first_run/first_run_helper_impl.cc',
      'first_run/first_run_helper_impl.h',
      'focus_cycler.cc',
      'focus_cycler.h',
      'frame/caption_buttons/caption_button_types.h',
      'frame/caption_buttons/frame_caption_button.cc',
      'frame/caption_buttons/frame_caption_button.h',
      'frame/caption_buttons/frame_caption_button_container_view.cc',
      'frame/caption_buttons/frame_caption_button_container_view.h',
      'frame/caption_buttons/frame_size_button.cc',
      'frame/caption_buttons/frame_size_button.h',
      'frame/caption_buttons/frame_size_button_delegate.h',
      'frame/custom_frame_view_ash.cc',
      'frame/custom_frame_view_ash.h',
      'frame/frame_border_hit_test_controller.cc',
      'frame/frame_border_hit_test_controller.h',
      'frame/default_header_painter.cc',
      'frame/default_header_painter.h',
      'frame/frame_util.cc',
      'frame/frame_util.h',
      'frame/header_painter.h',
      'frame/header_painter_util.cc',
      'frame/header_painter_util.h',
      'gpu_support.h',
      'gpu_support_stub.cc',
      'gpu_support_stub.h',
      'high_contrast/high_contrast_controller.cc',
      'high_contrast/high_contrast_controller.h',
      'host/ash_remote_window_tree_host_win.cc',
      'host/ash_remote_window_tree_host_win.h',
      'host/ash_window_tree_host.h',
      'host/ash_window_tree_host_init_params.cc',
      'host/ash_window_tree_host_init_params.h',
      'host/ash_window_tree_host_ozone.cc',
      'host/ash_window_tree_host_win.cc',
      'host/ash_window_tree_host_x11.cc',
      'host/ash_window_tree_host_x11.h',
      'host/root_window_transformer.h',
      'host/transformer_helper.cc',
      'host/transformer_helper.h',
      'ime/candidate_view.cc',
      'ime/candidate_view.h',
      'ime/candidate_window_view.cc',
      'ime/candidate_window_view.h',
      'ime/infolist_window.cc',
      'ime/infolist_window.h',
      'ime/input_method_menu_item.cc',
      'ime/input_method_menu_item.h',
      'ime/input_method_menu_manager.cc',
      'ime/input_method_menu_manager.h',
      'ime/mode_indicator_view.cc',
      'ime/mode_indicator_view.h',
      'keyboard_uma_event_filter.cc',
      'keyboard_uma_event_filter.h',
      'magnifier/magnification_controller.cc',
      'magnifier/magnification_controller.h',
      'magnifier/partial_magnification_controller.cc',
      'magnifier/partial_magnification_controller.h',
      'metrics/user_metrics_recorder.cc',
      'metrics/user_metrics_recorder.h',
      'multi_profile_uma.cc',
      'multi_profile_uma.h',
      'popup_message.cc',
      'popup_message.h',
      'root_window_controller.cc',
      'root_window_controller.h',
      'root_window_settings.cc',
      'root_window_settings.h',
      'rotator/screen_rotation.cc',
      'rotator/screen_rotation.h',
      'scoped_target_root_window.cc',
      'scoped_target_root_window.h',
      'screen_util.cc',
      'screen_util.h',
      'screenshot_delegate.h',
      'session/session_state_delegate.cc',
      'session/session_state_delegate.h',
      'session/session_state_observer.cc',
      'session/session_state_observer.h',
      'shelf/app_list_button.cc',
      'shelf/app_list_button.h',
      'shelf/app_list_shelf_item_delegate.cc',
      'shelf/app_list_shelf_item_delegate.h',
      'shelf/background_animator.cc',
      'shelf/background_animator.h',
      'shelf/overflow_bubble.cc',
      'shelf/overflow_bubble.h',
      'shelf/overflow_bubble_view.cc',
      'shelf/overflow_bubble_view.h',
      'shelf/overflow_button.cc',
      'shelf/overflow_button.h',
      'shelf/scoped_observer_with_duplicated_sources.h',
      'shelf/shelf.cc',
      'shelf/shelf.h',
      'shelf/shelf_alignment_menu.cc',
      'shelf/shelf_alignment_menu.h',
      'shelf/shelf_bezel_event_filter.cc',
      'shelf/shelf_bezel_event_filter.h',
      'shelf/shelf_button.cc',
      'shelf/shelf_button.h',
      'shelf/shelf_button_host.h',
      'shelf/shelf_constants.cc',
      'shelf/shelf_constants.h',
      'shelf/shelf_delegate.h',
      'shelf/shelf_icon_observer.h',
      'shelf/shelf_item_delegate.h',
      'shelf/shelf_item_delegate_manager.cc',
      'shelf/shelf_item_delegate_manager.h',
      'shelf/shelf_item_types.cc',
      'shelf/shelf_item_types.h',
      'shelf/shelf_layout_manager.cc',
      'shelf/shelf_layout_manager.h',
      'shelf/shelf_layout_manager_observer.h',
      'shelf/shelf_menu_model.h',
      'shelf/shelf_model.cc',
      'shelf/shelf_model.h',
      'shelf/shelf_model_observer.h',
      'shelf/shelf_navigator.cc',
      'shelf/shelf_navigator.h',
      'shelf/shelf_tooltip_manager.cc',
      'shelf/shelf_tooltip_manager.h',
      'shelf/shelf_types.h',
      'shelf/shelf_util.cc',
      'shelf/shelf_util.h',
      'shelf/shelf_view.cc',
      'shelf/shelf_view.h',
      'shelf/shelf_widget.cc',
      'shelf/shelf_widget.h',
      'shelf/shelf_window_watcher.cc',
      'shelf/shelf_window_watcher.h',
      'shelf/shelf_window_watcher_item_delegate.cc',
      'shelf/shelf_window_watcher_item_delegate.h',
      'shell.cc',
      'shell.h',
      'shell_delegate.h',
      'shell_factory.h',
      'shell_init_params.cc',
      'shell_init_params.h',
      'shell_window_ids.h',
      'snap_to_pixel_layout_manager.cc',
      'snap_to_pixel_layout_manager.h',
      'sticky_keys/sticky_keys_state.h',
      'sticky_keys/sticky_keys_controller.cc',
      'sticky_keys/sticky_keys_controller.h',
      'sticky_keys/sticky_keys_overlay.cc',
      'sticky_keys/sticky_keys_overlay.h',
      'switchable_windows.cc',
      'switchable_windows.h',
      'system/audio/audio_observer.h',
      'system/audio/tray_audio.cc',
      'system/audio/tray_audio.h',
      'system/audio/tray_audio_delegate.h',
      'system/audio/volume_view.cc',
      'system/audio/volume_view.h',
      'system/bluetooth/bluetooth_observer.h',
      'system/bluetooth/tray_bluetooth.cc',
      'system/bluetooth/tray_bluetooth.h',
      'system/brightness_control_delegate.h',
      'system/chromeos/audio/audio_detailed_view.cc',
      'system/chromeos/audio/audio_detailed_view.h',
      'system/chromeos/audio/tray_audio_chromeos.cc',
      'system/chromeos/audio/tray_audio_chromeos.h',
      'system/chromeos/audio/tray_audio_delegate_chromeos.cc',
      'system/chromeos/audio/tray_audio_delegate_chromeos.h',
      'system/chromeos/bluetooth/bluetooth_notification_controller.cc',
      'system/chromeos/bluetooth/bluetooth_notification_controller.h',
      'system/chromeos/brightness/brightness_controller_chromeos.cc',
      'system/chromeos/brightness/brightness_controller_chromeos.h',
      'system/chromeos/brightness/tray_brightness.cc',
      'system/chromeos/brightness/tray_brightness.h',
      'system/chromeos/enterprise/enterprise_domain_observer.h',
      'system/chromeos/enterprise/tray_enterprise.cc',
      'system/chromeos/enterprise/tray_enterprise.h',
      'system/chromeos/keyboard_brightness_controller.cc',
      'system/chromeos/keyboard_brightness_controller.h',
      'system/chromeos/label_tray_view.cc',
      'system/chromeos/label_tray_view.h',
      'system/chromeos/multi_user/user_switch_util.cc',
      'system/chromeos/multi_user/user_switch_util.h',
      'system/chromeos/network/network_detailed_view.h',
      'system/chromeos/network/network_observer.h',
      'system/chromeos/network/network_portal_detector_observer.h',
      'system/chromeos/network/network_state_list_detailed_view.cc',
      'system/chromeos/network/network_state_list_detailed_view.h',
      'system/chromeos/network/tray_network.cc',
      'system/chromeos/network/tray_network.h',
      'system/chromeos/network/tray_network_state_observer.cc',
      'system/chromeos/network/tray_network_state_observer.h',
      'system/chromeos/network/tray_sms.cc',
      'system/chromeos/network/tray_sms.h',
      'system/chromeos/network/tray_vpn.cc',
      'system/chromeos/network/tray_vpn.h',
      'system/chromeos/power/power_event_observer.cc',
      'system/chromeos/power/power_event_observer.h',
      'system/chromeos/power/power_status.cc',
      'system/chromeos/power/power_status.h',
      'system/chromeos/power/power_status_view.cc',
      'system/chromeos/power/power_status_view.h',
      'system/chromeos/power/tray_power.cc',
      'system/chromeos/power/tray_power.h',
      'system/chromeos/power/video_activity_notifier.cc',
      'system/chromeos/power/video_activity_notifier.h',
      'system/chromeos/rotation/tray_rotation_lock.cc',
      'system/chromeos/rotation/tray_rotation_lock.h',
      'system/chromeos/screen_security/screen_capture_observer.h',
      'system/chromeos/screen_security/screen_capture_tray_item.cc',
      'system/chromeos/screen_security/screen_capture_tray_item.h',
      'system/chromeos/screen_security/screen_share_observer.h',
      'system/chromeos/screen_security/screen_share_tray_item.cc',
      'system/chromeos/screen_security/screen_share_tray_item.h',
      'system/chromeos/screen_security/screen_tray_item.cc',
      'system/chromeos/screen_security/screen_tray_item.h',
      'system/chromeos/session/last_window_closed_observer.h',
      'system/chromeos/session/last_window_closed_logout_reminder.cc',
      'system/chromeos/session/last_window_closed_logout_reminder.h',
      'system/chromeos/session/logout_button_observer.h',
      'system/chromeos/session/logout_button_tray.cc',
      'system/chromeos/session/logout_button_tray.h',
      'system/chromeos/session/logout_confirmation_controller.cc',
      'system/chromeos/session/logout_confirmation_controller.h',
      'system/chromeos/session/logout_confirmation_dialog.cc',
      'system/chromeos/session/logout_confirmation_dialog.h',
      'system/chromeos/session/session_length_limit_observer.h',
      'system/chromeos/session/tray_session_length_limit.cc',
      'system/chromeos/session/tray_session_length_limit.h',
      'system/chromeos/settings/tray_settings.cc',
      'system/chromeos/settings/tray_settings.h',
      'system/chromeos/supervised/custodian_info_tray_observer.h',
      'system/chromeos/supervised/tray_supervised_user.cc',
      'system/chromeos/supervised/tray_supervised_user.h',
      'system/chromeos/system_clock_observer.cc',
      'system/chromeos/system_clock_observer.h',
      'system/chromeos/tray_caps_lock.cc',
      'system/chromeos/tray_caps_lock.h',
      'system/chromeos/tray_display.cc',
      'system/chromeos/tray_display.h',
      'system/chromeos/tray_tracing.cc',
      'system/chromeos/tray_tracing.h',
      'system/chromeos/virtual_keyboard/tray_keyboard_lock.cc',
      'system/chromeos/virtual_keyboard/tray_keyboard_lock.h',
      'system/chromeos/virtual_keyboard/tray_keyboard_lock_unittest.h',
      'system/chromeos/virtual_keyboard/virtual_keyboard_tray.cc',
      'system/chromeos/virtual_keyboard/virtual_keyboard_tray.h',
      'system/chromeos/virtual_keyboard/virtual_keyboard_observer.h',
      'system/date/clock_observer.h',
      'system/date/date_default_view.cc',
      'system/date/date_default_view.h',
      'system/date/date_view.cc',
      'system/date/date_view.h',
      'system/date/tray_date.cc',
      'system/date/tray_date.h',
      'system/ime/ime_observer.h',
      'system/ime/tray_ime.cc',
      'system/ime/tray_ime.h',
      'system/keyboard_brightness/keyboard_brightness_control_delegate.h',
      'system/locale/locale_notification_controller.cc',
      'system/locale/locale_notification_controller.h',
      'system/overview/overview_button_tray.h',
      'system/overview/overview_button_tray.cc',
      'system/status_area_widget.cc',
      'system/status_area_widget.h',
      'system/status_area_widget_delegate.cc',
      'system/status_area_widget_delegate.h',
      'system/system_notifier.cc',
      'system/system_notifier.h',
      'system/tray/actionable_view.cc',
      'system/tray/actionable_view.h',
      'system/tray/default_system_tray_delegate.cc',
      'system/tray/default_system_tray_delegate.h',
      'system/tray/fixed_sized_image_view.cc',
      'system/tray/fixed_sized_image_view.h',
      'system/tray/fixed_sized_scroll_view.cc',
      'system/tray/fixed_sized_scroll_view.h',
      'system/tray/hover_highlight_view.cc',
      'system/tray/hover_highlight_view.h',
      'system/tray/media_security/media_capture_observer.h',
      'system/tray/media_security/multi_profile_media_tray_item.cc',
      'system/tray/media_security/multi_profile_media_tray_item.h',
      'system/tray/special_popup_row.cc',
      'system/tray/special_popup_row.h',
      'system/tray/system_tray.cc',
      'system/tray/system_tray.h',
      'system/tray/system_tray_bubble.cc',
      'system/tray/system_tray_bubble.h',
      'system/tray/system_tray_delegate.cc',
      'system/tray/system_tray_delegate.h',
      'system/tray/system_tray_item.cc',
      'system/tray/system_tray_item.h',
      'system/tray/system_tray_notifier.cc',
      'system/tray/system_tray_notifier.h',
      'system/tray/throbber_view.cc',
      'system/tray/throbber_view.h',
      'system/tray/tray_background_view.cc',
      'system/tray/tray_background_view.h',
      'system/tray/tray_bar_button_with_title.cc',
      'system/tray/tray_bar_button_with_title.h',
      'system/tray/tray_bubble_wrapper.cc',
      'system/tray/tray_bubble_wrapper.h',
      'system/tray/tray_constants.cc',
      'system/tray/tray_constants.h',
      'system/tray/tray_details_view.cc',
      'system/tray/tray_details_view.h',
      'system/tray/tray_empty.cc',
      'system/tray/tray_empty.h',
      'system/tray/tray_event_filter.cc',
      'system/tray/tray_event_filter.h',
      'system/tray/tray_image_item.cc',
      'system/tray/tray_image_item.h',
      'system/tray/tray_item_more.cc',
      'system/tray/tray_item_more.h',
      'system/tray/tray_item_view.cc',
      'system/tray/tray_item_view.h',
      'system/tray/tray_notification_view.cc',
      'system/tray/tray_notification_view.h',
      'system/tray/tray_popup_header_button.cc',
      'system/tray/tray_popup_header_button.h',
      'system/tray/tray_popup_item_container.cc',
      'system/tray/tray_popup_item_container.h',
      'system/tray/tray_popup_label_button.cc',
      'system/tray/tray_popup_label_button.h',
      'system/tray/tray_popup_label_button_border.cc',
      'system/tray/tray_popup_label_button_border.h',
      'system/tray/tray_utils.cc',
      'system/tray/tray_utils.h',
      'system/tray/view_click_listener.h',
      'system/tray_accessibility.cc',
      'system/tray_accessibility.h',
      'system/tray_update.cc',
      'system/tray_update.h',
      'system/user/accounts_detailed_view.cc',
      'system/user/accounts_detailed_view.h',
      'system/user/config.cc',
      'system/user/config.h',
      'system/user/button_from_view.cc',
      'system/user/button_from_view.h',
      'system/user/login_status.cc',
      'system/user/login_status.h',
      'system/user/rounded_image_view.cc',
      'system/user/rounded_image_view.h',
      'system/user/tray_user.cc',
      'system/user/tray_user.h',
      'system/user/tray_user_separator.cc',
      'system/user/tray_user_separator.h',
      'system/user/update_observer.h',
      'system/user/user_observer.h',
      'system/user/user_accounts_delegate.cc',
      'system/user/user_accounts_delegate.h',
      'system/user/user_card_view.cc',
      'system/user/user_card_view.h',
      'system/user/user_view.cc',
      'system/user/user_view.h',
      'system/web_notification/ash_popup_alignment_delegate.cc',
      'system/web_notification/ash_popup_alignment_delegate.h',
      'system/web_notification/web_notification_tray.cc',
      'system/web_notification/web_notification_tray.h',
      'system/win/audio/tray_audio_delegate_win.cc',
      'system/win/audio/tray_audio_delegate_win.h',
      'system/win/audio/tray_audio_win.cc',
      'system/win/audio/tray_audio_win.h',
      'touch/touch_hud_debug.cc',
      'touch/touch_hud_debug.h',
      'touch/touch_hud_projection.cc',
      'touch/touch_hud_projection.h',
      'touch/touch_observer_hud.cc',
      'touch/touch_observer_hud.h',
      'touch/touch_transformer_controller.cc',
      'touch/touch_transformer_controller.h',
      'touch/touch_uma.cc',
      'touch/touch_uma.h',
      'touch/touchscreen_util.cc',
      'touch/touchscreen_util.h',
      'virtual_keyboard_controller.cc',
      'virtual_keyboard_controller.h',
      'volume_control_delegate.h',
      'wm/app_list_controller.cc',
      'wm/app_list_controller.h',
      'wm/always_on_top_controller.cc',
      'wm/always_on_top_controller.h',
      'wm/ash_native_cursor_manager.cc',
      'wm/ash_native_cursor_manager.h',
      'wm/ash_focus_rules.cc',
      'wm/ash_focus_rules.h',
      'wm/boot_splash_screen_chromeos.cc',
      'wm/boot_splash_screen_chromeos.h',
      'wm/cursor_manager_chromeos.cc',
      'wm/cursor_manager_chromeos.h',
      'wm/coordinate_conversion.cc',
      'wm/coordinate_conversion.h',
      'wm/default_state.cc',
      'wm/default_state.h',
      'wm/default_window_resizer.cc',
      'wm/default_window_resizer.h',
      'wm/dock/docked_window_layout_manager.cc',
      'wm/dock/docked_window_layout_manager.h',
      'wm/dock/docked_window_layout_manager_observer.h',
      'wm/dock/docked_window_resizer.cc',
      'wm/dock/docked_window_resizer.h',
      'wm/drag_details.cc',
      'wm/drag_details.h',
      'wm/drag_window_controller.cc',
      'wm/drag_window_controller.h',
      'wm/drag_window_resizer.cc',
      'wm/drag_window_resizer.h',
      'wm/event_client_impl.cc',
      'wm/event_client_impl.h',
      'wm/gestures/long_press_affordance_handler.cc',
      'wm/gestures/long_press_affordance_handler.h',
      'wm/gestures/overview_gesture_handler.cc',
      'wm/gestures/overview_gesture_handler.h',
      'wm/gestures/shelf_gesture_handler.cc',
      'wm/gestures/shelf_gesture_handler.h',
      'wm/gestures/tray_gesture_handler.cc',
      'wm/gestures/tray_gesture_handler.h',
      'wm/immersive_fullscreen_controller.cc',
      'wm/immersive_fullscreen_controller.h',
      'wm/immersive_revealed_lock.cc',
      'wm/immersive_revealed_lock.h',
      'wm/lock_layout_manager.cc',
      'wm/lock_layout_manager.h',
      'wm/lock_state_controller.cc',
      'wm/lock_state_controller.h',
      'wm/lock_state_observer.h',
      'wm/lock_window_state.cc',
      'wm/lock_window_state.h',
      'wm/maximize_mode/maximize_mode_controller.cc',
      'wm/maximize_mode/maximize_mode_controller.h',
      'wm/maximize_mode/maximize_mode_window_manager.cc',
      'wm/maximize_mode/maximize_mode_window_manager.h',
      'wm/maximize_mode/maximize_mode_window_state.cc',
      'wm/maximize_mode/maximize_mode_window_state.h',
      'wm/maximize_mode/scoped_disable_internal_mouse_and_keyboard.h',
      'wm/maximize_mode/scoped_disable_internal_mouse_and_keyboard_x11.cc',
      'wm/maximize_mode/scoped_disable_internal_mouse_and_keyboard_x11.h',
      'wm/maximize_mode/workspace_backdrop_delegate.cc',
      'wm/maximize_mode/workspace_backdrop_delegate.h',
      'wm/mru_window_tracker.cc',
      'wm/mru_window_tracker.h',
      'wm/overlay_event_filter.cc',
      'wm/overlay_event_filter.h',
      'wm/overview/scoped_transform_overview_window.cc',
      'wm/overview/scoped_transform_overview_window.h',
      'wm/overview/scoped_window_copy.cc',
      'wm/overview/scoped_window_copy.h',
      'wm/overview/window_grid.cc',
      'wm/overview/window_grid.h',
      'wm/overview/window_selector.cc',
      'wm/overview/window_selector.h',
      'wm/window_cycle_controller.cc',
      'wm/window_cycle_controller.h',
      'wm/window_cycle_list.cc',
      'wm/window_cycle_list.h',
      'wm/overview/transparent_activate_window_button.cc',
      'wm/overview/transparent_activate_window_button.h',
      'wm/overview/window_selector_controller.cc',
      'wm/overview/window_selector_controller.h',
      'wm/overview/window_selector_delegate.h',
      'wm/overview/window_selector_item.cc',
      'wm/overview/window_selector_item.h',
      'wm/overview/window_selector_panels.cc',
      'wm/overview/window_selector_panels.h',
      'wm/overview/window_selector_window.cc',
      'wm/overview/window_selector_window.h',
      'wm/panels/attached_panel_window_targeter.cc',
      'wm/panels/attached_panel_window_targeter.h',
      'wm/panels/panel_frame_view.cc',
      'wm/panels/panel_frame_view.h',
      'wm/panels/panel_layout_manager.cc',
      'wm/panels/panel_layout_manager.h',
      'wm/panels/panel_window_event_handler.cc',
      'wm/panels/panel_window_event_handler.h',
      'wm/panels/panel_window_resizer.cc',
      'wm/panels/panel_window_resizer.h',
      'wm/partial_screenshot_view.cc',
      'wm/partial_screenshot_view.h',
      'wm/power_button_controller.cc',
      'wm/power_button_controller.h',
      'wm/resize_handle_window_targeter.cc',
      'wm/resize_handle_window_targeter.h',
      'wm/resize_shadow.cc',
      'wm/resize_shadow.h',
      'wm/resize_shadow_controller.cc',
      'wm/resize_shadow_controller.h',
      'wm/root_window_layout_manager.cc',
      'wm/root_window_layout_manager.h',
      'wm/screen_dimmer.cc',
      'wm/screen_dimmer.h',
      'wm/session_state_animator.cc',
      'wm/session_state_animator.h',
      'wm/session_state_animator_impl.cc',
      'wm/session_state_animator_impl.h',
      'wm/stacking_controller.cc',
      'wm/stacking_controller.h',
      'wm/status_area_layout_manager.cc',
      'wm/status_area_layout_manager.h',
      'wm/system_background_controller.cc',
      'wm/system_background_controller.h',
      'wm/system_gesture_event_filter.cc',
      'wm/system_gesture_event_filter.h',
      'wm/system_modal_container_event_filter.cc',
      'wm/system_modal_container_event_filter.h',
      'wm/system_modal_container_event_filter_delegate.h',
      'wm/system_modal_container_layout_manager.cc',
      'wm/system_modal_container_layout_manager.h',
      'wm/toplevel_window_event_handler.cc',
      'wm/toplevel_window_event_handler.h',
      'wm/video_detector.cc',
      'wm/video_detector.h',
      "wm/virtual_keyboard_container_layout_manager.cc",
      "wm/virtual_keyboard_container_layout_manager.h",
      'wm/window_animations.cc',
      'wm/window_animations.h',
      'wm/window_positioner.cc',
      'wm/window_positioner.h',
      'wm/window_state.cc',
      'wm/window_state.h',
      'wm/window_state_delegate.cc',
      'wm/window_state_delegate.h',
      'wm/window_state_observer.h',
      'wm/window_state_util.cc',
      'wm/window_state_util.h',
      'wm/window_properties.cc',
      'wm/window_properties.h',
      'wm/window_resizer.cc',
      'wm/window_resizer.h',
      'wm/window_util.cc',
      'wm/window_util.h',
      'wm/wm_event.cc',
      'wm/wm_event.h',
      'wm/wm_types.cc',
      'wm/wm_types.h',
      'wm/workspace_controller.cc',
      'wm/workspace_controller.h',
      'wm/workspace/magnetism_matcher.cc',
      'wm/workspace/magnetism_matcher.h',
      'wm/workspace/multi_window_resize_controller.cc',
      'wm/workspace/multi_window_resize_controller.h',
      'wm/workspace/phantom_window_controller.cc',
      'wm/workspace/phantom_window_controller.h',
      'wm/workspace/two_step_edge_cycler.cc',
      'wm/workspace/two_step_edge_cycler.h',
      'wm/workspace/workspace_event_handler.cc',
      'wm/workspace/workspace_event_handler.h',
      'wm/workspace/workspace_layout_manager.cc',
      'wm/workspace/workspace_layout_manager.h',
      'wm/workspace/workspace_layout_manager_delegate.h',
      'wm/workspace/workspace_types.h',
      'wm/workspace/workspace_window_resizer.cc',
      'wm/workspace/workspace_window_resizer.h',
    ],
    'ash_test_support_sources': [
      'desktop_background/desktop_background_controller_test_api.cc',
      'desktop_background/desktop_background_controller_test_api.h',
      'shell/keyboard_controller_proxy_stub.cc',
      'shell/keyboard_controller_proxy_stub.h',
      'shell/toplevel_window.cc',
      'shell/toplevel_window.h',
      'test/app_list_controller_test_api.cc',
      'test/app_list_controller_test_api.h',
      'test/ash_test_base.cc',
      'test/ash_test_base.h',
      'test/ash_test_helper.cc',
      'test/ash_test_helper.h',
      'test/ash_test_views_delegate.cc',
      'test/ash_test_views_delegate.h',
      'test/child_modal_window.cc',
      'test/child_modal_window.h',
      'test/cursor_manager_test_api.cc',
      'test/cursor_manager_test_api.h',
      'test/display_manager_test_api.cc',
      'test/display_manager_test_api.h',
      'test/mirror_window_test_api.cc',
      'test/mirror_window_test_api.h',
      'test/overflow_bubble_view_test_api.cc',
      'test/overflow_bubble_view_test_api.h',
      'test/shelf_item_delegate_manager_test_api.cc',
      'test/shelf_item_delegate_manager_test_api.h',
      'test/shelf_test_api.cc',
      'test/shelf_test_api.h',
      'test/shelf_view_test_api.cc',
      'test/shelf_view_test_api.h',
      'test/shell_test_api.cc',
      'test/shell_test_api.h',
      'test/status_area_widget_test_helper.cc',
      'test/status_area_widget_test_helper.h',
      'test/test_activation_delegate.cc',
      'test/test_activation_delegate.h',
      'test/test_lock_state_controller_delegate.cc',
      'test/test_lock_state_controller_delegate.h',
      'test/test_overlay_delegate.cc',
      'test/test_overlay_delegate.h',
      'test/test_screenshot_delegate.cc',
      'test/test_screenshot_delegate.h',
      'test/test_session_state_animator.cc',
      'test/test_session_state_animator.h',
      'test/test_session_state_delegate.cc',
      'test/test_session_state_delegate.h',
      'test/test_shelf_delegate.cc',
      'test/test_shelf_delegate.h',
      'test/test_shelf_item_delegate.cc',
      'test/test_shelf_item_delegate.h',
      'test/test_shell_delegate.cc',
      'test/test_shell_delegate.h',
      'test/test_suite.cc',
      'test/test_suite.h',
      'test/test_suite_init.h',
      'test/test_suite_init.mm',
      'test/test_system_tray_delegate.cc',
      'test/test_system_tray_delegate.h',
      'test/test_user_wallpaper_delegate.cc',
      'test/test_user_wallpaper_delegate.h',
      'test/test_volume_control_delegate.cc',
      'test/test_volume_control_delegate.h',
      'test/ui_controls_factory_ash.cc',
      'test/ui_controls_factory_ash.h',
      'test/virtual_keyboard_test_helper.cc',
      'test/virtual_keyboard_test_helper.h',
    ],
    'ash_shell_lib_sources': [
      '../ui/views/test/test_views_delegate_aura.cc',
      'shell/app_list.cc',
      'shell/bubble.cc',
      'shell/content_client/shell_browser_main_parts.cc',
      'shell/content_client/shell_browser_main_parts.h',
      'shell/content_client/shell_content_browser_client.cc',
      'shell/content_client/shell_content_browser_client.h',
      'shell/content_client/shell_main_delegate.cc',
      'shell/content_client/shell_main_delegate.h',
      'shell/context_menu.cc',
      'shell/context_menu.h',
      'shell/example_factory.h',
      'shell/keyboard_controller_proxy_stub.cc',
      'shell/keyboard_controller_proxy_stub.h',
      'shell/lock_view.cc',
      'shell/panel_window.cc',
      'shell/panel_window.h',
      'shell/shelf_delegate_impl.cc',
      'shell/shelf_delegate_impl.h',
      'shell/shell_delegate_impl.cc',
      'shell/shell_delegate_impl.h',
      'shell/shell_main_parts.cc',
      'shell/shell_main_parts.h',
      'shell/toplevel_window.cc',
      'shell/toplevel_window.h',
      'shell/widgets.cc',
      'shell/window_type_launcher.cc',
      'shell/window_type_launcher.h',
      'shell/window_watcher.cc',
      'shell/window_watcher.h',
      'shell/window_watcher_shelf_item_delegate.cc',
      'shell/window_watcher_shelf_item_delegate.h',
    ],
    'ash_unittests_sources': [
      'accelerators/accelerator_commands_unittest.cc',
      'accelerators/accelerator_controller_unittest.cc',
      'accelerators/accelerator_filter_unittest.cc',
      'accelerators/accelerator_table_unittest.cc',
      'accelerators/magnifier_key_scroller_unittest.cc',
      'accelerators/spoken_feedback_toggler_unittest.cc',
      'ash_touch_exploration_manager_chromeos_unittest.cc',
      'autoclick/autoclick_unittest.cc',
      'desktop_background/desktop_background_controller_unittest.cc',
      'desktop_background/wallpaper_resizer_unittest.cc',
      'dip_unittest.cc',
      'display/display_change_observer_chromeos_unittest.cc',
      'display/display_controller_unittest.cc',
      'display/display_error_observer_chromeos_unittest.cc',
      'display/display_info_unittest.cc',
      'display/display_manager_unittest.cc',
      'display/mirror_window_controller_unittest.cc',
      'display/mouse_cursor_event_filter_unittest.cc',
      'display/projecting_observer_chromeos_unittest.cc',
      'display/resolution_notification_controller_unittest.cc',
      'display/root_window_transformers_unittest.cc',
      'display/screen_position_controller_unittest.cc',
      'drag_drop/drag_drop_controller_unittest.cc',
      'drag_drop/drag_drop_tracker_unittest.cc',
      'extended_desktop_unittest.cc',
      'focus_cycler_unittest.cc',
      'frame/caption_buttons/frame_caption_button_container_view_unittest.cc',
      'frame/caption_buttons/frame_size_button_unittest.cc',
      'frame/custom_frame_view_ash_unittest.cc',
      'frame/default_header_painter_unittest.cc',
      'host/ash_window_tree_host_x11_unittest.cc',
      'ime/candidate_view_unittest.cc',
      'ime/candidate_window_view_unittest.cc',
      'ime/input_method_menu_item_unittest.cc',
      'ime/input_method_menu_manager_unittest.cc',
      'keyboard_overlay/keyboard_overlay_delegate_unittest.cc',
      'keyboard_overlay/keyboard_overlay_view_unittest.cc',
      'magnifier/magnification_controller_unittest.cc',
      'root_window_controller_unittest.cc',
      'screen_util_unittest.cc',
      'screensaver/screensaver_view_unittest.cc',
      'shelf/scoped_observer_with_duplicated_sources_unittest.cc',
      'shelf/shelf_layout_manager_unittest.cc',
      'shelf/shelf_model_unittest.cc',
      'shelf/shelf_navigator_unittest.cc',
      'shelf/shelf_tooltip_manager_unittest.cc',
      'shelf/shelf_unittest.cc',
      'shelf/shelf_view_unittest.cc',
      'shelf/shelf_widget_unittest.cc',
      'shelf/shelf_window_watcher_unittest.cc',
      'shell_unittest.cc',
      'sticky_keys/sticky_keys_overlay_unittest.cc',
      'sticky_keys/sticky_keys_unittest.cc',
      'system/chromeos/brightness/tray_brightness_unittest.cc',
      'system/chromeos/power/power_event_observer_unittest.cc',
      'system/chromeos/power/power_status_unittest.cc',
      'system/chromeos/power/power_status_view_unittest.cc',
      'system/chromeos/power/tray_power_unittest.cc',
      'system/chromeos/rotation/tray_rotation_lock_unittest.cc',
      'system/chromeos/multi_user/user_switch_util_unittest.cc',
      'system/chromeos/screen_security/screen_tray_item_unittest.cc',
      'system/chromeos/session/logout_confirmation_controller_unittest.cc',
      'system/chromeos/session/tray_session_length_limit_unittest.cc',
      'system/chromeos/supervised/tray_supervised_user_unittest.cc',
      'system/chromeos/tray_display_unittest.cc',
      'system/chromeos/virtual_keyboard/tray_keyboard_lock_unittest.cc',
      'system/date/date_view_unittest.cc',
      'system/overview/overview_button_tray_unittest.cc',
      'system/tray/media_security/multi_profile_media_tray_item_unittest.cc',
      'system/tray/system_tray_unittest.cc',
      'system/tray/tray_details_view_unittest.cc',
      'system/user/tray_user_unittest.cc',
      'system/web_notification/ash_popup_alignment_delegate_unittest.cc',
      'system/web_notification/web_notification_tray_unittest.cc',
      'test/ash_test_helper_unittest.cc',
      'test/ash_unittests.cc',
      'tooltips/tooltip_controller_unittest.cc',
      'touch/touch_observer_hud_unittest.cc',
      'touch/touch_transformer_controller_unittest.cc',
      'touch/touchscreen_util_unittest.cc',
      'virtual_keyboard_controller_unittest.cc',
      'wm/app_list_controller_unittest.cc',
      'wm/ash_native_cursor_manager_unittest.cc',
      'wm/dock/docked_window_layout_manager_unittest.cc',
      'wm/dock/docked_window_resizer_unittest.cc',
      'wm/drag_window_resizer_unittest.cc',
      'wm/gestures/overview_gesture_handler_unittest.cc',
      'wm/immersive_fullscreen_controller_unittest.cc',
      'wm/lock_layout_manager_unittest.cc',
      'wm/lock_state_controller_unittest.cc',
      'wm/maximize_mode/accelerometer_test_data_literals.cc',
      'wm/maximize_mode/maximize_mode_controller_unittest.cc',
      'wm/maximize_mode/maximize_mode_window_manager_unittest.cc',
      'wm/mru_window_tracker_unittest.cc',
      'wm/overview/window_selector_unittest.cc',
      'wm/panels/panel_layout_manager_unittest.cc',
      'wm/panels/panel_window_resizer_unittest.cc',
      'wm/partial_screenshot_view_unittest.cc',
      'wm/resize_shadow_and_cursor_unittest.cc',
      'wm/screen_dimmer_unittest.cc',
      'wm/stacking_controller_unittest.cc',
      'wm/system_gesture_event_filter_unittest.cc',
      'wm/system_modal_container_layout_manager_unittest.cc',
      'wm/toplevel_window_event_handler_unittest.cc',
      'wm/video_detector_unittest.cc',
      'wm/window_animations_unittest.cc',
      'wm/window_cycle_controller_unittest.cc',
      'wm/window_manager_unittest.cc',
      'wm/window_modality_controller_unittest.cc',
      'wm/window_positioner_unittest.cc',
      'wm/window_state_unittest.cc',
      'wm/window_util_unittest.cc',
      'wm/overlay_event_filter_unittest.cc',
      'wm/workspace/magnetism_matcher_unittest.cc',
      'wm/workspace/multi_window_resize_controller_unittest.cc',
      'wm/workspace/workspace_event_handler_test_helper.cc',
      'wm/workspace/workspace_event_handler_test_helper.h',
      'wm/workspace/workspace_event_handler_unittest.cc',
      'wm/workspace/workspace_layout_manager_unittest.cc',
      'wm/workspace/workspace_window_resizer_unittest.cc',
      'wm/workspace_controller_test_helper.cc',
      'wm/workspace_controller_test_helper.h',
      'wm/workspace_controller_unittest.cc',
    ],
  },
  'targets': [
    {
      # GN version: //ash
      'target_name': 'ash',
      'type': '<(component)',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
        '../cc/cc.gyp:cc',
        '../components/components.gyp:user_manager',
        '../content/content.gyp:content_browser',
        '../media/media.gyp:media',
        '../net/net.gyp:net',
        '../skia/skia.gyp:skia',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../ui/accelerometer/ui_accelerometer.gyp:ui_accelerometer',
        '../ui/accessibility/accessibility.gyp:accessibility',
        '../ui/app_list/app_list.gyp:app_list',
        '../ui/aura/aura.gyp:aura',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/compositor/compositor.gyp:compositor',
        '../ui/events/devices/events_devices.gyp:events_devices',
        '../ui/events/events.gyp:events',
        '../ui/events/events.gyp:events_base',
        '../ui/events/events.gyp:gesture_detection',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/keyboard/keyboard.gyp:keyboard',
        '../ui/message_center/message_center.gyp:message_center',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/strings/ui_strings.gyp:ui_strings',
        '../ui/views/controls/webview/webview.gyp:webview',
        '../ui/views/views.gyp:views',
        '../ui/web_dialogs/web_dialogs.gyp:web_dialogs',
        '../ui/wm/wm.gyp:wm',
        '../url/url.gyp:url_lib',
        'ash_resources.gyp:ash_resources',
        'ash_strings.gyp:ash_strings',
      ],
      'defines': [
        'ASH_IMPLEMENTATION',
      ],
      'sources': [
        '<@(ash_sources)',
      ],
      'conditions': [
        ['OS=="win"', {
          'sources!': [
            # Note: sources list duplicated in GN build.
            "sticky_keys/sticky_keys_controller.cc",
            "sticky_keys/sticky_keys_controller.h",
          ],
          # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
          'msvs_disabled_warnings': [ 4267, ],
        }],
        ['use_x11!=1', {
          'sources!': [
            # Note: sources list duplicated in GN build.
            'accelerators/key_hold_detector.cc',
            'accelerators/key_hold_detector.h',
            'accelerators/magnifier_key_scroller.cc',
            'accelerators/magnifier_key_scroller.h',
            'accelerators/spoken_feedback_toggler.cc',
            'accelerators/spoken_feedback_toggler.h',
          ],
        }, { # else: use_x11==1
          'dependencies': [
            '../build/linux/system.gyp:xfixes',
           ],
        }],
        ['chromeos==1', {
          'dependencies': [
            '../chromeos/chromeos.gyp:chromeos',
            # Ash #includes power_supply_properties.pb.h directly.
            '../chromeos/chromeos.gyp:power_manager_proto',
            '../device/bluetooth/bluetooth.gyp:device_bluetooth',
            '../ui/chromeos/ui_chromeos.gyp:ui_chromeos_resources',
            '../ui/chromeos/ui_chromeos.gyp:ui_chromeos_strings',
            '../ui/chromeos/ui_chromeos.gyp:ui_chromeos',
            '../ui/display/display.gyp:display',
            '../ui/display/display.gyp:display_util',
          ],
        }, { # else: chromeos!=1
          'sources!': [
            'display/display_configurator_animation.cc',
            'display/display_configurator_animation.h',
            'display/resolution_notification_controller.cc',
            'display/resolution_notification_controller.h',
            'system/tray/media_security/media_capture_observer.h',
            'system/tray/media_security/multi_profile_media_tray_item.cc',
            'system/tray/media_security/multi_profile_media_tray_item.h',
            'touch/touch_transformer_controller.cc',
            'touch/touch_transformer_controller.h',
            'touch/touchscreen_util.cc',
            'touch/touchscreen_util.h',
            'virtual_keyboard_controller.cc',
            'virtual_keyboard_controller.h'
          ],
        }],
      ],
    },
    {
      # GN version: //ash:ash_with_content
      'target_name': 'ash_with_content',
      'type': '<(component)',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
        '../content/content.gyp:content_browser',
        '../ipc/ipc.gyp:ipc',
        '../skia/skia.gyp:skia',
        '../ui/aura/aura.gyp:aura',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/compositor/compositor.gyp:compositor',
        '../ui/events/events.gyp:events',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/strings/ui_strings.gyp:ui_strings',
        '../ui/views/controls/webview/webview.gyp:webview',
        '../ui/views/views.gyp:views',
        '../ui/web_dialogs/web_dialogs.gyp:web_dialogs',
        '../url/url.gyp:url_lib',
        'ash',
        'ash_resources.gyp:ash_resources',
        'ash_strings.gyp:ash_strings',
      ],
      'defines': [
        'ASH_WITH_CONTENT_IMPLEMENTATION',
      ],
      'sources': [
        # Note: sources list duplicated in GN build.
        'content_support/ash_with_content_export.h',
        'content_support/gpu_support_impl.cc',
        'content_support/gpu_support_impl.h',
        'screensaver/screensaver_view.cc',
        'screensaver/screensaver_view.h',
        'keyboard_overlay/keyboard_overlay_delegate.cc',
        'keyboard_overlay/keyboard_overlay_delegate.h',
        'keyboard_overlay/keyboard_overlay_view.cc',
        'keyboard_overlay/keyboard_overlay_view.h',
      ],
    },
    {
      # GN version: //ash:test_support
      'target_name': 'ash_test_support',
      'type': 'static_library',
      'dependencies': [
        '../skia/skia.gyp:skia',
        '../testing/gtest.gyp:gtest',
        '../ui/accessibility/accessibility.gyp:ax_gen',
        '../ui/app_list/app_list.gyp:app_list_test_support',
        '../ui/events/devices/events_devices.gyp:events_devices',
        '../ui/views/views.gyp:views_test_support',
        'ash',
        'ash_resources.gyp:ash_resources',
      ],
      'sources': [
        '<@(ash_test_support_sources)',
      ],
      'conditions': [
        ['OS=="win"', {
          'dependencies': [
            '../ipc/ipc.gyp:ipc',
            '../ui/metro_viewer/metro_viewer.gyp:metro_viewer_messages',
            '../ui/platform_window/win/win_window.gyp:win_window',
            '../win8/win8.gyp:metro_viewer',
            '../win8/win8.gyp:test_support_win8',
            '../win8/win8_tests.gyp:test_registrar',
          ],
          'sources': [
            'test/test_metro_viewer_process_host.cc',
            'test/test_metro_viewer_process_host.h',
          ],
        }],
      ],
    },
    {
      # GN version: //ash:ash_unittests
      'target_name': 'ash_unittests',
      'type': 'executable',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:test_support_base',
        '../chrome/chrome_resources.gyp:packed_resources',
        '../components/components.gyp:user_manager',
        '../content/content.gyp:content_browser',
        '../content/content_shell_and_tests.gyp:test_support_content',
        '../skia/skia.gyp:skia',
        '../testing/gtest.gyp:gtest',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../ui/accelerometer/ui_accelerometer.gyp:ui_accelerometer',
        '../ui/accessibility/accessibility.gyp:accessibility',
        '../ui/app_list/app_list.gyp:app_list',
        '../ui/aura/aura.gyp:aura',
        '../ui/aura/aura.gyp:aura_test_support',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/base/ui_base.gyp:ui_base_test_support',
        '../ui/compositor/compositor.gyp:compositor',
        '../ui/compositor/compositor.gyp:compositor_test_support',
        '../ui/events/devices/events_devices.gyp:events_devices',
        '../ui/events/events.gyp:events',
        '../ui/events/events.gyp:events_test_support',
        '../ui/events/events.gyp:gesture_detection',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/keyboard/keyboard.gyp:keyboard',
        '../ui/message_center/message_center.gyp:message_center',
        '../ui/message_center/message_center.gyp:message_center_test_support',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/views/controls/webview/webview_tests.gyp:webview_test_support',
        '../ui/views/views.gyp:views',
        '../ui/views/views.gyp:views_test_support',
        '../ui/web_dialogs/web_dialogs.gyp:web_dialogs_test_support',
        '../ui/wm/wm.gyp:wm',
        '../url/url.gyp:url_lib',
        'ash',
        'ash_resources.gyp:ash_resources',
        'ash_strings.gyp:ash_strings',
        'ash_test_support',
        'ash_with_content',
      ],
      'sources': [
        '<@(ash_unittests_sources)',
      ],
      'conditions': [
        ['chromeos==0', {
          'sources!': [
            # TODO(zork): fix this test to build on Windows. See: crosbug.com/26906
            'focus_cycler_unittest.cc',
            # All tests for multiple displays: not supported on Windows Ash.
            'wm/drag_window_resizer_unittest.cc',
            # Can't resize on Windows Ash. http://crbug.com/165962
            'magnifier/magnification_controller_unittest.cc',
            'wm/workspace/workspace_window_resizer_unittest.cc',
            'sticky_keys/sticky_keys_overlay_unittest.cc',
            'sticky_keys/sticky_keys_unittest.cc',
            'system/tray/media_security/multi_profile_media_tray_item_unittest.cc',
            'autoclick/autoclick_unittest.cc',
            "virtual_keyboard_controller_unittest.cc"
          ],
          'sources': [
            '<(SHARED_INTERMEDIATE_DIR)/ui/resources/ui_unscaled_resources.rc',
          ],
          # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
          'msvs_disabled_warnings': [ 4267, ],
        }],
        ['OS=="win" and win_use_allocator_shim==1', {
          'dependencies': [
            '../base/allocator/allocator.gyp:allocator',
          ],
        }],
        ['use_x11!=1', {
          'sources!': [
            'accelerators/magnifier_key_scroller_unittest.cc',
            'accelerators/spoken_feedback_toggler_unittest.cc',
          ],
        }],
        ['chromeos==1', {
          'dependencies': [
            '../chromeos/chromeos.gyp:chromeos_test_support_without_gmock',
            '../chromeos/chromeos.gyp:power_manager_proto',
            '../device/bluetooth/bluetooth.gyp:device_bluetooth',
            '../ui/display/display.gyp:display',
            '../ui/display/display.gyp:display_test_util',
            '../ui/display/display.gyp:display_types',
          ],
          'sources': [
            'first_run/first_run_helper_unittest.cc',
          ],
        }, { # else: chromeos!=1
          'sources!': [
            'display/resolution_notification_controller_unittest.cc',
            'touch/touch_transformer_controller_unittest.cc',
            'touch/touchscreen_util_unittest.cc',
          ],
        }],
        ['OS=="linux" and component=="shared_library" and use_allocator!="none"', {
          'dependencies': [
            '<(DEPTH)/base/allocator/allocator.gyp:allocator',
          ],
          'link_settings': {
            'ldflags': ['-rdynamic'],
          },
        }],
        ['use_ozone==1', {
          'sources!': [
            'sticky_keys/sticky_keys_unittest.cc',  # crbug.com/354035
          ],
        }],
      ],
    },
    {
      # GN version: //ash:ash_shell_lib
      'target_name': 'ash_shell_lib',
      'type': 'static_library',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../chrome/chrome_resources.gyp:packed_resources',
        '../content/content_shell_and_tests.gyp:content_shell_lib',
        '../content/content.gyp:content',
        '../skia/skia.gyp:skia',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../ui/app_list/app_list.gyp:app_list',
        '../ui/aura/aura.gyp:aura',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/compositor/compositor.gyp:compositor',
        '../ui/events/events.gyp:events',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/keyboard/keyboard.gyp:keyboard',
        '../ui/message_center/message_center.gyp:message_center',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/views/examples/examples.gyp:views_examples_lib',
        '../ui/views/examples/examples.gyp:views_examples_with_content_lib',
        '../ui/views/views.gyp:views',
        '../ui/views/views.gyp:views_test_support',
        'ash',
        'ash_resources.gyp:ash_resources',
        'ash_strings.gyp:ash_strings',
        'ash_test_support',
        'ash_with_content',
      ],
      'sources': [
        '<@(ash_shell_lib_sources)',
      ],
      'conditions': [
        ['OS=="win"', {
          'dependencies': [
            '../content/content.gyp:content_startup_helper_win',
          ],
        }],
      ],
    },
    {
      # GN version: //ash:ash_shell
      'target_name': 'ash_shell',
      'type': 'executable',
      'dependencies': [
        'ash_shell_lib',
        '../components/components.gyp:user_manager',
      ],
      'sources': [
        'shell/shell_main.cc',
      ],
      'conditions': [
        ['OS=="win"', {
          'msvs_settings': {
            'VCLinkerTool': {
              'SubSystem': '2',  # Set /SUBSYSTEM:WINDOWS
            },
          },
          'dependencies': [
            '../sandbox/sandbox.gyp:sandbox',
          ],
        }],
        ['chromeos==1', {
          'dependencies': [
            '../device/bluetooth/bluetooth.gyp:device_bluetooth',
          ],
        }],
        ['OS=="win" and component!="shared_library" and win_use_allocator_shim==1', {
          'dependencies': [
            '<(DEPTH)/base/allocator/allocator.gyp:allocator',
          ],
        }],
      ],
    },
    {
      # GN version: //ash:ash_shell_unittests
      'target_name': 'ash_shell_unittests',
      'type': 'executable',
      'dependencies': [
        '../base/base.gyp:test_support_base',
        '../components/components.gyp:user_manager',
        '../content/content_shell_and_tests.gyp:test_support_content',
        '../skia/skia.gyp:skia',
        '../testing/gtest.gyp:gtest',
        '../ui/accessibility/accessibility.gyp:ax_gen',
        'ash_shell_lib',
        'ash_test_support',
      ],
      'sources': [
        # Note: file list duplicated in GN build.
        'shell/window_watcher_unittest.cc',
        'test/ash_unittests.cc',
      ],
      'conditions': [
        ['chromeos==1', {
          'dependencies': [
            '../ui/display/display.gyp:display',
          ],
        }],
        ['OS=="win" and component!="shared_library" and win_use_allocator_shim==1', {
          'dependencies': [
            '<(DEPTH)/base/allocator/allocator.gyp:allocator',
          ],
        }],
      ],
    },
  ],
  'conditions': [
    ['test_isolation_mode != "noop"', {
      'targets': [
        {
          'target_name': 'ash_unittests_run',
          'type': 'none',
          'dependencies': [
            'ash_unittests',
          ],
          'includes': [
            '../build/isolate.gypi',
          ],
          'sources': [
            'ash_unittests.isolate',
          ],
        },
      ],
    }],
  ],
}
