/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmptyForIteratorPadCheck
extends AbstractOptionCheck<PadOption> {
    public EmptyForIteratorPadCheck() {
        super(PadOption.NOSPACE, PadOption.class);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{38};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        if (aAST.getChildCount() == 0) {
            DetailAST semi = aAST.getPreviousSibling();
            String line = this.getLines()[semi.getLineNo() - 1];
            int after = semi.getColumnNo() + 1;
            if (after < line.length()) {
                if (PadOption.NOSPACE == this.getAbstractOption() && Character.isWhitespace(line.charAt(after))) {
                    this.log(semi.getLineNo(), after, "ws.followed", ";");
                } else if (PadOption.SPACE == this.getAbstractOption() && !Character.isWhitespace(line.charAt(after))) {
                    this.log(semi.getLineNo(), after, "ws.notFollowed", ";");
                }
            }
        }
    }
}

