/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;
import com.puppycrawl.tools.checkstyle.checks.imports.Guard;
import java.util.LinkedList;
import java.util.List;

class PkgControl {
    private final LinkedList<Guard> mGuards = Lists.newLinkedList();
    private final List<PkgControl> mChildren = Lists.newArrayList();
    private final PkgControl mParent;
    private final String mFullPackage;

    PkgControl(String aPkgName) {
        assert (aPkgName != null);
        this.mParent = null;
        this.mFullPackage = aPkgName;
    }

    PkgControl(PkgControl aParent, String aSubPkg) {
        assert (aParent != null);
        assert (aSubPkg != null);
        this.mParent = aParent;
        this.mFullPackage = aParent.getFullPackage() + "." + aSubPkg;
        this.mParent.mChildren.add(this);
    }

    void addGuard(Guard aThug) {
        this.mGuards.addFirst(aThug);
    }

    String getFullPackage() {
        return this.mFullPackage;
    }

    PkgControl locateFinest(String aForPkg) {
        if (!aForPkg.startsWith(this.getFullPackage())) {
            return null;
        }
        for (PkgControl pc : this.mChildren) {
            PkgControl match = pc.locateFinest(aForPkg);
            if (match == null) continue;
            return match;
        }
        return this;
    }

    AccessResult checkAccess(String aForImport, String aInPkg) {
        AccessResult retVal = this.localCheckAccess(aForImport, aInPkg);
        if (retVal != AccessResult.UNKNOWN) {
            return retVal;
        }
        if (this.mParent == null) {
            return AccessResult.DISALLOWED;
        }
        return this.mParent.checkAccess(aForImport, aInPkg);
    }

    private AccessResult localCheckAccess(String aForImport, String aInPkg) {
        for (Guard g : this.mGuards) {
            AccessResult result;
            if (g.isLocalOnly() && !this.mFullPackage.equals(aInPkg) || (result = g.verifyImport(aForImport)) == AccessResult.UNKNOWN) continue;
            return result;
        }
        return AccessResult.UNKNOWN;
    }
}

