/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.header.AbstractHeaderCheck;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexpHeaderCheck
extends AbstractHeaderCheck {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final List<Pattern> mHeaderRegexps = Lists.newArrayList();
    private int[] mMultiLines = EMPTY_INT_ARRAY;

    public void setMultiLines(int[] aList) {
        if (aList == null || aList.length == 0) {
            this.mMultiLines = EMPTY_INT_ARRAY;
            return;
        }
        this.mMultiLines = new int[aList.length];
        System.arraycopy(aList, 0, this.mMultiLines, 0, aList.length);
        Arrays.sort(this.mMultiLines);
    }

    @Override
    protected void processFiltered(File aFile, List<String> aLines) {
        int fileSize;
        int headerSize = this.getHeaderLines().size();
        if (headerSize - this.mMultiLines.length > (fileSize = aLines.size())) {
            this.log(1, "header.missing", new Object[0]);
        } else {
            int i;
            int headerLineNo = 0;
            for (i = 0; headerLineNo < headerSize && i < fileSize; ++i) {
                String line = aLines.get(i);
                boolean isMatch = this.isMatch(line, headerLineNo);
                while (!isMatch && this.isMultiLine(headerLineNo)) {
                    isMatch = ++headerLineNo == headerSize || this.isMatch(line, headerLineNo);
                }
                if (!isMatch) {
                    this.log(i + 1, "header.mismatch", this.getHeaderLines().get(headerLineNo));
                    break;
                }
                if (this.isMultiLine(headerLineNo)) continue;
                ++headerLineNo;
            }
            if (i == fileSize) {
                while (headerLineNo < headerSize) {
                    if (!this.isMultiLine(headerLineNo)) {
                        this.log(1, "header.missing", new Object[0]);
                        break;
                    }
                    ++headerLineNo;
                }
            }
        }
    }

    private boolean isMatch(String aLine, int aHeaderLineNo) {
        return this.mHeaderRegexps.get(aHeaderLineNo).matcher(aLine).find();
    }

    private boolean isMultiLine(int aLineNo) {
        return Arrays.binarySearch(this.mMultiLines, aLineNo + 1) >= 0;
    }

    @Override
    protected void postprocessHeaderLines() {
        ImmutableList<String> headerLines = this.getHeaderLines();
        this.mHeaderRegexps.clear();
        for (String line : headerLines) {
            try {
                this.mHeaderRegexps.add(Utils.getPattern(line));
            }
            catch (PatternSyntaxException ex) {
                throw new ConversionException("line " + (this.mHeaderRegexps.size() + 1) + " in header specification" + " is not a regular expression");
            }
        }
    }
}

