/****************************************************************************
**
** Copyright (C) 2014 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the test suite of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia. For licensing terms and
** conditions see http://qt.digia.com/licensing. For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights. These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
****************************************************************************/


import QtQuick 2.0

QtObject {
    id:root

    function consoleCount() {
        console.count("console.count", "Ignore additional argument");
        console.count();
    }

    Component.onCompleted: {
        console.debug("console.debug");
        console.log("console.log");
        console.info("console.info");
        console.warn("console.warn");
        console.error("console.error");

        consoleCount();
        consoleCount();

        var a = [1, 2];
        var b = {a: "hello", d: 1 };
        b.toString = function() { return JSON.stringify(b) }
        var c
        var d = 12;
        var e = function() { return 5;};
        var f = true;
        var g = {toString: function() { throw new Error('toString'); }};

        console.log(a);
        console.log(b);
        console.log(c);
        console.log(d);
        console.log(e);
        console.log(f);
        console.log(root);
        console.log(g);
        console.log(1, "pong!", new Object);
        console.log(1, ["ping","pong"], new Object, 2);

        try {
            console.log(exception);
        } catch (e) {
            return;
        }

        throw ("console.log(exception) should have raised an exception");
    }
}
