/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.shrink.AnnotationUsageMarker;
import proguard.shrink.ClassShrinker;
import proguard.shrink.InnerUsageMarker;
import proguard.shrink.InterfaceUsageMarker;
import proguard.shrink.LocalVariableTypeUsageMarker;
import proguard.shrink.ShortestUsageMarker;
import proguard.shrink.ShortestUsagePrinter;
import proguard.shrink.UsageMarker;
import proguard.shrink.UsagePrinter;
import proguard.shrink.UsedClassFilter;

public class Shrinker {
    private final Configuration configuration;

    public Shrinker(Configuration configuration) {
        this.configuration = configuration;
    }

    public ClassPool execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        Object object;
        Object object2;
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        classPool.classesAccept(new ClassCleaner());
        classPool2.classesAccept(new ClassCleaner());
        UsageMarker usageMarker = this.configuration.whyAreYouKeeping == null ? new UsageMarker() : new ShortestUsageMarker();
        MultiClassVisitor multiClassVisitor = new MultiClassVisitor(new ClassVisitor[]{usageMarker, new NamedMethodVisitor("<init>", "()V", usageMarker)});
        ClassPoolVisitor classPoolVisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, multiClassVisitor, usageMarker, true, false, false);
        classPool.accept(classPoolVisitor);
        classPool2.accept(classPoolVisitor);
        classPool2.classesAccept(usageMarker);
        classPool.classesAccept(new InterfaceUsageMarker(usageMarker));
        classPool.classesAccept(new UsedClassFilter(usageMarker, new AllAttributeVisitor(true, new MultiAttributeVisitor(new AttributeVisitor[]{new InnerUsageMarker(usageMarker), new AnnotationUsageMarker(usageMarker), new LocalVariableTypeUsageMarker(usageMarker)}))));
        if (this.configuration.whyAreYouKeeping != null) {
            System.out.println();
            object2 = new ShortestUsagePrinter((ShortestUsageMarker)usageMarker, this.configuration.verbose);
            object = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.whyAreYouKeeping, (ClassVisitor)object2, (MemberVisitor)object2);
            classPool.accept((ClassPoolVisitor)object);
            classPool2.accept((ClassPoolVisitor)object);
        }
        if (this.configuration.printUsage != null) {
            object2 = this.configuration.printUsage == Configuration.STD_OUT ? System.out : new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.printUsage)));
            classPool.classesAcceptAlphabetically(new UsagePrinter(usageMarker, true, (PrintStream)object2));
            if (object2 == System.out) {
                ((PrintStream)object2).flush();
            } else {
                ((PrintStream)object2).close();
            }
        }
        int n = classPool.size();
        object = new ClassPool();
        classPool.classesAccept(new UsedClassFilter(usageMarker, new MultiClassVisitor(new ClassVisitor[]{new ClassShrinker(usageMarker), new ClassPoolFiller((ClassPool)object)})));
        classPool.clear();
        classPool2.classesAccept(new ClassShrinker(usageMarker));
        int n2 = ((ClassPool)object).size();
        if (n2 == 0) {
            throw new IOException("The output jar is empty. Did you specify the proper '-keep' options?");
        }
        if (this.configuration.verbose) {
            System.out.println("Removing unused program classes and class elements...");
            System.out.println("  Original number of program classes: " + n);
            System.out.println("  Final number of program classes:    " + n2);
        }
        return object;
    }
}

