/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.content.Context;
import android.view.MotionEvent;
import android.widget.ImageView;
import org.qtproject.qt5.android.CursorHandle;

class CursorView
extends ImageView {
    private CursorHandle mHandle;
    private float m_offsetX;
    private float m_offsetY;
    private boolean m_pressed = false;

    CursorView(Context context, CursorHandle cursorHandle) {
        super(context);
        this.mHandle = cursorHandle;
    }

    public void adjusted(int n, int n2) {
        this.m_offsetX += (float)n;
        this.m_offsetY += (float)n2;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.m_offsetX = motionEvent.getRawX();
                this.m_offsetY = motionEvent.getRawY() + (float)(this.getHeight() / 2);
                this.m_pressed = true;
                break;
            }
            case 2: {
                if (!this.m_pressed) {
                    return false;
                }
                this.mHandle.updatePosition(Math.round(motionEvent.getRawX() - this.m_offsetX), Math.round(motionEvent.getRawY() - this.m_offsetY));
                break;
            }
            case 1: 
            case 3: {
                this.m_pressed = false;
            }
        }
        return true;
    }
}

