/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.purchasing;

import android.text.TextUtils;
import android.util.Log;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.qtproject.qt5.android.purchasing.Base64;
import org.qtproject.qt5.android.purchasing.Base64DecoderException;

public class Security {
    private static final String TAG = "IABUtil/Security";
    private static final String KEY_FACTORY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";

    public static boolean verifyPurchase(String string, String string2, String string3) {
        PublicKey publicKey;
        if (string2 == null) {
            Log.e((String)TAG, (String)"data is null");
            return false;
        }
        boolean bl = false;
        if (!TextUtils.isEmpty((CharSequence)string3) && !(bl = Security.verify(publicKey = Security.generatePublicKey(string), string2, string3))) {
            Log.w((String)TAG, (String)"signature does not match data.");
            return false;
        }
        return true;
    }

    public static PublicKey generatePublicKey(String string) {
        try {
            byte[] byArray = Base64.decode(string);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_FACTORY_ALGORITHM);
            return keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            Log.e((String)TAG, (String)"Invalid key specification.");
            throw new IllegalArgumentException(invalidKeySpecException);
        }
        catch (Base64DecoderException base64DecoderException) {
            Log.e((String)TAG, (String)"Base64 decoding failed.");
            throw new IllegalArgumentException(base64DecoderException);
        }
    }

    public static boolean verify(PublicKey publicKey, String string, String string2) {
        try {
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(publicKey);
            signature.update(string.getBytes());
            if (!signature.verify(Base64.decode(string2))) {
                Log.e((String)TAG, (String)"Signature verification failed.");
                return false;
            }
            return true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.e((String)TAG, (String)"NoSuchAlgorithmException.");
        }
        catch (InvalidKeyException invalidKeyException) {
            Log.e((String)TAG, (String)"Invalid key specification.");
        }
        catch (SignatureException signatureException) {
            Log.e((String)TAG, (String)"Signature exception.");
        }
        catch (Base64DecoderException base64DecoderException) {
            Log.e((String)TAG, (String)"Base64 decoding failed.");
        }
        return false;
    }
}

