/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#include "helpmode.h"
#include "helpconstants.h"
#include "helpicons.h"

#include <QCoreApplication>

using namespace Help;
using namespace Help::Internal;

HelpMode::HelpMode(QObject *parent)
  : Core::IMode(parent)
{
    setObjectName(QLatin1String("HelpMode"));
    setContext(Core::Context(Constants::C_MODE_HELP));
    setIcon(Utils::Icon::modeIcon(Icons::MODE_HELP_CLASSIC,
                                  Icons::MODE_HELP_FLAT, Icons::MODE_HELP_FLAT_ACTIVE));
    setDisplayName(QCoreApplication::translate("Help::Internal::HelpMode", "Help"));
    setPriority(Constants::P_MODE_HELP);
    setId(Constants::ID_MODE_HELP);
}
