/****************************************************************************
**
** Copyright (C) 2016 Lorenz Haas
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#ifndef BEAUTIFIER_BEAUTIFIERCONSTANTS_H
#define BEAUTIFIER_BEAUTIFIERCONSTANTS_H

#include <QtGlobal>

namespace Beautifier {
namespace Constants {

const char ACTION_ID[]              = "Beautifier.Action";
const char MENU_ID[]                = "Beautifier.Menu";
const char OPTION_CATEGORY[]        = "II.Beautifier";
const char OPTION_TR_CATEGORY[]     = QT_TRANSLATE_NOOP("Beautifier", "Beautifier");
const char OPTION_CATEGORY_ICON[]   = ":/beautifier/images/beautifier.png";
const char SETTINGS_GROUP[]         = "Beautifier";
const char SETTINGS_DIRNAME[]       = "beautifier";
const char DOCUMENTATION_DIRNAME[]  = "documentation";
const char DOCUMENTATION_XMLROOT[]  = "beautifier_documentation";
const char DOCUMENTATION_XMLENTRY[] = "entry";
const char DOCUMENTATION_XMLKEYS[]  = "keys";
const char DOCUMENTATION_XMLKEY[]   = "key";
const char DOCUMENTATION_XMLDOC[]   = "doc";

} // namespace Constants
} // namespace Beautifier

#endif // BEAUTIFIER_BEAUTIFIERCONSTANTS_H

