/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.ldap;

import esecurity.crypto.gui.ldap.LdapEndPoint;
import esecurity.crypto.gui.model.SourcedCertificate;
import esecurity.crypto.gui.properties.ClientProperties;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.ldap.LdapClient;
import it.actalis.ellips.capi.ldap.LdapEntry;
import it.actalis.ellips.capi.ldap.LdapException;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class LdapCertificateFinder {
    private static final EllipsLogger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static List<SourcedCertificate> find(LdapEndPoint serializable, String string, String string2) {
        ArrayList<SourcedCertificate> arrayList = new ArrayList<SourcedCertificate>();
        try {
            Object object = new URI(((LdapEndPoint)serializable).getUrl());
            if (((LdapEndPoint)serializable).getUserName() != null && !((LdapEndPoint)serializable).getUserName().isEmpty() && ((LdapEndPoint)serializable).getPassword() != null && !((LdapEndPoint)serializable).getPassword().isEmpty()) {
                object = new LdapClient(((URI)object).getHost(), ((URI)object).getPort(), ((LdapEndPoint)serializable).getUserName(), ((LdapEndPoint)serializable).getPassword(), ClientProperties.getInstance().getNetworkConfig());
                object.setBaseDN(((LdapEndPoint)serializable).getBase());
            } else {
                object = new LdapClient(((URI)object).getHost(), ((URI)object).getPort(), ((LdapEndPoint)serializable).getBase(), 5000, ClientProperties.getInstance().getNetworkConfig());
            }
            serializable = new StringBuilder("(&");
            if (string2 != null && !string2.equals("")) {
                ((StringBuilder)serializable).append("(mail=").append(string2).append(")");
            }
            if (string != null && !string.equals("")) {
                ((StringBuilder)serializable).append("(cn=").append(string).append("\\/*)");
            }
            if (((StringBuilder)serializable).toString().equals("(&")) {
                ((StringBuilder)serializable).append("(cn=*\\/*)");
            } else {
                ((StringBuilder)serializable).append(")");
            }
            LdapEntry[] ldapEntryArray = object.advSearchEntries(((StringBuilder)serializable).toString(), 30);
            serializable = ldapEntryArray;
            serializable = ldapEntryArray;
            int n = ldapEntryArray.length;
            for (int i = 0; i < n; ++i) {
                object = serializable[i];
                try {
                    object = object.getBinAttribute("userCertificate;binary");
                    arrayList.add(new SourcedCertificate((byte[])object, SourcedCertificate.CertificateSource.LDAP));
                    continue;
                }
                catch (CapiException | LdapException throwable) {
                    logger.error(throwable.getMessage(), throwable);
                }
            }
        }
        catch (LdapException | URISyntaxException throwable) {
            logger.error(throwable.getMessage(), throwable);
        }
        return arrayList;
    }
}

