/*
 * Decompiled with CFR 0.152.
 */
package esecurity.tsl.sqllite;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.tsl.sqllite.ManifestSigner;
import it.actalis.ellips.capi.core.CapiException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;

public class SqlDbManifest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final HashMap<String, byte[]> entries = new HashMap();
    private byte[] signer = null;
    private byte[] signature = null;
    private Date signingTime;

    public static SqlDbManifest fromData(byte[] byArray) throws IOException {
        return (SqlDbManifest)OBJECT_MAPPER.readValue(byArray, SqlDbManifest.class);
    }

    public static byte[] toData(SqlDbManifest sqlDbManifest) throws IOException {
        return OBJECT_MAPPER.writeValueAsBytes((Object)sqlDbManifest);
    }

    public final HashMap<String, byte[]> getEntries() {
        return this.entries;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void addEntry(String string, byte[] byArray) {
        this.entries.put(string, byArray);
    }

    public byte[] getSigner() {
        return this.signer;
    }

    public Date getSigningTime() {
        return this.signingTime;
    }

    public void sign(ManifestSigner manifestSigner) throws CapiException {
        manifestSigner.init();
        for (String string : this.entries.keySet()) {
            manifestSigner.update(string.getBytes());
            byte[] object = this.entries.get(string);
            manifestSigner.update(object);
        }
        this.signer = manifestSigner.getSigner().getDerEncoded();
        manifestSigner.update(this.signer);
        this.signature = manifestSigner.sign();
        this.signingTime = new Date();
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

