/*
 * Decompiled with CFR 0.152.
 */
package esecurity.tsl;

import esecurity.tsl.ServiceDbItem;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import esecurity.validator.constants.ValidationProfile;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.CertificateType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ChainEntry {
    protected List<ServiceDbItem> certDbItems = new ArrayList<ServiceDbItem>();
    protected ChainEntry parent;
    private Boolean corruptedSignature = null;

    public ChainEntry(List<ServiceDbItem> list) {
        this.certDbItems = list;
    }

    public boolean isCorruptedSignature() {
        block8: {
            if (this.corruptedSignature != null) {
                return this.corruptedSignature;
            }
            if (this.certDbItems.isEmpty()) {
                return true;
            }
            Certificate certificate = this.certDbItems.get(0).getCert();
            if (certificate.getCertificateType() == CertificateType.UNKNOWN) {
                return true;
            }
            if (certificate.getCertificateType() == CertificateType.ROOT_CA || certificate.getCertificateType() == CertificateType.SELFSIGNED) {
                return false;
            }
            boolean bl = false;
            for (ServiceDbItem serviceDbItem : this.certDbItems) {
                if (!serviceDbItem.isValidSignature()) continue;
                bl = true;
                break;
            }
            if (this.parent == null || this.parent.isCorruptedSignature()) {
                return !bl;
            }
            try {
                certificate.getInternalCert().verify(this.parent.getCertDbItem().get(0).getCert().getPublicKey());
                this.corruptedSignature = Boolean.FALSE;
            }
            catch (Exception exception) {
                this.corruptedSignature = !bl;
                if (this.corruptedSignature.booleanValue()) break block8;
                this.parent = null;
            }
        }
        return this.corruptedSignature;
    }

    public boolean isAdmittedByProfile(ValidationProfile validationProfile, Date date) {
        if (this.certDbItems == null) {
            return false;
        }
        for (ServiceDbItem serviceDbItem : this.certDbItems) {
            if (serviceDbItem.getStatusStartingTime() != null && serviceDbItem.getStatusStartingTime().after(date)) {
                if (serviceDbItem.getHistory() == null) continue;
                for (ServiceDbItem serviceDbItem2 : serviceDbItem.getHistory()) {
                    if (serviceDbItem2.getStatusStartingTime() != null && serviceDbItem2.getStatusStartingTime().after(date) || !this.isAdmitted(serviceDbItem2, validationProfile)) continue;
                    return true;
                }
                continue;
            }
            if (!this.isAdmitted(serviceDbItem, validationProfile)) continue;
            return true;
        }
        return false;
    }

    private boolean isAdmitted(ServiceDbItem serviceDbItem, ValidationProfile validationProfile) {
        switch (validationProfile) {
            case QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE: {
                return this.isQualified(serviceDbItem);
            }
            case CNS_ADVANCED_ELECTRONIC_SIGNATURE_PROFILE: {
                return this.isCns(serviceDbItem);
            }
            case ADVANCED_ELECTRONIC_SIGNATURE_PROFILE: {
                return this.isAdvanced(serviceDbItem);
            }
            case GRAPHOMETRIC_SIGNATURE_PROFILE: {
                return this.isGraphometric(serviceDbItem);
            }
            case ALL_PROFILES: {
                return this.isGraphometric(serviceDbItem) || this.isAdvanced(serviceDbItem) || this.isCns(serviceDbItem);
            }
        }
        return false;
    }

    private boolean isQualified(ServiceDbItem object) {
        if (TSLServiceTypeIdentifiers.TSS_QC.equals((Object)((ServiceDbItem)object).getServiceType())) {
            return true;
        }
        if (TSLServiceTypeIdentifiers.QTST.equals((Object)((ServiceDbItem)object).getServiceType())) {
            return true;
        }
        if (TSLServiceTypeIdentifiers.QC.equals((Object)((ServiceDbItem)object).getServiceType())) {
            if ((object = ((ServiceDbItem)object).getAdditionServiceInfoUris()).isEmpty()) {
                return true;
            }
            if (object.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSignatures") || object.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/ForeSeals")) {
                return true;
            }
        }
        return false;
    }

    private boolean isCns(ServiceDbItem serviceDbItem) {
        return TSLServiceTypeIdentifiers.IdV.equals((Object)serviceDbItem.getServiceType());
    }

    private boolean isAdvanced(ServiceDbItem serviceDbItem) {
        return TSLServiceTypeIdentifiers.QC.equals((Object)serviceDbItem.getServiceType()) || TSLServiceTypeIdentifiers.TSS_QC.equals((Object)serviceDbItem.getServiceType()) || TSLServiceTypeIdentifiers.QTST.equals((Object)serviceDbItem.getServiceType()) || TSLServiceTypeIdentifiers.Fea.equals((Object)serviceDbItem.getServiceType()) || TSLServiceTypeIdentifiers.User.equals((Object)serviceDbItem.getServiceType()) || TSLServiceTypeIdentifiers.IdV.equals((Object)serviceDbItem.getServiceType());
    }

    private boolean isGraphometric(ServiceDbItem serviceDbItem) {
        return this.isQualified(serviceDbItem) || TSLServiceTypeIdentifiers.Graphometric.equals((Object)serviceDbItem.getServiceType()) || TSLServiceTypeIdentifiers.NotarGraphometric.equals((Object)serviceDbItem.getServiceType());
    }

    public List<ServiceDbItem> getCertDbItem() {
        return this.certDbItems;
    }

    public Certificate getCert() {
        if (this.certDbItems.isEmpty()) {
            return null;
        }
        return this.certDbItems.get(0).getCert();
    }

    public ChainEntry getParent() {
        return this.parent;
    }

    public void setParent(ChainEntry chainEntry) {
        this.parent = chainEntry;
    }

    public String toString() {
        if (this.certDbItems.isEmpty()) {
            return "EMPTY_ENTRY";
        }
        return this.certDbItems.get(0).toString();
    }
}

