/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.core.auth;

import esecurity.dsd.core.auth.HashGenerator;
import esecurity.dsd.core.auth.hashes.Sha256Generator;

public class SecurePassword {
    private static HashGenerator internalHash;

    private HashGenerator getInternalGenerator() {
        if (internalHash == null) {
            internalHash = new Sha256Generator();
        }
        return internalHash;
    }

    public SecurePassword(String salt) {
        this.getInternalGenerator().setSalt(salt);
    }

    public String hash(String unsecured) {
        return this.getInternalGenerator().hash(unsecured);
    }

    public boolean match(String secured, String unsecure) {
        boolean ok = false;
        if (secured != null && !"".equals(secured)) {
            String hash = this.hash(unsecure);
            ok = secured.equals(hash);
        }
        return ok;
    }
}

