/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.armpclient;

import it.arubapec.armpclient.ahhytmns;
import it.arubapec.armpclient.commons.HttpURLConnectionFactory;
import it.arubapec.armpclient.commons.HttpURLConnectionFactoryImpl;
import it.arubapec.armpclient.commons.ServerTransaction;
import it.arubapec.armpclient.exception.ArubaLicensingException;
import it.arubapec.armpclient.lfirhpid;
import it.arubapec.armpclient.lracmqsd;
import it.arubapec.armpclient.nyigamxj;
import it.arubapec.armpclient.os.FingerPrint;
import it.arubapec.armpclient.protobuf.MachineIDProto;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import org.slf4j.Logger;

public class ARMPClient {
    private static final Logger logger = ARMPClient.Dv("vhv7ll", ARMPClient.class);
    private static HttpURLConnectionFactory httpURLConnectionFactory = null;
    private final String machineFilePath;
    private InputStream cert;
    private byte[] certBytes;
    private String workingDir;
    private String productName;
    private String voucher;
    private FingerPrint fingerPrint;
    private String extraInfo;
    private boolean checkRevocation;
    private boolean strictRevocationCheck;
    private boolean checkValidity;
    private boolean isGraphometricSoftware;
    private String p12Name;
    private String x509Name;
    private byte[] p12CertByte;
    private MachineIDProto.MachineID machineId;
    private ServerTransaction serverTransaction;

    public static HttpURLConnectionFactory getHttpURLConnectionFactoryInstance() {
        if (httpURLConnectionFactory == null) {
            httpURLConnectionFactory = new HttpURLConnectionFactoryImpl();
        }
        return httpURLConnectionFactory;
    }

    public static void setHttpURLConnectionFactoryInstance(HttpURLConnectionFactory factoryInstance) {
        httpURLConnectionFactory = factoryInstance;
    }

    public ARMPClient(String workingDir, String product, boolean isGraphometricSoftware) throws ArubaLicensingException {
        this(workingDir, product, null, isGraphometricSoftware);
    }

    public ARMPClient(String workingDir, String product, String voucher) throws ArubaLicensingException {
        this(workingDir, product, voucher, false);
    }

    public ARMPClient(String workingDir, String product, String voucher, boolean isGraphometricSoftware) throws ArubaLicensingException {
        this(workingDir, product, voucher, isGraphometricSoftware, false, false);
    }

    public ARMPClient(String workingDir, String product, String voucher, boolean isGraphometricSoftware, boolean pingOnStart, boolean checkLicenseOnPing) throws ArubaLicensingException {
        this(workingDir, product, voucher, isGraphometricSoftware, pingOnStart, checkLicenseOnPing, null);
    }

    public ARMPClient(String workingDir, String product, String voucher, boolean isGraphometricSoftware, boolean pingOnStart, boolean checkLicenseOnPing, String serverCrtPath) throws ArubaLicensingException {
        this(workingDir, product, voucher, isGraphometricSoftware, pingOnStart, checkLicenseOnPing, serverCrtPath, false);
    }

    public ARMPClient(String workingDir, String product, String voucher, boolean isGraphometricSoftware, boolean pingOnStart, boolean checkLicenseOnPing, String serverCrtPath, boolean checkRevocation) throws ArubaLicensingException {
        this(workingDir, product, voucher, isGraphometricSoftware, pingOnStart, checkLicenseOnPing, serverCrtPath, checkRevocation, false, false);
    }

    public ARMPClient(String workingDir, String product, String voucher, boolean isGraphometricSoftware, boolean pingOnStart, boolean checkLicenseOnPing, String serverCrtPath, boolean checkRevocation, boolean strictRevocationCheck, boolean disableChallenge) throws ArubaLicensingException {
        this(workingDir, product, voucher, isGraphometricSoftware, pingOnStart, checkLicenseOnPing, serverCrtPath, checkRevocation, strictRevocationCheck, disableChallenge, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ARMPClient(String workingDir, String product, String voucher, boolean isGraphometricSoftware, boolean pingOnStart, boolean checkLicenseOnPing, String serverCrtPath, boolean checkRevocation, boolean strictRevocationCheck, boolean disableChallenge, boolean checkValidity) throws ArubaLicensingException {
        block16: {
            block14: {
                block15: {
                    this.voucher = null;
                    this.checkRevocation = false;
                    this.strictRevocationCheck = false;
                    this.checkValidity = false;
                    this.serverTransaction = null;
                    char[] cArray = "\ufa27\ud9f3\u2f3f\ucfe4\u3a93\u4bcc\ue0bb\ufcae\u6178\u9206\ucbf8\uedc6\u4170\u6127\ua992\u189c\u9c15\ua3f1\u7932\uedb0\ue0c2\u9ece\u4847\u2b93\ud226\u14b1\u2b6e\ucc01\u2aaf\ufc55\uab50\ue3ec\ua08e\u7426\u499b".toCharArray();
                    cArray[23] = (char)(cArray[23] ^ 0x5157);
                    logger.info(ahhytmns.e(cArray, (short)3472, (short)1, (short)3));
                    this.workingDir = workingDir;
                    this.productName = product;
                    if (voucher != null) {
                        this.voucher = voucher;
                    }
                    this.isGraphometricSoftware = isGraphometricSoftware;
                    this.checkRevocation = checkRevocation;
                    this.strictRevocationCheck = strictRevocationCheck;
                    this.checkValidity = checkValidity;
                    char[] cArray2 = "\u110e\u3e73\u2498\udae6\u2e24\u9588\ubef8\u5918\u6b21\u6050\u2326\u693a\u65db\u3623\u6ac4\u8850\u1673\u1904\u7170\ua156\u8860\uc4fd\u1c39".toCharArray();
                    cArray2[10] = (char)(cArray2[10] ^ 0x5FFE);
                    this.p12Name = ahhytmns.e(cArray2, (short)14131, (short)5, (short)2);
                    char[] cArray3 = "\u7da8\uc94a\u8975\ubba8\ued9b\u7489\u70da\uaae6\u5683".toCharArray();
                    cArray3[2] = (char)(cArray3[2] ^ 0x3D46);
                    this.x509Name = ahhytmns.e(cArray3, (short)3799, (short)1, (short)3);
                    char[] cArray4 = "\u3d1e\u2ed2\u6449\ua57f\u9054\u8074\ud5bd\u3e77\uabf6\u0172".toCharArray();
                    cArray4[8] = (char)(cArray4[8] ^ 0x603A);
                    char[] cArray5 = "\u4d61\u5ab2\u63fb\ud4ca\u265c".toCharArray();
                    cArray5[3] = (char)(cArray5[3] ^ 0x65A4);
                    this.machineFilePath = ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("1p797g7", ARMPClient.Dv("-92iofo", new StringBuilder(), workingDir), File.separatorChar), ahhytmns.e(cArray4, (short)4851, (short)2, (short)4)), ahhytmns.e(cArray5, (short)14242, (short)5, (short)0)));
                    char[] cArray6 = "\u8ccd\u2e6b\u107f\u06e6\ubec6\ua575\u7409\ud7f5\u2780\ub2aa\ubdbd\u2332\u8678\u4cf1\u93c4\u02c4\uacdc\u1c9b\u3c96\ud285\u97af\ua3ec\u2161\uc405\uac3e\u4a11\u8bae\u481d\ua778\uf437\u97e4\u627d".toCharArray();
                    cArray6[11] = (char)(cArray6[11] ^ 0x505B);
                    logger.debug(ahhytmns.e(cArray6, (short)14648, (short)1, (short)0));
                    char[] cArray7 = "\ud5a3\ub840\u0587\ua3c0\ub35a\ub0d8\u6fce\u182d\uc201\u7fd6\u4079\ub8c7\ufdcc\ue0de\u53dd".toCharArray();
                    cArray7[0] = (char)(cArray7[0] ^ 0x8AD);
                    logger.debug((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), ahhytmns.e(cArray7, (short)24848, (short)4, (short)0)), this.workingDir)));
                    char[] cArray8 = "\u4ef7\u07b7\uf5e3\ue3d7\ue79c\uc243\u21b0\ud674\uf067\u2584\uf8c7\ufcc4\uad16\uf756\u691c".toCharArray();
                    cArray8[3] = (char)(cArray8[3] ^ 0x5C7C);
                    logger.debug((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), ahhytmns.e(cArray8, (short)23238, (short)1, (short)5)), this.productName)));
                    char[] cArray9 = "\u9980\u48a6\u4717\u5d51\uc925\uce6a\u8427\ucf06\u4f0c\u3e74".toCharArray();
                    cArray9[1] = (char)(cArray9[1] ^ 0x1A5C);
                    logger.debug((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), ahhytmns.e(cArray9, (short)15403, (short)2, (short)4)), this.voucher)));
                    char[] cArray10 = "\ufdce\udca2\u418d\u2fe5\uc933\udd27\u638a".toCharArray();
                    cArray10[1] = (char)(cArray10[1] ^ 0x672);
                    logger.debug((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("1srf7gd", ARMPClient.Dv("-92iofo", new StringBuilder(), ahhytmns.e(cArray10, (short)30164, (short)3, (short)4)), pingOnStart)));
                    char[] cArray11 = "\ua03b\u2a85\u36dd\u9ce0\u46e1\u1bc8\u7112\ud255\u7977\u4d62\u3782\u0e3f".toCharArray();
                    cArray11[10] = (char)(cArray11[10] ^ 0x79B2);
                    logger.debug((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), ahhytmns.e(cArray11, (short)14763, (short)5, (short)4)), this.machineFilePath)));
                    char[] cArray12 = "\ue5c6\u5d8b\u0d2d\ubba7\u2f4a\u2ff9\ufdbd\ud6e7\u6e87\ud1dc\ufc40\u6c0a\uc589\uf046\u4292\u4a3a\u168d".toCharArray();
                    cArray12[3] = (char)(cArray12[3] ^ 0x7497);
                    logger.debug((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("1srf7gd", ARMPClient.Dv("-92iofo", new StringBuilder(), ahhytmns.e(cArray12, (short)2208, (short)4, (short)5)), this.isGraphometricSoftware)));
                    if (this.isGraphometricSoftware) {
                        char[] cArray13 = "\u5465\u4701\uf57a\u1208\ub587\u7075\ud07f\u2e7d\u52ca\u5be3\u1212\u6033\u72f7\u17c9\ud025\ud27b\u72a9\u283c".toCharArray();
                        cArray13[14] = (char)(cArray13[14] ^ 0x3595);
                        logger.debug((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), ahhytmns.e(cArray13, (short)20166, (short)0, (short)1)), this.p12Name)));
                    }
                    char[] cArray14 = "\u05c2\u1ac5\uc4a3\uc974\u84a9\u7bae\u080e\u3fc0\ue965\u0a65\ua414\ub4fb\ufe6b\u2911\u99ab\u0600\ucbe7\ud46c\u7067\u41b9\u22e4\u7eb3\u025e\uda98\u985e\uadce\u1900\u351f\u4a8c\u1629\u76e5".toCharArray();
                    cArray14[27] = (char)(cArray14[27] ^ 0x2206);
                    logger.debug((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), ahhytmns.e(cArray14, (short)9743, (short)5, (short)0)), File.separator), this.x509Name)));
                    char[] cArray15 = "\u84f3\u6287\u847e\ud4e6\u1469\u817c\ue72f\uf933\ucd06\u02bf\u796d\u59da\ud60a\ufc1a\u544e\u033a\u6e3a\u2389".toCharArray();
                    cArray15[6] = (char)(cArray15[6] ^ 0x2AF);
                    logger.debug((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("1srf7gd", ARMPClient.Dv("-92iofo", new StringBuilder(), ahhytmns.e(cArray15, (short)24266, (short)0, (short)5)), this.checkRevocation)));
                    char[] cArray16 = "\u783d\u8ca6\u2171\u6185\u9b0c\u87d3\uf5e3\u3b45\ufb61\u88cd\ufb4c\u5918\u83fa\u21b9\uafde\ub06d\u60d4\u4936\u2f85\uaf77\ubef7\u5322\u6205\u6945\u2962\uc0b3\ufd12\u4f63\u63a9\ubd97\u152f\u5b3c".toCharArray();
                    cArray16[21] = (char)(cArray16[21] ^ 0x62FF);
                    logger.debug(ahhytmns.e(cArray16, (short)22162, (short)2, (short)1));
                    char[] cArray17 = "\u56b0\u8139\u8207\u5eca\u64d0\ua338\u9631\u5da5\uf866\ud859\uead2\ubccd\u7744\u9f9b\uf233\u89db\u3693\u777a\ue684\u0e7c\u3279\u9233\u49ad\uad01\u4643\uccb7\u870a\u8c19\ued83\u937e\u137a\uf288\u2a60".toCharArray();
                    cArray17[2] = (char)(cArray17[2] ^ 0x356);
                    logger.debug(ahhytmns.e(cArray17, (short)12027, (short)1, (short)1));
                    this.serverTransaction = new ServerTransaction(this.workingDir);
                    if (isGraphometricSoftware) {
                        this.initSubFolder();
                    }
                    if (serverCrtPath != null && ARMPClient.Dv("pqb7gc", serverCrtPath) == false) {
                        if (ARMPClient.Dv("-138eobu", ARMPClient.Dv("std7gb", serverCrtPath, new String[0]), new LinkOption[0]) == false) {
                            char[] cArray18 = "\u14cb\ubed4\ud723\uf16f\uc985\ucd50\u20cb\u6067\ude9e\u5e5d\u97f4\ub18a\uc8d4\uc493\u88b9\u7587\ua3c6\u2a05\ua150\u9a6c\u67c4\u7c67".toCharArray();
                            cArray18[3] = (char)(cArray18[3] ^ 0x497);
                            logger.error(ahhytmns.e(cArray18, (short)31330, (short)2, (short)1));
                            char[] cArray19 = "\ubbcf\u5a01\u5ef0\u96bd\u016d\u016a\uc43f\uf179\u9ff1\ude81\u7c06\u4e6c\u9f69\u448a\u9cfd\u6932\u2979\u7c27\u6af7\ud779\ue28f\u6f9f\u0e2f\u422d\ua6af\u7356\u7339".toCharArray();
                            cArray19[15] = (char)(cArray19[15] ^ 0x1536);
                            char[] cArray20 = "\u60d9\u733f\u2220\ua8f4\u2dae\u4a6c\ud797\uaf50\u3857\ua0ac\u1a3f\u5faf\uffd7\u63e6\u0493".toCharArray();
                            cArray20[5] = (char)(cArray20[5] ^ 0x7D2C);
                            throw new ArubaLicensingException(ahhytmns.e(cArray19, (short)27165, (short)0, (short)3), ahhytmns.e(cArray20, (short)9631, (short)1, (short)5));
                        }
                        this.cert = ARMPClient.Dv("-16kcobv", serverCrtPath);
                    } else {
                        char[] cArray21 = "\u1ecb\uc71c\u9e85\ucf49\ufe7c\u0bc3\uc3a2\u77b7\u8be2\u10fd\u9dc2\u865c\u574f\u1d88\u27dc\ue93a\ua016\u25d5\u9196\u887b\udfc3\ub364\u6580\u957c\uea55\u5306\uaecb\uc3b8\u7067\u4a29\ue7e6\ubfd0\ucf31\u7aca\u0be5\ufdc3\ub27c\u0355\u38ea\u7ce1\u7f3c".toCharArray();
                        cArray21[13] = (char)(cArray21[13] ^ 0x27DD);
                        this.cert = ARMPClient.Dv("ugn7k0", ahhytmns.e(cArray21, (short)26163, (short)2, (short)4));
                    }
                    this.certBytes = (byte[])ARMPClient.Dv("-1ttmoc1", this.cert);
                    char[] cArray22 = "\u6a73\uaf02\u59a3\udc69\u3ef4\ub15d\uccc8\udd13\ufc6f\ua131\u2d3e\u77d6\ubeb0\u0afc\ua620\ud324\u1a32\u48d9".toCharArray();
                    cArray22[7] = (char)(cArray22[7] ^ 0x5A32);
                    logger.debug(ahhytmns.e(cArray22, (short)21471, (short)1, (short)5));
                    ARMPClient.Dv("-f10obq", new ByteArrayInputStream(this.certBytes), this.checkRevocation, (boolean)this.strictRevocationCheck, (boolean)this.checkValidity);
                    char[] cArray23 = "\u94a3\u6c69\u96b1\u6b10\u1748\u5afe\uac0b\u10d2\u0724\u2b76\u1c0b\u28f2\u7d5d\u71cf".toCharArray();
                    cArray23[12] = (char)(cArray23[12] ^ 0x238D);
                    logger.info(ahhytmns.e(cArray23, (short)21692, (short)0, (short)2));
                    if (this.voucher == null) break block14;
                    char[] cArray24 = "\u98ae\u4871\uc9ea\u8fdc\u8a63\ue385\ua9d6\ub3c2\u73a2\ud52d\ue2dd\u4163\ua8cd\ucc87\u1582".toCharArray();
                    cArray24[13] = (char)(cArray24[13] ^ 0x335F);
                    if (ARMPClient.Dv("143d7k5", ARMPClient.Dv("std7gb", ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), this.workingDir), File.separator), ahhytmns.e(cArray24, (short)15367, (short)3, (short)3))), new String[0]), new LinkOption[0]) != false) break block15;
                    char[] cArray25 = "\u1020\u76b1\u74e5\u5ba8\ue7c7\u2dfb\uba36\ub810\u9164\uae92\u80a6\u036b\u5ce3\ue8b0\u6322".toCharArray();
                    cArray25[13] = (char)(cArray25[13] ^ 0x31B7);
                    if (ARMPClient.checkVoucher(voucher, (String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("1p797g7", ARMPClient.Dv("-92iofo", new StringBuilder(), workingDir), File.separatorChar), ahhytmns.e(cArray25, (short)23561, (short)0, (short)1))))) break block16;
                }
                char[] cArray = "\u94d3\u3c94\ua3ef\u88fc\u7820\u5512\u5374\u557f\uec4a\u17a3\ufa3c\ua9be\u2f17\uc18b\ube13\ubf4f\ubbc7\ufb26\u23b8\uc886\ud1e3\u9aa5\u8ea8\uad4b\u8cbe\uf3a4\u332e\u95ba\u06e9\u3005\u5406\u02a2\uef64\ub8ad\u9a3d\u64f5\ue8a2\u6721".toCharArray();
                cArray[2] = (char)(cArray[2] ^ 0x59E0);
                logger.info(ahhytmns.e(cArray, (short)665, (short)4, (short)0));
                char[] cArray26 = "\u1a9e\u144e\u1eb3\u866a\u7b85\ub012\uc5e1\u7dcd\udbd3\u514c\u11cd\ud3d0\u7fa5\ud21f\u7180".toCharArray();
                cArray26[11] = (char)(cArray26[11] ^ 0x56EF);
                ARMPClient.Dv("2u57k4", workingDir, voucher, (Object)ahhytmns.e(cArray26, (short)23726, (short)0, (short)0));
                break block16;
            }
            char[] cArray = "\ubf39\u0c0e\u1172\ucbf6\uaae2\ua09c\u75cc\ua63a\ub0a2\u0fea\u4bcb\u00a9\udb62\ua3c5\u4d1b".toCharArray();
            cArray[7] = (char)(cArray[7] ^ 0x4ADC);
            if (ARMPClient.Dv("143d7k5", ARMPClient.Dv("std7gb", ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), this.workingDir), File.separator), ahhytmns.e(cArray, (short)9989, (short)3, (short)1))), new String[0]), new LinkOption[0]) != false) {
                char[] cArray27 = "\u230d\ua1d1\u7a6b\ub6ba\u1bbd\u3fa1\uc8e0\u74b7\ud840\ub425\u5913\u11da\ucb99\u0127\u2934\u09d3\u0780\u763f\udb2b\u47f0\u53e5\u95f7\u68e3".toCharArray();
                cArray27[20] = (char)(cArray27[20] ^ 0x2234);
                logger.error(ahhytmns.e(cArray27, (short)16134, (short)4, (short)5));
                char[] cArray28 = "\u13bc\u7b8e\u6613\u4765\udd33\u5fa6\u0f61\u6045\u549d\u502b\u4cc3\ue663\udb6e\u7a11\u6a40\uf7dd\udc61\u00e0\u2233\u1da5\u3810\u8e7b\u701a".toCharArray();
                cArray28[20] = (char)(cArray28[20] ^ 0x40E);
                char[] cArray29 = "\udcbb\ubcac\u2c36\u5250\u913e\u7cb3\uec13\ufe14\ua054\ufe01\u6c67\u3ba6\u8d5e\u49af\u5c31".toCharArray();
                cArray29[12] = (char)(cArray29[12] ^ 0x5A27);
                throw new ArubaLicensingException(ahhytmns.e(cArray28, (short)8508, (short)4, (short)4), ahhytmns.e(cArray29, (short)20969, (short)4, (short)3));
            }
            char[] cArray30 = "\u8ea9\u07a8\ub0de\uac3e\uc3b3\uc9ba\u7e2f\udc11\u40fa\ub08c\u36dd\ue46e\ua030\u66bf\ufd55\u0707\u4266\ub473\u8b4d\u69a8\uc598\u35dd".toCharArray();
            cArray30[20] = (char)(cArray30[20] ^ 0x1784);
            logger.debug(ahhytmns.e(cArray30, (short)5596, (short)2, (short)0));
        }
        char[] cArray = "\u0de0\u4d2f\uda25\u5035\uc9de\ud072\u991f\ua020\u130b\uc585\u5113\uf658\u44be\ub93d\u4b23\u4049".toCharArray();
        cArray[8] = (char)(cArray[8] ^ 0x655C);
        logger.debug(ahhytmns.e(cArray, (short)20201, (short)1, (short)5));
        char[] cArray31 = "\ud1b1\ub22a\u4852\u444f\u3a46\u5fa8".toCharArray();
        cArray31[0] = (char)(cArray31[0] ^ 0x2FF4);
        if (ARMPClient.Dv("143d7k5", ARMPClient.Dv("std7gb", ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), this.machineFilePath), ahhytmns.e(cArray31, (short)14982, (short)4, (short)2))), new String[0]), new LinkOption[]{LinkOption.NOFOLLOW_LINKS}) != false) {
            char[] cArray32 = "\ubefb\u2703\u4ddc\u90be\u02bd\u634d\u923f\ua366\u4365\u05e0\u8ad1\u1a59\uf0a6\uca65\u5a14\uf6b7\u6086\udea9\ub1d5\u4b57\uf386\u6a31\u50ae\u7a08\u9ede\uf2cd\uf2c7\u853e\u9e4a\ua5f8\uc83b\u7419\u9f3e\u7237\u9e75\u6a41\u4d85\u1b5d\uad4d\u40c9\ud71f\uc970\u6f7c".toCharArray();
            cArray32[0] = (char)(cArray32[0] ^ 0xF86);
            logger.info(ahhytmns.e(cArray32, (short)28668, (short)4, (short)1));
            this.generate();
        }
        char[] cArray33 = "\u0d33\u3708\u143f\u70fa\ua356\u574a\u9cc1\u2857\u2944\u591c\uec4e\u6077\ubd58\ub8df\u9505\u1809\ue472\u908d\u7d6c\ua2dc\u300e\ud5b4\u09fd\u051c".toCharArray();
        cArray33[6] = (char)(cArray33[6] ^ 0x4370);
        logger.debug(ahhytmns.e(cArray33, (short)21341, (short)2, (short)2));
        this.checksign();
        char[] cArray34 = "\ua10e\u8193\ud24b\ucfa8\u9ba0\u0981\uac50\ufe21\ue15c\u6e8e\u648a\ub35a\udba7\uf3ca\u6144\uef44\u97a9\u094f\u1a9e".toCharArray();
        cArray34[8] = (char)(cArray34[8] ^ 0x3450);
        logger.debug(ahhytmns.e(cArray34, (short)15051, (short)2, (short)0));
        this.machineId = this.readMachinIDFile(this.machineFilePath);
        char[] cArray35 = "\uf9e3\u40fb\uc254\u8aca\u77d4\u5717\u7da8\u9412\u0832\u6afd".toCharArray();
        cArray35[2] = (char)(cArray35[2] ^ 0x22F6);
        logger.debug(ahhytmns.e(cArray35, (short)25992, (short)5, (short)4));
        this.challenge();
        char[] cArray36 = "\u8d7a\u8abb\u77db\u23b5\u452d\u0a49\ua3c8\u0ed1\u7aa0\ub8a7\u41b9\u13e4\uc04a\u2b96\u24ca\ub492\u5272".toCharArray();
        cArray36[11] = (char)(cArray36[11] ^ 0x2935);
        logger.debug(ahhytmns.e(cArray36, (short)11571, (short)4, (short)5));
        if (this.isGraphometricSoftware) {
            char[] cArray37 = "\u7c8f\u8989\u84c3\ud9fb\u9eb4\uc47e\u57f4\uf7ff\u9670\u7a05\u5c4e\ua07b\u087d\u3ea6\uc864\u7104\u6749\u7a40\ua497\u5d58\u1404\u8a1a\ubd96\u7ad5".toCharArray();
            cArray37[19] = (char)(cArray37[19] ^ 0x15B2);
            logger.debug(ahhytmns.e(cArray37, (short)32118, (short)2, (short)5));
            char[] cArray38 = "\u65e7\ufbb8\u0306\ue0dc\u7bec\u1aad\u24c7\uf09d\u6e6b".toCharArray();
            cArray38[2] = (char)(cArray38[2] ^ 0x2C54);
            this.extractP12Cert((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), this.workingDir), File.separator), ahhytmns.e(cArray38, (short)30057, (short)3, (short)2)), File.separator), this.p12Name)));
            char[] cArray39 = "\uef91\ua019\u471e\ueb7f\u5674\u2fe8\ua57b\uaa1a\u142a\u17af\uaf71\uf444\u1d46\u5b93\ue6c5\u7ad2\uf49f\u3f3c\uf1e9\uae02\u01e8\u38db\u6291C\ua89e\u50c1".toCharArray();
            cArray39[2] = (char)(cArray39[2] ^ 0xFBB);
            logger.debug(ahhytmns.e(cArray39, (short)20883, (short)2, (short)3));
        }
        this.isExpired();
        if (pingOnStart) {
            char[] cArray40 = "\uf5da\uf524\u0922\u8c2f\u7bbc\u16e6\ubce4\u2e92\u75e6\ubd9a\udb29\u8d8d\u3116\u8eef\ucdc2\ubfb1\ud9fa\ua1a3\uc78e\u2d4d\u3db3\u1e6a\u06a6\u62a7\u0fc5".toCharArray();
            cArray40[7] = (char)(cArray40[7] ^ 0x565C);
            logger.info(ahhytmns.e(cArray40, (short)2175, (short)2, (short)3));
            if (checkLicenseOnPing) {
                this.ping(true);
            } else {
                ARMPClient.Dv("jqb7k3", new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            1.HT("-2aqofd", ARMPClient.this, false);
                        }
                        catch (ArubaLicensingException ale) {
                            1.HT("-1bgkofm").error((String)1.HT("-1aloofn", ale), (Throwable)ale);
                        }
                    }

                    private static Object HT(Object object, Object object2, Object object3) {
                        try {
                            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(nyigamxj.u(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
                        }
                        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
                            throw new BootstrapMethodError(reflectiveOperationException);
                        }
                    }
                }));
            }
        }
        char[] cArray41 = "\u3fd5\u3a8f\ua883\u6e50\uc085\uf3ba\u164f\u6807\ud724\u59d3\u7b45\u4970\u97b5\u6f00\u2d7c\ue295\uacde\u1539\ufc87\u7c33\udeaa\u6331\u563f\u0b10\uab60\u839e\u9e19\uda2d\uf4aa\u6194\u1e6f\u5556\u19f3\u0bed\u66c4\u39da\u79c4\ud7cb\u2f50\uc2b5\ud924\uc499\u659b\uc6b7\u6824\u4877\u1fd8\u531b\ucc76\ufea2\uea65\u6be4\u5d2d\u788d\u3f5e\uc85b\u6e04\u76dc".toCharArray();
        cArray41[0] = (char)(cArray41[0] ^ 0x65AD);
        logger.info(ahhytmns.e(cArray41, (short)31062, (short)5, (short)2));
    }

    public void ping(boolean checkLicenseActivationStatus) throws ArubaLicensingException {
        ARMPClient.Dv("-1uo8oc7", this.serverTransaction, ARMPClient.Dv("q8r7jq", this.machineId), (boolean)checkLicenseActivationStatus);
    }

    public String getMachineUUID() throws ArubaLicensingException {
        return ARMPClient.Dv("q8r7jq", this.machineId);
    }

    public byte[] getP12Cert() {
        if (this.isGraphometricSoftware) {
            return this.p12CertByte;
        }
        return null;
    }

    public String queryPolicy(String policyName) throws ArubaLicensingException {
        return ARMPClient.Dv("-rk8oc8", this.serverTransaction, ARMPClient.Dv("q8r7jq", this.machineId), (Object)policyName);
    }

    public String updatePolicy(String policyName, long addingValue) throws ArubaLicensingException {
        return ARMPClient.Dv("-qvcoc9", this.serverTransaction, ARMPClient.Dv("q8r7jq", this.machineId), (Object)policyName, (long)addingValue);
    }

    public String getDuty() throws ArubaLicensingException {
        return ARMPClient.Dv("7777ju", this.serverTransaction);
    }

    public String postInfo(String info) throws ArubaLicensingException {
        return ARMPClient.Dv("-178koc3", this.serverTransaction, info);
    }

    public byte[] getPayLoad(String payloadName) throws ArubaLicensingException {
        return (byte[])ARMPClient.Dv("-1kksoc4", this.serverTransaction, payloadName);
    }

    public String postPayLoad(String payloadName, byte[] payload) throws ArubaLicensingException {
        return ARMPClient.Dv("v7v7jr", this.serverTransaction, payloadName, (byte[])payload);
    }

    private void generate() throws ArubaLicensingException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        char[] cArray = "\u4b59\ub0dd\uc94f\u21e1\u5bbe\u8102\u9758\u5645\u750c\u2d85\u9803\u06d0\u9d85\u08b9\u2b7d\ud33c\u5cb2\u0558\u5de5\u09e9\uc52b\u2e29".toCharArray();
        cArray[15] = (char)(cArray[15] ^ 0x7978);
        logger.info(lracmqsd.H(cArray, (short)3817, (byte)5, (byte)0));
        if (this.fingerPrint == null) {
            char[] cArray2 = "\u5240\ua157\u3220\u8891\ue7e3\u4a3b\u78e1\uded1\u3644\uc0ed\ude52\ua000\u027c\u7caf\u1da4\ud86c\u61ea\uf941\u0f08\u543f\u1e07\u3cb3\u50ff".toCharArray();
            cArray2[9] = (char)(cArray2[9] ^ 0x5C7F);
            logger.debug(lracmqsd.H(cArray2, (short)30369, (byte)2, (byte)3));
            this.fingerPrint = new FingerPrint();
            ARMPClient.Dv("110t7ji", this.fingerPrint);
        }
        Object machineid = ARMPClient.Dv("-69gocf");
        if (ARMPClient.Dv("1nat7jg", this.fingerPrint) != null) {
            object7 = ARMPClient.Dv("1nat7jg", this.fingerPrint);
        } else {
            char[] cArray3 = "\u6e27\u26c6\uc4cd\u80c1\ub464\uafbe\u7e41".toCharArray();
            cArray3[0] = (char)(cArray3[0] ^ 0x727E);
            object7 = lracmqsd.H(cArray3, (short)16620, (byte)0, (byte)4);
        }
        ARMPClient.Dv("-16j8och", machineid, object7);
        if (ARMPClient.Dv("1agl7jm", this.fingerPrint) != null) {
            object6 = ARMPClient.Dv("1agl7jm", this.fingerPrint);
        } else {
            char[] cArray4 = "\u20fa\u2fe0\u0553\u71f4\u3b03\uc6b4\u3f62".toCharArray();
            cArray4[5] = (char)(cArray4[5] ^ 0x2E8D);
            object6 = lracmqsd.H(cArray4, (short)13912, (byte)4, (byte)0);
        }
        ARMPClient.Dv("b8t7jl", machineid, object6);
        if (ARMPClient.Dv("-l3kocc", this.fingerPrint) != null) {
            object5 = ARMPClient.Dv("-l3kocc", this.fingerPrint);
        } else {
            char[] cArray5 = "\uae3a\u171e\u7923\u0ec0\uc6a3\u7116\u7ed4\u464a\u5bff".toCharArray();
            cArray5[1] = (char)(cArray5[1] ^ 0x6FF9);
            object5 = lracmqsd.H(cArray5, (short)22003, (byte)2, (byte)0);
        }
        ARMPClient.Dv("-1ff0ocd", machineid, object5);
        if (ARMPClient.Dv("-b4gocm", this.fingerPrint) != null) {
            object4 = ARMPClient.Dv("-b4gocm", this.fingerPrint);
        } else {
            char[] cArray6 = "\ubac0\ubea4\u83f7\u4c99\u2cd9\u5aac".toCharArray();
            cArray6[4] = (char)(cArray6[4] ^ 0x292);
            object4 = lracmqsd.H(cArray6, (short)30955, (byte)3, (byte)0);
        }
        ARMPClient.Dv("-8puocn", machineid, object4);
        if (ARMPClient.Dv("ug97j8", this.fingerPrint) != null) {
            object3 = ARMPClient.Dv("ug97j8", this.fingerPrint);
        } else {
            char[] cArray7 = "\ue238\u5441\ue4a4\u03a4\u03e9\u5009\u5c92".toCharArray();
            cArray7[0] = (char)(cArray7[0] ^ 0x3EDF);
            object3 = lracmqsd.H(cArray7, (short)19255, (byte)3, (byte)4);
        }
        ARMPClient.Dv("10mb7j7", machineid, object3);
        if (ARMPClient.Dv("-208oci", this.fingerPrint) != null) {
            object2 = ARMPClient.Dv("-208oci", this.fingerPrint);
        } else {
            char[] cArray8 = "\u1d35\ufaf3\u38da\uc816\u6043\u304f\u32e0\u72d1".toCharArray();
            cArray8[6] = (char)(cArray8[6] ^ 0x6932);
            object2 = lracmqsd.H(cArray8, (short)11403, (byte)0, (byte)5);
        }
        ARMPClient.Dv("-4miocj", machineid, object2);
        if (ARMPClient.Dv("-1uj2ock", this.fingerPrint) != null) {
            object = ARMPClient.Dv("-1uj2ock", this.fingerPrint);
        } else {
            char[] cArray9 = "\u3a3f\ua4eb\u993d\ud807\ubf60\u012e".toCharArray();
            cArray9[1] = (char)(cArray9[1] ^ 0xA93);
            object = lracmqsd.H(cArray9, (short)19789, (byte)2, (byte)1);
        }
        ARMPClient.Dv("71f7jb", machineid, object);
        ARMPClient.Dv("1hf37j2", machineid, this.productName);
        if (this.isGraphometricSoftware) {
            this.extraInfo = ARMPClient.Dv("-e3eocv");
            ARMPClient.Dv("-8cood0", machineid, this.extraInfo);
        } else {
            this.extraInfo = "";
        }
        char[] cArray10 = "\ud5a8\u6260\u63dd\uebe2\u2485\uea0f\u670a\ubb74\u1a07\uf553\uebd6\u15bf\u417a\u8de0\u261b\u965b\u1c47\ucee9\u30a5\ue286\u3ef7\u1fc8\u6c10\u1db4\u7c8c".toCharArray();
        cArray10[7] = (char)(cArray10[7] ^ 0x6310);
        logger.debug(lracmqsd.H(cArray10, (short)23974, (byte)5, (byte)0));
        Object mach = ARMPClient.Dv("-14od1", machineid);
        try {
            FileOutputStream out = new FileOutputStream(this.machineFilePath);
            Throwable throwable = null;
            try {
                ARMPClient.Dv("-1mrqocq", mach, out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            ARMPClient.Dv("-29uocr", out);
                        }
                        catch (Throwable throwable3) {
                            ARMPClient.Dv("1hin7j4", throwable, throwable3);
                        }
                    } else {
                        ARMPClient.Dv("-29uocr", out);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((String)ARMPClient.Dv("-t1aoct", ex), (Throwable)ex);
            char[] cArray11 = "\u0978\u5c2f\u86a0\u0dc2\u7a34\u6555\ubc2d\u27de\u8865\u4f5c\u0a3a\ub97e\u1e80\u056b\u3f22\u2953\u3f4b".toCharArray();
            cArray11[8] = (char)(cArray11[8] ^ 0x1B23);
            throw new ArubaLicensingException(lracmqsd.H(cArray11, (short)16572, (byte)4, (byte)1), ex);
        }
        char[] cArray12 = "\u397d\uf072\ufd82\u72f6\u4c9d\u399e\u8003\ud7dc\u2d83\ue421\u5066\ue7f1\u8803\u816d\u5229\u2888".toCharArray();
        cArray12[7] = (char)(cArray12[7] ^ 0x54B9);
        logger.debug(lracmqsd.H(cArray12, (short)25789, (byte)2, (byte)0));
        this.sign();
    }

    private void sign() throws ArubaLicensingException {
        char[] cArray = "\ufa1e\u4970\u76ff\u4c3d\u992a\u754c\u2086\u850d\ue61d\uab08\u9a92\u64c0\u3417\u9552\u92e5\udbb3\u6629\ue347\u09b1\u8e6d\u6e4e\u1f89\u2a5a\u47a5\u8b2c\u2c14\ub43f\ucef2\udd22\u0c5e\u44c2\u8b4a\u6186\u8f5f\ubd4a\ued04\u89dc\u2875".toCharArray();
        cArray[12] = (char)(cArray[12] ^ 0x1FCE);
        logger.debug(ahhytmns.e(cArray, (short)18966, (short)1, (short)0));
        char[] cArray2 = "\ucd35\u9fe5\u549f\u35be\ub7af\u31e9".toCharArray();
        cArray2[3] = (char)(cArray2[3] ^ 0x2B12);
        char[] cArray3 = "\u64ba\ud606\u5312\u1c93\uf00b\u7bf8".toCharArray();
        cArray3[1] = (char)(cArray3[1] ^ 0x3C8C);
        ARMPClient.Dv("-10i0od7", this.serverTransaction, this.voucher, (Object)this.machineFilePath, (Object)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), this.machineFilePath), ahhytmns.e(cArray2, (short)1620, (short)5, (short)2))), (Object)this.extraInfo, (Object)ARMPClient.Dv("ahl7iq", this.machineFilePath, ahhytmns.e(cArray3, (short)8019, (short)1, (short)2)), (Object)new ByteArrayInputStream(this.certBytes));
    }

    private void checksign() throws ArubaLicensingException {
        try {
            Object x509 = ARMPClient.Dv("3k77io", this.certBytes);
            char[] cArray = "\ubb42\u45f0\u9e53\ub313\u169c\u6da5\u059e\ue87e\uab6c\udc27\ua9bf\u4416".toCharArray();
            cArray[4] = (char)(cArray[4] ^ 0x590D);
            Object sig = ARMPClient.Dv("-11god9", ahhytmns.e(cArray, (short)18547, (short)4, (short)5));
            ARMPClient.Dv("-1v8qod3", sig, ARMPClient.Dv("-12j2od2", x509));
            FileInputStream datafis = new FileInputStream(new File(this.machineFilePath));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(datafis);
            Throwable throwable = null;
            try {
                byte[] buffer = new byte[1024];
                int len = 0;
                while (ARMPClient.Dv("-1566od4", bufferedInputStream, buffer) != -1) {
                    ARMPClient.Dv("-eacod5", sig, buffer, (int)0, (int)len);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bufferedInputStream != null) {
                    if (throwable != null) {
                        try {
                            ARMPClient.Dv("g057ii", bufferedInputStream);
                        }
                        catch (Throwable throwable3) {
                            ARMPClient.Dv("1hin7j4", throwable, throwable3);
                        }
                    } else {
                        ARMPClient.Dv("g057ii", bufferedInputStream);
                    }
                }
            }
            char[] cArray2 = "\ua6c3\u327e\u60cf\u7b53\u2dcb\u40e1".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x45B1);
            if (ARMPClient.Dv("170f7ih", sig, this.getBytesFromFile(new File((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), this.machineFilePath), ahhytmns.e(cArray2, (short)30309, (short)2, (short)5)))))) != false) {
                char[] cArray3 = "\u6f2d\ue03d\ubdcf\u02be\uc23a\ub59c\ufff5\u4641\u4db7\ub725\ua767\u826a\u6bb2\u6a00\ue0c4\u4827\u214e\ub60d\u408d\u45f7\u59f3\ubbee\uf786\ueb83\u1f47\u6ec0\u756a\u72e0".toCharArray();
                cArray3[10] = (char)(cArray3[10] ^ 0xFF4);
                char[] cArray4 = "\u11a7\u44b2\u1cd6\u0cce\u1b1f\u8dfc\uc73e\u14d8\u6494\u032a\u50f3\ude5d\u0873\ucb9e\u4ffc\ud928\u60bd".toCharArray();
                cArray4[3] = (char)(cArray4[3] ^ 0x28AC);
                throw new ArubaLicensingException(ahhytmns.e(cArray3, (short)11696, (short)1, (short)4), ahhytmns.e(cArray4, (short)7717, (short)4, (short)5));
            }
        }
        catch (Exception ex) {
            logger.error((String)ARMPClient.Dv("-t1aoct", ex), (Throwable)ex);
            throw new ArubaLicensingException(ex);
        }
    }

    private byte[] getBytesFromFile(File file) throws Exception {
        byte[] bytes;
        FileInputStream is = new FileInputStream(file);
        Throwable throwable = null;
        try {
            int offset;
            Object object;
            char[] cArray = "\u91c6\u3aad\u6641\u9508\u6d86\u31ac\u9133\u4deb\u9b25\u6d70\u07ff\u0923\ub757\udece\u2b13\u3386\u3d63\ucd23\uf74c\u1e76".toCharArray();
            cArray[10] = (char)(cArray[10] ^ 0xB97);
            logger.debug((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("uf97ig", ARMPClient.Dv("-92iofo", new StringBuilder(), lfirhpid.H(cArray, (short)27256, false, (byte)2)), file)));
            Object length = ARMPClient.Dv("-tv6odh", file);
            char[] cArray2 = "\uf98b\u495f\uaa35\ua9dc\u8a16\ue2a3\ud062\u84db\u5958\u9fa6\u75f9".toCharArray();
            cArray2[8] = (char)(cArray2[8] ^ 0x1916);
            char[] cArray3 = "\uaf68\ud959\ue3d8\uf587\u5366".toCharArray();
            cArray3[0] = (char)(cArray3[0] ^ 0x4C01);
            char[] cArray4 = "\u4299\u7d18".toCharArray();
            cArray4[0] = (char)(cArray4[0] ^ 0x750F);
            logger.debug((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-5t8oda", ARMPClient.Dv("-92iofo", ARMPClient.Dv("uf97ig", ARMPClient.Dv("-92iofo", new StringBuilder(), lfirhpid.H(cArray2, (short)25665, true, (byte)2)), file), lfirhpid.H(cArray3, (short)4351, false, (byte)4)), (long)length), lfirhpid.H(cArray4, (short)28932, false, (byte)2))));
            if (length > Integer.MAX_VALUE) {
                char[] cArray5 = "\ue3fe\u8f55\u9888\u2371\uee78\uaed4\u3da0\u2f56\uf49c\uf152\u00e1\ufa57\ua5ef\u813e\uc7ec\uecca\u4b51\ub709\u2e34\ue9ff\u502d\u0793\u6fa7\ud61e\u3f55\uf479\u64d7\uad05\u327d".toCharArray();
                cArray5[9] = (char)(cArray5[9] ^ 0x153);
                logger.error(lfirhpid.H(cArray5, (short)3291, false, (byte)3));
                byte[] byArray = null;
                return byArray;
            }
            bytes = new byte[(int)length];
            boolean bl = false;
            for (offset = 0; offset < bytes.length && (object = ARMPClient.Dv("-1vl8odc", is, bytes, (int)offset, (int)(bytes.length - offset))) >= 0; offset += object) {
            }
            if (offset < bytes.length) {
                char[] cArray6 = "\u6ee8\ua801\u584f\u2ab5\u8c31\u96a6\uc890\u803b\ud510\u8324\uddf7\u3a5f\u2df6\u89e4\uaef7\u4f31\u7ab4\ud668\u258c\ue1de\u2c9d\ufa44\u2ab8\u500d\u1287\u978e\u19f2\ud917\u305a\u4847\ude37\u2206".toCharArray();
                cArray6[15] = (char)(cArray6[15] ^ 0x3028);
                throw new Exception((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), lfirhpid.H(cArray6, (short)24852, false, (byte)4)), ARMPClient.Dv("1m0l7ij", file))));
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (is != null) {
                if (throwable != null) {
                    try {
                        ARMPClient.Dv("1ksj7il", is);
                    }
                    catch (Throwable throwable3) {
                        ARMPClient.Dv("1hin7j4", throwable, throwable3);
                    }
                } else {
                    ARMPClient.Dv("1ksj7il", is);
                }
            }
        }
        return bytes;
    }

    private MachineIDProto.MachineID readMachinIDFile(String machineBinPath) throws ArubaLicensingException {
        try {
            ARMPClient.Dv("2d97ia", machineBinPath);
            return ARMPClient.Dv("-102odn", new FileInputStream(machineBinPath));
        }
        catch (Exception ex) {
            logger.error((String)ARMPClient.Dv("-t1aoct", ex), (Throwable)ex);
            throw new ArubaLicensingException(ex);
        }
    }

    private static boolean checkVoucher(String voucher, String voucherPath) throws ArubaLicensingException {
        try {
            byte[] vouByte = (byte[])ARMPClient.Dv("m737i8", ARMPClient.Dv("std7gb", voucherPath, new String[0]));
            String vouStr = new String(vouByte, StandardCharsets.UTF_8);
            char[] cArray = "\u1699\u05cf".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x7356);
            char[] cArray2 = "\ue228\u31cc".toCharArray();
            cArray2[0] = (char)(cArray2[0] ^ 0x4128);
            voucher = ARMPClient.Dv("-1t7kodp", ARMPClient.Dv("-1t7kodp", voucher, ahhytmns.e(cArray, (short)2482, (short)3, (short)3), (Object)""), ahhytmns.e(cArray2, (short)15838, (short)0, (short)0), (Object)"");
            char[] cArray3 = "\u6c77\u554b".toCharArray();
            cArray3[0] = (char)(cArray3[0] ^ 0x16DC);
            char[] cArray4 = "\u701c\u3e86".toCharArray();
            cArray4[0] = (char)(cArray4[0] ^ 0x557B);
            return (boolean)ARMPClient.Dv("-v6eodi", voucher, ARMPClient.Dv("-1t7kodp", ARMPClient.Dv("-1t7kodp", vouStr, ahhytmns.e(cArray3, (short)26058, (short)0, (short)1), (Object)""), ahhytmns.e(cArray4, (short)6680, (short)1, (short)0), (Object)""));
        }
        catch (Exception ex) {
            logger.error((String)ARMPClient.Dv("-t1aoct", ex), (Throwable)ex);
            throw new ArubaLicensingException(ex);
        }
    }

    public static void resetLicense(String workingDir) throws ArubaLicensingException {
        char[] cArray = "\ucc0b\u79b8\u0e83\ub765\u0df0\u7279\u4166\u6d7a\u8d01\ud64e\u9263\u6ef4\u4fee\u364a".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x561B);
        logger.info(lracmqsd.H(cArray, (short)17675, (byte)2, (byte)1));
        try {
            char[] cArray2 = "\u49b9\ub1f7\u1153\uc463\uaa3a\uab0f\u8a1e\u6608\u0ff0\u475d\uf237\uf7e9\u98c6\ue59b\u7f25".toCharArray();
            cArray2[7] = (char)(cArray2[7] ^ 0x109E);
            if (ARMPClient.Dv("-138eobu", ARMPClient.Dv("std7gb", ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), workingDir), File.separator), lracmqsd.H(cArray2, (short)26067, (byte)3, (byte)2))), new String[0]), new LinkOption[0]) != false) {
                char[] cArray3 = "\u79fa\u6e0c\u7877\u58f4\u2190\ucfe6\ud68d\u5e20\u0de3\u6f2d\u1b04\u0f31\u56e0\u4b86\u4ce6".toCharArray();
                cArray3[8] = (char)(cArray3[8] ^ 0x51CE);
                ARMPClient.Dv("-1mjmodj", ARMPClient.Dv("std7gb", ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), workingDir), File.separator), lracmqsd.H(cArray3, (short)30221, (byte)0, (byte)3))), new String[0]));
            }
            char[] cArray4 = "\u2f3b\ub928\u7d66\u45b1\u3028\u2e6a\ua23a\u0a8b\u5f07\u3cee".toCharArray();
            cArray4[6] = (char)(cArray4[6] ^ 0x6C3E);
            char[] cArray5 = "\ucd1d\u9802\ue929\ud77e\u39d2".toCharArray();
            cArray5[3] = (char)(cArray5[3] ^ 0x3B4B);
            if (ARMPClient.Dv("-138eobu", ARMPClient.Dv("std7gb", ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), workingDir), File.separator), lracmqsd.H(cArray4, (short)12275, (byte)3, (byte)4)), lracmqsd.H(cArray5, (short)16431, (byte)5, (byte)3))), new String[0]), new LinkOption[0]) != false) {
                char[] cArray6 = "\u3533\uffe9\ua74e\u4b4a\u46a1\udc5c\u6767\ud75a\u87c4\u55ea".toCharArray();
                cArray6[8] = (char)(cArray6[8] ^ 0x7F5C);
                char[] cArray7 = "\ubfb9\ufd3f\uf660\ucff9\u652a".toCharArray();
                cArray7[3] = (char)(cArray7[3] ^ 0x6A3E);
                ARMPClient.Dv("-1mjmodj", ARMPClient.Dv("std7gb", ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), workingDir), File.separator), lracmqsd.H(cArray6, (short)12754, (byte)4, (byte)0)), lracmqsd.H(cArray7, (short)7521, (byte)4, (byte)5))), new String[0]));
            }
            char[] cArray8 = "\u4138\ue100\udab2\u5327\uaf6a\u6ffc\u7fb3\u301b\u6f51\u5488".toCharArray();
            cArray8[3] = (char)(cArray8[3] ^ 0x1909);
            char[] cArray9 = "\uec82\u2fbc\u9cdd\u792a\u700b".toCharArray();
            cArray9[0] = (char)(cArray9[0] ^ 0x7EC5);
            char[] cArray10 = "\u92fe\uc263\u40a7\u9427\u3073\u65be".toCharArray();
            cArray10[1] = (char)(cArray10[1] ^ 0x11BE);
            if (ARMPClient.Dv("-138eobu", ARMPClient.Dv("std7gb", ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), workingDir), File.separator), lracmqsd.H(cArray8, (short)2977, (byte)4, (byte)4)), lracmqsd.H(cArray9, (short)28513, (byte)1, (byte)1)), lracmqsd.H(cArray10, (short)7578, (byte)4, (byte)5))), new String[0]), new LinkOption[0]) != false) {
                char[] cArray11 = "\udf5a\ucd18\ua77d\uc49f\uabde\ue99d\u3fd6\ue595\u73e8\u624e".toCharArray();
                cArray11[8] = (char)(cArray11[8] ^ 0x900);
                char[] cArray12 = "\u263e\u2b83\u37ea\u5b98\u453e".toCharArray();
                cArray12[1] = (char)(cArray12[1] ^ 0x152E);
                char[] cArray13 = "\u3215\u7c4b\u405c\ubf93\u15f8\u1b0b".toCharArray();
                cArray13[4] = (char)(cArray13[4] ^ 0x16EB);
                ARMPClient.Dv("-1mjmodj", ARMPClient.Dv("std7gb", ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), workingDir), File.separator), lracmqsd.H(cArray11, (short)10061, (byte)0, (byte)4)), lracmqsd.H(cArray12, (short)23901, (byte)0, (byte)2)), lracmqsd.H(cArray13, (short)30404, (byte)3, (byte)0))), new String[0]));
            }
            char[] cArray14 = "\u867d\u32c0\u4d05\u346f\ub573\u61d0\u0726\u42ea\u567f\u1c17\u034e\u54bc\u9022\u3a0b".toCharArray();
            cArray14[2] = (char)(cArray14[2] ^ 0x6C7B);
            logger.info(lracmqsd.H(cArray14, (short)28976, (byte)0, (byte)5));
        }
        catch (Exception ex) {
            logger.error((String)ARMPClient.Dv("-t1aoct", ex), (Throwable)ex);
            throw new ArubaLicensingException(ex);
        }
    }

    private void extractP12Cert(String filePath) throws ArubaLicensingException {
        char[] cArray = "\u815a\u925e\ub7a7\u2e23\ub255\ucc70\u9d8f\u7895\u6844\u83db\ub00b\u10af\u8ece\u296b\uf367\ud60d\u03ad".toCharArray();
        cArray[4] = (char)(cArray[4] ^ 0x773);
        logger.info(lracmqsd.H(cArray, (short)28942, (byte)3, (byte)1));
        try {
            Object p12String = ARMPClient.Dv("-tj8odk", this.machineId);
            byte[] p12Byte = (byte[])ARMPClient.Dv("gmt7m2", ARMPClient.Dv("-21modl"), p12String);
            File file = new File(filePath);
            ARMPClient.Dv("-mi2o9v", file, p12Byte);
            this.p12CertByte = p12Byte;
        }
        catch (Exception ex) {
            logger.error((String)ARMPClient.Dv("-t1aoct", ex), (Throwable)ex);
            throw new ArubaLicensingException(ex);
        }
        char[] cArray2 = "\uf6f7\uedc0\ucec2\uebc8\u009d\u50a1\u0cdc\uc3da\uea0b\u0944\udc8d\u08d4\uf203\ub059\u43e8\ud017\uf9ee\ubfcf\u4571\u64a5".toCharArray();
        cArray2[14] = (char)(cArray2[14] ^ 0x5F0D);
        logger.info(lracmqsd.H(cArray2, (short)30981, (byte)4, (byte)3));
    }

    private boolean validateP12Cert() throws ArubaLicensingException {
        char[] cArray = "\u3222\ua8ee\u5004\u8bae\ua3f4\u3d15\ucf22\u3a14\ud740\u9908\u4207\u3703\uda94\u25bf\uc707\u4c44\u97c5\u7539\u02eb\u37ef\u7cde\uf9e3\u39fe\u0b61\u9c3a\u18c4\u20e1".toCharArray();
        cArray[3] = (char)(cArray[3] ^ 0x1990);
        logger.info(ahhytmns.e(cArray, (short)11219, (short)3, (short)4));
        try {
            char[] cArray2 = "\ue14d\ub514\u88fb\u09d2\u4da1\uc273\ufaa1\u09e2\u48f2".toCharArray();
            cArray2[4] = (char)(cArray2[4] ^ 0x4790);
            char[] cArray3 = "\u29fb\u1ef5\ub221\u0856\u0fcb\uf4e3\u9c4f\u33cb\u697d".toCharArray();
            cArray3[4] = (char)(cArray3[4] ^ 0x1FBD);
            ARMPClient.Dv("i0b7m0", ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), this.workingDir), File.separator), ahhytmns.e(cArray2, (short)31583, (short)0, (short)1)), File.separator), this.p12Name)), ahhytmns.e(cArray3, (short)32724, (short)3, (short)0));
        }
        catch (ArubaLicensingException ale) {
            char[] cArray4 = "\ue9e1\uedb7\u32ad\u41cc\u7787\u25bb\u546b\uf3fb\uc559\ua91f\u552e\u6b65\u1369\ud5fd\ub7f5\ufd63\uf0e1\u3e65\u53ad\uddd9\uabfc\u8724\ucf06\ufbbe\u867c\u4f2c\ud4da\ubdb0\ue34d\ud859\u09f5\u6316\uae5b\u62e8".toCharArray();
            cArray4[19] = (char)(cArray4[19] ^ 0x325C);
            logger.error(ahhytmns.e(cArray4, (short)29175, (short)2, (short)0));
            return false;
        }
        char[] cArray5 = "\ucfec\u929d\ued88\ued85\u240f\u63a6\u67f1\u55bc\ud113\u32be\ua18b\uda42\ua750\u34d7\ud9b9\u8eb4\ue774\u70b1\uc0ec\u35fa\ubbf5\u356d\u0347\u2ce5\u5c8d\ueb35\u82be\u7cd3\u1c3f\uc563\ud7a9\u6975".toCharArray();
        cArray5[26] = (char)(cArray5[26] ^ 0x5A2B);
        logger.info(ahhytmns.e(cArray5, (short)26400, (short)5, (short)3));
        return true;
    }

    private void initSubFolder() throws ArubaLicensingException {
        char[] cArray = "\u9925\u5ce5\u46a3\uc27b\u58d8\u5449\u174f\u0b10\u7255\u8ce4\u21a8\u35eb\u80a2\uaff6\u8516\u8182\ucabb\udadc\u58ab\u8f3a\uc9f8\u5ae2\u8a9e\u36b4".toCharArray();
        cArray[21] = (char)(cArray[21] ^ 0x46B1);
        logger.debug(lracmqsd.H(cArray, (short)12081, (byte)1, (byte)4));
        char[] cArray2 = "\ub43e\ufc9b\u0bd2\uffbd\uae4a\ub64f\u8335\ufbdb\u3360".toCharArray();
        cArray2[1] = (char)(cArray2[1] ^ 0x356C);
        Object path = ARMPClient.Dv("std7gb", ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), this.workingDir), File.separator), lracmqsd.H(cArray2, (short)14715, (byte)0, (byte)0))), new String[0]);
        if (ARMPClient.Dv("143d7k5", path, new LinkOption[0]) != false) {
            try {
                ARMPClient.Dv("8tt7lv", path, new FileAttribute[0]);
            }
            catch (Exception ex) {
                logger.error((String)ARMPClient.Dv("-t1aoct", ex), (Throwable)ex);
                throw new ArubaLicensingException(ex);
            }
        }
        char[] cArray3 = "\ubb17\u7ef7\uf894\uefad\u5c27\u2b4e\u9f4f\u6d57\u53b2".toCharArray();
        cArray3[4] = (char)(cArray3[4] ^ 0x4930);
        char[] cArray4 = "\u15ef\u02ec\u3d71\u9c2b\ubcb5\ufc81\u54cd\uf9ac\u6d8c\u1d86\u5845\ue94e\u32a5".toCharArray();
        cArray4[7] = (char)(cArray4[7] ^ 0x2645);
        path = ARMPClient.Dv("std7gb", ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), this.workingDir), File.separator), lracmqsd.H(cArray3, (short)14426, (byte)2, (byte)5)), File.separator), lracmqsd.H(cArray4, (short)8623, (byte)0, (byte)0))), new String[0]);
        if (ARMPClient.Dv("143d7k5", path, new LinkOption[0]) != false) {
            try {
                ARMPClient.Dv("8tt7lv", path, new FileAttribute[0]);
            }
            catch (Exception ex) {
                logger.error((String)ARMPClient.Dv("-t1aoct", ex), (Throwable)ex);
                throw new ArubaLicensingException(ex);
            }
        }
        char[] cArray5 = "\ue741\uf5ae\u4283\uff3b\u7f75\uc0b9\u1da1\u134d\u7df4\u1fd1\u8c73\uf6f3\u5ad2\u917e\uc52a\u8532\ua7e6\u5479\ua6e8\u0eee\u578e\ue441\u5918".toCharArray();
        cArray5[4] = (char)(cArray5[4] ^ 0x3A2E);
        logger.info(lracmqsd.H(cArray5, (short)12089, (byte)1, (byte)1));
    }

    private void challenge() throws ArubaLicensingException {
        if (ARMPClient.Dv("-v6eodi", this.productName, ARMPClient.Dv("-puoo9q", this.machineId)) != false) {
            FingerPrint challangeFingerPrint = new FingerPrint();
            ARMPClient.Dv("110t7ji", challangeFingerPrint);
            int estimate = 0;
            if (ARMPClient.Dv("-v6eodi", ARMPClient.Dv("-10qeo9r", this.machineId), ARMPClient.Dv("-1uj2ock", challangeFingerPrint)) != false) {
                estimate += 35;
            }
            if (ARMPClient.Dv("-v6eodi", ARMPClient.Dv("1e9n7m4", this.machineId), ARMPClient.Dv("1nat7jg", challangeFingerPrint)) != false) {
                estimate += 25;
            }
            if (ARMPClient.Dv("-v6eodi", ARMPClient.Dv("-1ulgo9t", this.machineId), ARMPClient.Dv("ug97j8", challangeFingerPrint)) != false) {
                estimate += 50;
            }
            if (estimate >= 75) {
                char[] cArray = "\u36af\uce8a\u997b\ud857\u9399\uf4b7\u911d\u1e8f\u9979\u4f66\u32f9\u13be\u25f2".toCharArray();
                cArray[6] = (char)(cArray[6] ^ 0x4574);
                logger.info(lracmqsd.H(cArray, (short)7845, (byte)4, (byte)5));
                return;
            }
            if (ARMPClient.Dv("-v6eodi", ARMPClient.Dv("f5d7lq", this.machineId), ARMPClient.Dv("1agl7jm", challangeFingerPrint)) != false) {
                estimate += 10;
            }
            if (ARMPClient.Dv("-v6eodi", ARMPClient.Dv("-15beoa7", this.machineId), ARMPClient.Dv("-208oci", challangeFingerPrint)) != false) {
                estimate += 10;
            }
            if (ARMPClient.Dv("-v6eodi", ARMPClient.Dv("fl57lo", this.machineId), ARMPClient.Dv("-b4gocm", challangeFingerPrint)) != false) {
                estimate += 5;
            }
            if (ARMPClient.Dv("-v6eodi", ARMPClient.Dv("1omf7ln", this.machineId), ARMPClient.Dv("-l3kocc", challangeFingerPrint)) != false) {
                ++estimate;
            }
            if (estimate < 75) {
                char[] cArray = "\u3d3b\u335d\u3ee0\u62a9\ue796\u120d\u4378\u5a17\uce12\ub9d9\uc690\uc9ec\u96d3\u40af\ue31c\ubb98\u3059\u1c2d\u35dc\uf550\u26cc\ua448\u3b0a\ua42c\u33c9\ufd41\uacf2\u27d3\u6d76\u94a3\ucb61\ub45c\u7d55\u1d7d\u9ea1\ua50f\u9920\ubd9a\u4fab\u2e00\u0f96\ud198\ue8bf\ue9aa\udacd\u6760\ub7c6\ub430\u8c2d\u4b8c".toCharArray();
                cArray[44] = (char)(cArray[44] ^ 0x2A73);
                logger.info(lracmqsd.H(cArray, (short)3186, (byte)0, (byte)2));
                char[] cArray2 = "\u42af\u117c\uebf5\u7aec\uf5a4\uaaa4\ue02b\ufacc\u2f67\u3f86\u0d59\u5a0f\ue27c\ub5d3\u7668\u0eb4".toCharArray();
                cArray2[9] = (char)(cArray2[9] ^ 0xE18);
                char[] cArray3 = "\u496d\u99fe\u71d4\u1077\uccb4\u50ee\u3eaa\uf281\u56b4\u8b69\u0b35\ufdd7\u6f53\ud84b\u7284\u8695\ub6f0\u200f".toCharArray();
                cArray3[11] = (char)(cArray3[11] ^ 0x3CAE);
                throw new ArubaLicensingException(lracmqsd.H(cArray2, (short)29675, (byte)2, (byte)4), lracmqsd.H(cArray3, (short)22968, (byte)0, (byte)3));
            }
        } else {
            char[] cArray = "\u1502\u0395\u3ffe\udfcc\ud780\uf00a\uacf0\u96d6\uce16\u3037\u411a\ubbdb\ued76\u2ba3\u52b0\u61ab\u99bf\ud4c2\u23f3\u0284\u7500\u00e7\uc235\uf593\ucedf\u1683\u7e12\u1bb6\u0fbc\ubf23\u3413\u2738\u7e32".toCharArray();
            cArray[23] = (char)(cArray[23] ^ 0x6436);
            logger.info(lracmqsd.H(cArray, (short)15657, (byte)5, (byte)0));
            char[] cArray4 = "\u2e52\u0e1b\uc16d\u0f8f\u28dc\u6bbf\ucba1\u3671\u0ec8\u2a92\u1ea5\ud0d5\uda56\u4c2f\u42fe\u7263".toCharArray();
            cArray4[14] = (char)(cArray4[14] ^ 0x3887);
            char[] cArray5 = "\ue6ef\u9229\u1cfc\u59e5\ua975\u449d\u464b\u06dd\ue766\ub597\uf95e\u2d84\u922a\ua965\u5c01\ub999\u8139\u11b9".toCharArray();
            cArray5[13] = (char)(cArray5[13] ^ 0x6322);
            throw new ArubaLicensingException(lracmqsd.H(cArray4, (short)11250, (byte)1, (byte)2), lracmqsd.H(cArray5, (short)15482, (byte)5, (byte)3));
        }
        char[] cArray = "\u779e\u3068\u229b\u5da3\ud0fd\u9aac\u49d8\u5804\u8a1a\u41ed\ua83c\u12c2\u5d4d".toCharArray();
        cArray[4] = (char)(cArray[4] ^ 0x7994);
        logger.info(lracmqsd.H(cArray, (short)15411, (byte)3, (byte)1));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void isExpired() throws ArubaLicensingException {
        Date expiration;
        boolean isValid = true;
        if (this.isGraphometricSoftware) {
            isValid = this.validateP12Cert();
        }
        if (ARMPClient.Dv("k8p7lt", expiration = new Date((long)(ARMPClient.Dv("r217lu", this.machineId) * 1000L)), new Date()) == false && isValid) {
            char[] cArray = "\u49b6\u7327\u4643\u7056\uc5b6\u48ad\ua669\u1d05\u0759\ud064\u4464".toCharArray();
            cArray[7] = (char)(cArray[7] ^ 0x5806);
            logger.debug(ahhytmns.e(cArray, (short)21007, (short)1, (short)5));
            return;
        }
        char[] cArray = "\ub86b\u6de0\ucf00\u2095\u9291\u602c\u019f\ud07a\u70fe\ubd88\u3e70\ubd69\u5fd9\uc7df\u6d81\u49a4".toCharArray();
        cArray[3] = (char)(cArray[3] ^ 0x4698);
        logger.info(ahhytmns.e(cArray, (short)30356, (short)1, (short)4));
        if (ARMPClient.Dv("-htsoa4", this.machineId) != false) {
            char[] cArray2 = "\ud7ac\u04e6\ucf8a\ud705\u7330\ucf9b\uc58b\u8218\u639a\u3c51\u7af2\uedf0\u3491\u1cfa\uaffd\u6ebe\ufaa4\ua245\u8ce1\u3da6\u7f2d\u5909\uf86a\u69ca\ua8e5\u5c56".toCharArray();
            cArray2[23] = (char)(cArray2[23] ^ 0x5C71);
            logger.info(ahhytmns.e(cArray2, (short)16000, (short)5, (short)3));
            this.generate();
            if (!this.isGraphometricSoftware) return;
            char[] cArray3 = "\u60fc\uc9ea\u51e1\u1fc5\uc0ba\u6cfd\uf5b8\u021d\u55be".toCharArray();
            cArray3[6] = (char)(cArray3[6] ^ 0x5B3E);
            this.extractP12Cert((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), this.workingDir), File.separator), ahhytmns.e(cArray3, (short)15797, (short)3, (short)5)), File.separator), this.p12Name)));
            return;
        }
        char[] cArray4 = "\u6e4f\u329f\u40d5\u1b8d\ua415\u0da7\ua3bb\u841d\u736a\u75a6\ua8e8\u3387\u7760\uba62\u58d0\u5d85\ud3c8\u0657\uf185\u155c\u8598\ucc33\udf2c\uc24e\ud17d\u3219\uab83\ub793\u12ff".toCharArray();
        cArray4[4] = (char)(cArray4[4] ^ 0x454F);
        logger.error(ahhytmns.e(cArray4, (short)21869, (short)3, (short)2));
        char[] cArray5 = "\u6e6f\ub535\u841f\u64f2\uc537\u6452\u803f\udb69\ue23c\u2a5d\ua6bb\u15c9\udb59\ue8be\u65c4\u1950".toCharArray();
        cArray5[2] = (char)(cArray5[2] ^ 0x18B8);
        char[] cArray6 = "\u1702\ufa47\u9bd4\u8b6d\u2e23\u432e\u199d\u4589\u76c3\ubf55\ue936\ue3c2\ue6e7\ufba4\uc116\u0a72".toCharArray();
        cArray6[13] = (char)(cArray6[13] ^ 0x7A5);
        throw new ArubaLicensingException(ahhytmns.e(cArray5, (short)19593, (short)2, (short)2), ahhytmns.e(cArray6, (short)27148, (short)4, (short)4));
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        v0 = "\u2f9f\ua770\ua8a1\uba1f\u3cae\u75a7\u6ea1\u1e6f\uab44\uaa3d\ua00a\u8e3f\u2ceb\udd34\u21e1\u323d\ua480\u785c".toCharArray();
        v0[2] = (char)(v0[2] ^ 26891);
        workingDir = lfirhpid.H(v0, (short)24738, true, (byte)0);
        try {
            v1 = "\ud38a\u2905\uc8fe\u3405\u4fbc\u40f5\u97ba\u86ab\ua107\u7fbd\u5611".toCharArray();
            v1[2] = (char)(v1[2] ^ 32146);
            v2 = "\ua555\u3da9\u74c6\ubb96\u56da\u358f\u3752\u3c67\u3223\u0b59\u1cfa\u1e0b\u1173\u69a5\u3f81\ud585\ua25a\u509a\uddff\u2ac5".toCharArray();
            v2[10] = (char)(v2[10] ^ 5836);
            licensing = new ARMPClient(workingDir, lfirhpid.H(v1, (short)12936, false, (byte)2), lfirhpid.H(v2, (short)24149, false, (byte)4), false, true, true, null, false);
            v3 = "\udd0e\ufd84\ucd51\u7404\u475a\ub8a6\u788a\u54f1\u36c1\u6240\uac91\ucce6\ued91\ub7e8\u66e0\ue95b\u65ca\u39bd\u7746\ue82e\u3685\u6d73\u3511\ub3cd\u4c6e\u99bc\uef1a\u4861\ub688\u8d2e\u3b7e\ud49c\u5f89\ua329\uc22a\u7c17\u558f\ubded\ua9d6\u8de5\u71ec\u1840".toCharArray();
            v3[14] = (char)(v3[14] ^ 14273);
            ARMPClient.Dv("11it7lr", System.out, ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), lfirhpid.H(v3, (short)2885, false, (byte)0)), licensing.getMachineUUID())));
            v4 = "\ub7a6\u6337\u4389\u0583\u852b\u53f9".toCharArray();
            v4[0] = (char)(v4[0] ^ 29120);
            policy = licensing.queryPolicy(lfirhpid.H(v4, (short)27605, false, (byte)2));
            ARMPClient.Dv("11it7lr", System.out, policy);
            v5 = "\u24ba\u7055\uead4\u0b37\u207e\u4707".toCharArray();
            v5[2] = (char)(v5[2] ^ 16163);
            policy = licensing.updatePolicy(lfirhpid.H(v5, (short)4687, false, (byte)4), 1L);
            ARMPClient.Dv("11it7lr", System.out, policy);
        }
        catch (ArubaLicensingException ex) {
            if (ARMPClient.Dv("caf7li", ex) == null) ** GOTO lbl-1000
            v6 = "\uf0f5\uc690\u7609\u2bbb\uf858\u10f1\uc6e3\u52ba\u5985\u9f41\ub2ca\ufa02\u3e9d\u303b\u28b6\u1292\udebe\ucd4e\u6e42".toCharArray();
            v6[6] = (char)(v6[6] ^ 17465);
            if (ARMPClient.Dv("-kimoaf", ARMPClient.Dv("caf7li", ex), lfirhpid.H(v6, (short)17327, false, (byte)5)) != false) {
                v7 = "\uecbd\uc418\uf53c\uc10a\u639a\uc2ed\u35b3\ub26c\u78f2\uc2f9\u4118\uc035\ud6b4\u96b9\uc5ac\u791c\u5d38\u0c2c\uda36\u9bcf\u986d\u66ac\u873e\u8a41\u4948\u0581\ud811\u8b14\uec7f\u355e\u29b0\u20d5\u2d07\ue3d9\uf79a\ue847\u6ac0\ud52c\ud3cc\u3d26\ud3ac\u9957\ueb2d\u323e\u36f3\ud2c4\u54d9\u5b10\uf58f\u52f2\u48b6\u5557\u0bf8\u5a2b\ufd73\uace8\udcd8\u046b\u39e0\u260d\uaeff\u9091\u2bea\u3db9\ua8cc\ud859\u2bd7\u184a\uceaa\ud8a1\ubb3a\u7ae8\u6a29".toCharArray();
                v7[22] = (char)(v7[22] ^ 19748);
                ARMPClient.Dv("11it7lr", System.out, ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("uf97ig", ARMPClient.Dv("-92iofo", new StringBuilder(), lfirhpid.H(v7, (short)20889, true, (byte)4)), ex)));
                try {
                    v8 = "\uc4e5\ua00a\u2567\u956e\ud720\u9caf\ufbe2\u7605\u9efc\uf541\ubc46\ud8cf\u5337\u4a66\u274d".toCharArray();
                    v8[3] = (char)(v8[3] ^ 22769);
                    ARMPClient.Dv("-nr8oag", new File((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), workingDir), lfirhpid.H(v8, (short)30621, true, (byte)1)))));
                    v9 = "\u4f3d\udc65\ufc87\ucac9\uc22b\ud7ee\udfad\u0b0a\u8bce\u39d1\u11bc\u8ee0\u6b19\uc20d\ub0a8\u6aa5\u9cff\ud04f\ua57bE".toCharArray();
                    v9[11] = (char)(v9[11] ^ 8424);
                    ARMPClient.Dv("-nr8oag", new File((String)ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), workingDir), lfirhpid.H(v9, (short)23598, false, (byte)2)))));
                }
                catch (Exception e) {
                    ARMPClient.Dv("6dn7lf", e);
                }
            } else lbl-1000:
            // 2 sources

            {
                v10 = "\u0fb1\u550e\uff70\ucab2\u27ca\ua8e2\u7186\u639d\ua1c5\u6f06\u4fde".toCharArray();
                v10[4] = (char)(v10[4] ^ 12202);
                ARMPClient.Dv("11it7lr", System.out, ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), lfirhpid.H(v10, (short)14594, false, (byte)3)), ARMPClient.Dv("-1aloofn", ex))));
            }
            ARMPClient.Dv("dnh7lm", ex);
        }
        catch (Exception e) {
            ARMPClient.Dv("6dn7lf", e);
            v11 = "\u5f6d\ub6f3\u4b6a\u243c\ubc8e\u6d5d\uf9ef\uc2bd\u939d\u223d\u4500\uadd0\u3797\u954f\u41fc\u11ee".toCharArray();
            v11[10] = (char)(v11[10] ^ 5465);
            ARMPClient.Dv("11it7lr", System.out, ARMPClient.Dv("-fp8ofi", ARMPClient.Dv("-92iofo", ARMPClient.Dv("-92iofo", new StringBuilder(), lfirhpid.H(v11, (short)16650, false, (byte)5)), ARMPClient.Dv("-t1aoct", e))));
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    private static Object Dv(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(nyigamxj.u(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

