/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils.soap;

import it.actalis.ellips.capi.http.arubautils.soap.ConfigParameter;
import it.actalis.ellips.capi.http.arubautils.soap.NullTrustManager;
import it.actalis.ellips.capi.http.arubautils.soap.SimpleAutenticator;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLUtils {
    private static final Logger logger = LoggerFactory.getLogger(URLUtils.class);
    private static SSLContext sc2;
    private static SSLSocketFactory scf2;

    public static byte[] downloadUrl(String strUrl, byte[] postdate, ConfigParameter objConfig, String strType, String action) {
        byte[] arrReturn = null;
        try {
            Authenticator.setDefault(new SimpleAutenticator(objConfig));
            HashMap<String, String> lstProperty = new HashMap<String, String>();
            if (strType.equals("TSA")) {
                lstProperty.put("Content-Type", "application/timestamp-query");
            } else if (strType.equals("RS")) {
                lstProperty.put("Content-Type", "text/xml");
            } else if (strType.equals("SOAP")) {
                lstProperty.put("Content-Type", "text/xml;charset=UTF-8");
            } else if (strType.equals("SOAP2")) {
                lstProperty.put("Content-Type", "text/xml;charset=UTF-8");
            }
            if (action != null && !action.equals("")) {
                if (action.equals("empty")) {
                    lstProperty.put("SOAPAction", "");
                } else {
                    lstProperty.put("SOAPAction", action);
                }
            }
            if (strUrl.toLowerCase().startsWith("ldap")) {
                throw new IOException("Protocollo non supportato");
            }
            arrReturn = strUrl.toLowerCase().startsWith("http") ? URLUtils.downloadOverHTTP(strUrl, postdate, objConfig, lstProperty, strType) : URLUtils._downloadUrl(strUrl, objConfig, lstProperty, strType);
        }
        catch (FileNotFoundException ex) {
            arrReturn = null;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return arrReturn;
    }

    public static InputStream getStream(String strUrl, ConfigParameter objConfig) throws MalformedURLException, FileNotFoundException, IOException {
        Proxy proxy = null;
        if (objConfig.getProxy() != null && !objConfig.getProxy().equals("")) {
            proxy = objConfig.getProxyPort() != null && !objConfig.getProxyPort().equals("") ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(objConfig.getProxy(), Integer.parseInt(objConfig.getProxyPort()))) : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(objConfig.getProxy(), 8080));
        }
        InputStream objIn = null;
        URL objDownload = new URL(strUrl);
        if (strUrl.toLowerCase().startsWith("file")) {
            objIn = new FileInputStream(objDownload.getFile());
        } else {
            URLConnection objConn = null;
            objConn = proxy == null ? objDownload.openConnection() : objDownload.openConnection(proxy);
            objIn = objConn.getInputStream();
        }
        return objIn;
    }

    static byte[] _downloadUrl(String strUrl, ConfigParameter objConfig, HashMap<String, String> lstProperty, String strType) throws MalformedURLException, IOException {
        byte[] arrReturn = null;
        Proxy proxy = null;
        if (objConfig.getProxy() != null && !objConfig.getProxy().equals("")) {
            proxy = objConfig.getProxyPort() != null && !objConfig.getProxyPort().equals("") ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(objConfig.getProxy(), Integer.parseInt(objConfig.getProxyPort()))) : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(objConfig.getProxy(), 8080));
        }
        InputStream objIn = null;
        URL objDownload = new URL(strUrl);
        logger.info("host:" + objDownload.getHost());
        logger.info("port:" + objDownload.getPort());
        String fileUrl = URLDecoder.decode(objDownload.getFile(), "UTF-8");
        if (strUrl.toLowerCase().startsWith("file")) {
            throw new IOException("Protocollo non supportato");
        }
        URLConnection objConn = null;
        objConn = proxy == null ? objDownload.openConnection() : objDownload.openConnection(proxy);
        for (String strKey : lstProperty.keySet()) {
            objConn.setRequestProperty(strKey, lstProperty.get(strKey));
        }
        objIn = objConn.getInputStream();
        if (objIn != null) {
            byte[] buffer = new byte[512];
            int letti = objIn.read(buffer);
            ByteArrayOutputStream objOut = new ByteArrayOutputStream();
            while (letti != -1) {
                objOut.write(buffer, 0, letti);
                letti = objIn.read(buffer);
            }
            objIn.close();
            arrReturn = objOut.toByteArray();
        }
        return arrReturn;
    }

    static byte[] downloadOverHTTP(String strUrl, byte[] postdate, ConfigParameter objConfig, HashMap<String, String> lstProperty, String strType) throws MalformedURLException, IOException {
        InputStream objIn;
        byte[] arrReturn = null;
        Proxy proxy = null;
        if (objConfig.getProxy() != null && !objConfig.getProxy().equals("")) {
            proxy = objConfig.getProxyPort() != null && !objConfig.getProxyPort().equals("") ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(objConfig.getProxy(), Integer.parseInt(objConfig.getProxyPort()))) : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(objConfig.getProxy(), 8080));
        }
        URL objDownload = new URL(strUrl);
        URLConnection objConn = null;
        objConn = proxy == null ? objDownload.openConnection() : objDownload.openConnection(proxy);
        HttpURLConnection httpConn = (HttpURLConnection)objConn;
        int connectionTimeOut = 4000;
        int readTimeOut = 3000;
        if (objConfig.getConnectionTimeOut() != null && objConfig.getReadTimeOut() != null) {
            int val2;
            try {
                val2 = Integer.parseInt(objConfig.getConnectionTimeOut());
                if (val2 >= 3000) {
                    connectionTimeOut = val2;
                }
            }
            catch (Exception val2) {
                // empty catch block
            }
            try {
                val2 = Integer.parseInt(objConfig.getReadTimeOut());
                if (val2 >= 2000) {
                    readTimeOut = val2;
                } else if (val2 == 0) {
                    readTimeOut = 0;
                }
            }
            catch (Exception val3) {
                // empty catch block
            }
        }
        httpConn.setConnectTimeout(connectionTimeOut);
        httpConn.setReadTimeout(readTimeOut);
        if (strType.equals("SOAP2") && httpConn instanceof HttpsURLConnection) {
            try {
                HttpsURLConnection https = (HttpsURLConnection)httpConn;
                HostnameVerifier allHostsValid = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                https.setSSLSocketFactory(scf2);
                https.setHostnameVerifier(allHostsValid);
            }
            catch (Exception ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        for (String strKey : lstProperty.keySet()) {
            httpConn.setRequestProperty(strKey, lstProperty.get(strKey));
        }
        if (postdate != null) {
            httpConn.setRequestMethod("POST");
            httpConn.setDoOutput(true);
            httpConn.setDoInput(true);
            OutputStream objStream = objConn.getOutputStream();
            objStream.write(postdate);
            objStream.close();
        }
        if ((objIn = objConn.getInputStream()) != null) {
            byte[] buffer = new byte[64000];
            int letti = objIn.read(buffer);
            ByteArrayOutputStream objOut = new ByteArrayOutputStream();
            while (letti != -1) {
                objOut.write(buffer, 0, letti);
                letti = objIn.read(buffer);
            }
            objIn.close();
            arrReturn = objOut.toByteArray();
        }
        return arrReturn;
    }

    static {
        try {
            TrustManager[] tms2 = new TrustManager[]{new NullTrustManager()};
            sc2 = System.getProperty("java.vm.vendor").contains("IBM") ? SSLContext.getInstance("TLSv1") : SSLContext.getInstance("SSL");
            sc2.init(null, tms2, null);
            scf2 = sc2.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

