/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.outputs;

import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.util.TmpFileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class TempFileOutputHandler
extends OutputHandler {
    protected File file = null;
    protected boolean deleteOnClose = true;

    public TempFileOutputHandler() throws IOException {
        this("handler", ".tmp");
    }

    public TempFileOutputHandler(String string, String string2) throws IOException {
        this.file = TmpFileUtils.createTempFile(string, string2);
        this.a();
    }

    public TempFileOutputHandler(File file) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("Please specify a non-null file!");
        }
        this.file = file;
        this.a();
    }

    private void a() throws FileNotFoundException, IOException {
        boolean bl;
        File file = new File(this.file.getAbsolutePath());
        if (!(file = file.getParentFile()).exists() && !(bl = file.mkdirs())) {
            throw new IOException("Unable to create the necessary directory structure for file " + this.file.getAbsolutePath() + ".");
        }
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException("Parent of " + this.file.getAbsolutePath() + " exists but it is not a folder.");
        }
        this.outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
        this.initDataHandler(DataHandler.DATA_TYPE.FILE, this.file.getName(), null);
    }

    public void setDeleteOnClose(boolean bl) throws IOException {
        this.deleteOnClose = bl;
    }

    @Override
    public void close() throws IOException {
        block4: {
            if (!this.closed) {
                try {
                    super.close();
                    if (!this.deleteOnClose) break block4;
                    this.file.delete();
                }
                catch (Throwable throwable) {
                    if (this.deleteOnClose) {
                        this.file.delete();
                    }
                    throw throwable;
                }
                return;
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getFullPath() {
        return this.file.getAbsolutePath();
    }
}

