/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.validation.utils;

import esecurity.crypto.gui.facade.StatusLevel;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.validator.bean.ValidatedSigner;

public class SignerUtils {
    private static final I18N a = I18N.getInstance((String)"esecurity/crypto/gui/validation/i18n/i18n");

    public static StatusLevel getSignerLevel(ValidatedSigner validatedSigner) {
        StatusLevel statusLevel = StatusLevel.NONE;
        if (validatedSigner != null) {
            statusLevel = validatedSigner.isValid() ? (validatedSigner.hasBeanWarnings() ? StatusLevel.WARNING : StatusLevel.SUCCESS) : StatusLevel.ERROR;
        }
        return statusLevel;
    }

    public static String getSignerDescription(ValidatedSigner object, boolean bl) {
        String string = "ROOT";
        if (object != null) {
            String string2 = ("TST".equals(object.getFormat().name()) ? a.get("validation_form__signers__row_mark_info", new Object[0]) : a.get("validation_form__signers__row_sign_info", new Object[0])) + " (" + object.getFormat().name() + (bl ? " " + a.get("validated_signer_model_countersignature", new Object[0]) + " " : ") ");
            if ((object = object.getSignerName()) != null && ((String)object).equals("NO_CERT_FOUND_INSIDE_SIGNATURE")) {
                object = a.get("validation_form__signers__no_cert", new Object[0]);
            }
            string = string2 + (String)object;
        }
        return string;
    }
}

