/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.arubasign.tabview;

import esecurity.crypto.gui.utils.CGController;
import esecurity.desktop.BaseController;
import esecurity.desktop.dom.Button;
import esecurity.desktop.dom.DivContainer;
import esecurity.desktop.swt.DragAndDropInnerArea;
import it.arubapec.arubasign.gui.DropdownEntry;
import java.util.List;

public class Tab {
    private final String name;
    private final CGController controller;
    private DivContainer content;
    private Button button;
    private DragAndDropInnerArea dropInnerArea;
    private boolean active = false;

    public void setDivContainer(DivContainer content) {
        this.content = content;
    }

    public void setTabButton(Button button) {
        this.button = button;
    }

    public void setTabButtonDisplayedName(String name) {
        this.button.setInnerHTML(name);
    }

    public Tab(String name, CGController controller) {
        this.name = name;
        this.controller = controller;
    }

    public void setActive(boolean visible, List<DropdownEntry> dropdownToHide) {
        this.content.setVisible(visible);
        if (visible) {
            this.button.addClass("active");
            this.active = true;
            this.controller.refresh();
        } else {
            this.button.removeClass("active");
            this.active = false;
        }
        if (dropdownToHide != null && !dropdownToHide.isEmpty()) {
            for (DropdownEntry d2 : dropdownToHide) {
                d2.hideMenu();
            }
        }
    }

    public void setVisible(boolean visible) {
        this.content.setVisible(visible);
        if (!visible) {
            this.button.removeClass("active");
            this.active = false;
        }
        this.button.setVisible(visible);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isVisible() {
        return this.button.isDisplayed();
    }

    public String getName() {
        return this.name;
    }

    public DivContainer getContent() {
        return this.content;
    }

    public Button getButton() {
        return this.button;
    }

    public BaseController getController() {
        return this.controller;
    }

    public DragAndDropInnerArea getDragAndDropInnerArea() {
        return this.dropInnerArea;
    }

    public void setDragAndDropInnerArea(DragAndDropInnerArea dropInnerArea) {
        this.dropInnerArea = dropInnerArea;
    }
}

