/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.xades;

import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.xades.bean.XadesSignatureReference;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import esecurity.validator.xades.bean.XadesSigningCertificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.util.RFC4519Utils;
import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.util.encoders.Base64;

public class XadesStepSignatureReferenceCheck
extends MultipleValidationSubStepImpl {
    public XadesStepSignatureReferenceCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        linkedList = new LinkedList();
        if (validationContextParameters != null && validationContextParameters.getSignature() != null && validationContextParameters.getSignature().getSignerInfoData() != null) {
            XadesSignerInfoData xadesSignerInfoData = (XadesSignerInfoData)validationContextParameters.getSignature().getSignerInfoData();
            if (xadesSignerInfoData == null || xadesSignerInfoData.getReferences() == null || xadesSignerInfoData.getReferences().size() <= 0) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0020_NO_REFERENCES_FOUND, new Object[]{((Object)((Object)this)).getClass().getName()}));
            } else {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!xadesSignerInfoData.hasSignedProperties()) {
                    bl2 = true;
                }
                for (XadesSignatureReference xadesSignatureReference : xadesSignerInfoData.getReferences()) {
                    if (xadesSignatureReference.getType() != null && xadesSignatureReference.getType().equals("http://uri.etsi.org/01903#SignedProperties") && xadesSignatureReference.getURI() != null && xadesSignerInfoData.getSignedPropsId() != null && xadesSignatureReference.getURI().equals("#" + xadesSignerInfoData.getSignedPropsId())) {
                        bl2 = true;
                        continue;
                    }
                    if (xadesSignerInfoData.getKeyInfoId() == null || xadesSignatureReference.getURI() == null || !xadesSignatureReference.getURI().equals("#" + xadesSignerInfoData.getKeyInfoId())) continue;
                    bl = true;
                }
                if (xadesSignerInfoData.getSigningCertificates() != null && xadesSignerInfoData.getSigningCertificates().size() > 0) {
                    boolean bl4 = true;
                    boolean bl5 = true;
                    for (XadesSigningCertificate xadesSigningCertificate : xadesSignerInfoData.getSigningCertificates()) {
                        boolean bl6;
                        block28: {
                            bl6 = false;
                            if (validationContextParameters.getSignerCertificate() != null) {
                                ValidatedCertificate validatedCertificate = validationContextParameters.getSignerCertificate();
                                try {
                                    switch (xadesSigningCertificate.getVersion()) {
                                        case 1: {
                                            Object object;
                                            if (xadesSigningCertificate.getIssuerName() == null) {
                                                bl5 = false;
                                                break;
                                            }
                                            if (RFC4519Utils.compareDN((String)validatedCertificate.getCertIssuer(), (String)xadesSigningCertificate.getIssuerName()) && validatedCertificate.getCert().getSerialNumber().equals(xadesSigningCertificate.getSerialNumber())) {
                                                object = MessageDigest.getInstance(DigestAlgorithm.valueFromXadesId((String)xadesSigningCertificate.getDigestMethod()).getId(), ProvUtils.bcProvider);
                                                object = ((MessageDigest)object).digest(Base64.decode((String)validatedCertificate.getCert().getEncoded()));
                                                if (xadesSigningCertificate.getDigestValue().equals(new String(Base64.encode((byte[])object)))) {
                                                    bl3 = true;
                                                    bl6 = true;
                                                }
                                            }
                                            while (validatedCertificate.getIssuer() != null && !bl6) {
                                                if (!RFC4519Utils.compareDN((String)(validatedCertificate = validatedCertificate.getIssuer()).getCertIssuer(), (String)xadesSigningCertificate.getIssuerName()) || !validatedCertificate.getCert().getSerialNumber().equals(xadesSigningCertificate.getSerialNumber())) continue;
                                                try {
                                                    object = MessageDigest.getInstance(DigestAlgorithm.valueFromXadesId((String)xadesSigningCertificate.getDigestMethod()).getId(), ProvUtils.bcProvider);
                                                    object = ((MessageDigest)object).digest(Base64.decode((String)validatedCertificate.getCert().getEncoded()));
                                                    if (!xadesSigningCertificate.getDigestValue().equals(new String(Base64.encode((byte[])object)))) continue;
                                                    bl3 = true;
                                                    bl6 = true;
                                                }
                                                catch (Throwable throwable) {}
                                            }
                                            break block28;
                                        }
                                        case 2: {
                                            Object object = MessageDigest.getInstance(DigestAlgorithm.valueFromXadesId((String)xadesSigningCertificate.getDigestMethod()).getId(), ProvUtils.bcProvider);
                                            object = ((MessageDigest)object).digest(validatedCertificate.getCert().getInternalCert().getEncoded());
                                            if (xadesSigningCertificate.getDigestValue().equals(Base64.toBase64String((byte[])object))) {
                                                bl3 = true;
                                                bl6 = true;
                                            }
                                            break block28;
                                        }
                                        default: {
                                            bl5 = false;
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        if (bl6) continue;
                        bl4 = false;
                        break;
                    }
                    if (!bl4) {
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0023_XADES_ALL_SIGNING_CERTS_NOT_MATCH, new Object[]{((Object)((Object)this)).getClass().getName()}));
                    }
                    if (!bl5) {
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0015_NO_ISSUER_NAME, new Object[]{((Object)((Object)this)).getClass().getName()}));
                    }
                }
                if (xadesSignerInfoData.hasKeyInfo() && !bl && !bl3) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0021_NO_REFERENCE_FOR_KEYINFO_FOUND, new Object[]{((Object)((Object)this)).getClass().getName()}));
                } else if (!xadesSignerInfoData.hasKeyInfo() && !bl3) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0021_NO_REFERENCE_FOR_KEYINFO_FOUND, new Object[]{((Object)((Object)this)).getClass().getName()}));
                }
                if (!bl2) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0022_NO_REFERENCE_FOR_SIGNEDPROPS_FOUND, new Object[]{((Object)((Object)this)).getClass().getName()}));
                }
            }
        }
        return linkedList;
    }
}

