/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11.nat;

import com.sun.jna.ptr.LongByReference;
import it.actalis.pkcs11.CapiPKCS11Exception;
import it.actalis.pkcs11.PKCS11Object;
import it.actalis.pkcs11.PKCS11Session;
import it.actalis.pkcs11.nat.NativePKCS11Session;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class NativePKCS11Object
extends PKCS11Object {
    protected NativePKCS11Session session;
    protected long objectID;

    protected NativePKCS11Object(NativePKCS11Session nativePKCS11Session, long l) {
        this.session = nativePKCS11Session;
        this.objectID = l;
    }

    @Override
    public PKCS11Session getSession() {
        return this.session;
    }

    @Override
    public PKCS11Object copy(long[] lArray, Object[] objectArray) throws CapiPKCS11Exception {
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                cK_ATTRIBUTEArray[i] = new CK_ATTRIBUTE(lArray[i], objectArray[i]);
            }
            long l = this.session.a().a().C_CopyObject(this.session.sessionID, this.objectID, cK_ATTRIBUTEArray);
            return new NativePKCS11Object(this.session, l);
        }
        catch (PKCS11Exception pKCS11Exception) {
            PKCS11Exception pKCS11Exception2 = pKCS11Exception;
            throw new CapiPKCS11Exception(pKCS11Exception.getMessage(), pKCS11Exception2, pKCS11Exception2.getErrorCode());
        }
        catch (Exception exception) {
            throw new CapiPKCS11Exception(exception.getMessage(), exception);
        }
    }

    @Override
    public void destroy() throws CapiPKCS11Exception {
        try {
            this.session.a().a().C_DestroyObject(this.session.sessionID, this.objectID);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            PKCS11Exception pKCS11Exception2 = pKCS11Exception;
            throw new CapiPKCS11Exception(pKCS11Exception.getMessage(), pKCS11Exception2, pKCS11Exception2.getErrorCode());
        }
        catch (Exception exception) {
            throw new CapiPKCS11Exception(exception.getMessage(), exception);
        }
    }

    @Override
    public long size() throws CapiPKCS11Exception {
        LongByReference longByReference = new LongByReference();
        long l = this.session.a().getExtraFunctionPointer().a(this.session.sessionID, this.objectID, longByReference);
        if (l != 0L) {
            throw new CapiPKCS11Exception(l);
        }
        return longByReference.getValue();
    }

    @Override
    public Object getAttributeValue(long l) throws CapiPKCS11Exception {
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = cK_ATTRIBUTEArray;
            cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE();
            cK_ATTRIBUTEArray2[0].type = l;
            this.session.a().a().C_GetAttributeValue(this.session.sessionID, this.objectID, cK_ATTRIBUTEArray2);
            return cK_ATTRIBUTEArray2[0].pValue;
        }
        catch (PKCS11Exception pKCS11Exception) {
            PKCS11Exception pKCS11Exception2 = pKCS11Exception;
            throw new CapiPKCS11Exception(pKCS11Exception.getMessage(), pKCS11Exception2, pKCS11Exception2.getErrorCode());
        }
        catch (Exception exception) {
            throw new CapiPKCS11Exception(exception.getMessage(), exception);
        }
    }

    @Override
    public void setAttributeValues(long[] lArray, Object[] objectArray) throws CapiPKCS11Exception {
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                cK_ATTRIBUTEArray[i] = new CK_ATTRIBUTE(lArray[i], objectArray[i]);
            }
            this.session.a().a().C_SetAttributeValue(this.session.sessionID, this.objectID, cK_ATTRIBUTEArray);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            PKCS11Exception pKCS11Exception2 = pKCS11Exception;
            throw new CapiPKCS11Exception(pKCS11Exception.getMessage(), pKCS11Exception2, pKCS11Exception2.getErrorCode());
        }
        catch (Exception exception) {
            throw new CapiPKCS11Exception(exception.getMessage(), exception);
        }
    }

    @Override
    public void setAttributeValue(long l, Object object) throws CapiPKCS11Exception {
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = cK_ATTRIBUTEArray;
            cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE(l, object);
            this.session.a().a().C_SetAttributeValue(this.session.sessionID, this.objectID, cK_ATTRIBUTEArray2);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            PKCS11Exception pKCS11Exception2 = pKCS11Exception;
            throw new CapiPKCS11Exception(pKCS11Exception.getMessage(), pKCS11Exception2, pKCS11Exception2.getErrorCode());
        }
        catch (Exception exception) {
            throw new CapiPKCS11Exception(exception.getMessage(), exception);
        }
    }
}

