/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


/**
 * Initialize  JQueryUI's tooltips
 * 
 * @returns {undefined}
 */
function ldap_loadTooltip() {
    $(document).tooltip({
        content: function () {
            var element = $(this);
            if (element.is("[title]")) {
                return element.attr("title");
            }
        },

        open: function (event, ui) {
            $(".ui-tooltip").addClass("ldap-custom-tooltip");
        }

    });
}

function toggleShowHideIcon(iconId, inputId) {
    try {
        var input = document.getElementById(inputId);
        if (input.getAttribute("type") == "password") {
            input.setAttribute("type", "text");
            removeClass(iconId, "cg-show-icon");
            addClass(iconId, "cg-hide-icon");
        } else {
            input.setAttribute("type", "password");
            removeClass(iconId, "cg-hide-icon");
            addClass(iconId, "cg-show-icon");
        }
    } catch (exception) {
        error(exception.stack);
    }
}

function refreshLdapTextInput(inputId, errorLabelId) {
    if (document.getElementById(inputId).value !== null && document.getElementById(inputId).value !== "") {
        removeClass(inputId, "cg-textInput-Error");
        document.getElementById(errorLabelId).style.display = "none";
    }
}

function updateLdapSearchButton(emailInputId, fiscalCodeInputId, searchButtonId) {
    var emailInputEl = document.getElementById(emailInputId);
    var fiscalCodeInputEl = document.getElementById(fiscalCodeInputId);
    if ((emailInputEl.value === null || emailInputEl.value === "") && (fiscalCodeInputEl.value === null || fiscalCodeInputEl.value === "")) {
        document.getElementById(searchButtonId).setAttribute('disabled', 'disabled');
        addClass(searchButtonId, 'disabled');
    } else {
        document.getElementById(searchButtonId).removeAttribute('disabled');
        removeClass(searchButtonId, 'disabled');
    }
}