/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.ldap;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.crypto.gui.ldap.LdapEndPoint;
import esecurity.crypto.gui.properties.AppProperties;
import esecurity.crypto.gui.properties.ClientProperties;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LdapEndPointLoader {
    private static final EllipsLogger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final File LDAP_DATA_FILE = new File(ClientProperties.getInstance().get(AppProperties.WORK_FOLDER, "") + File.separator + "ldap.data");
    private static final File DEFAULT_LDAP_DATA_FILE = new File(ClientProperties.getInstance().get(AppProperties.BASE_FOLDER, "") + File.separator + "ldap_def.data");
    private static final ObjectMapper om = new ObjectMapper();
    private static List<LdapEndPoint> ldapDataLoader;

    public static void load() {
        ldapDataLoader = LdapEndPointLoader.loadFromFile();
    }

    public static List<LdapEndPoint> getEndPoints() {
        if (ldapDataLoader == null) {
            LdapEndPointLoader.load();
        }
        return ldapDataLoader;
    }

    public static void addEndPoint(LdapEndPoint ldapEndPoint) {
        LdapEndPointLoader.getEndPoints().add(ldapEndPoint);
    }

    public static void removeEndPoint(LdapEndPoint ldapEndPoint) {
        if (ldapEndPoint == null) {
            return;
        }
        LdapEndPointLoader.getEndPoints().remove(ldapEndPoint);
    }

    public static void removeEndPoint(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        List<LdapEndPoint> list = LdapEndPointLoader.getEndPoints();
        boolean bl = false;
        for (int i = 0; !bl && i < list.size(); ++i) {
            if (!string.equals(list.get(i).getName())) continue;
            list.remove(i);
            bl = true;
        }
    }

    public static void saveToFile() {
        try {
            om.writeValue(LDAP_DATA_FILE, LdapEndPointLoader.getEndPoints());
            return;
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage(), (Throwable)iOException);
            return;
        }
    }

    private static List<LdapEndPoint> loadFromFile() {
        HashMap<String, LdapEndPoint> hashMap = new HashMap<String, LdapEndPoint>();
        if (DEFAULT_LDAP_DATA_FILE.exists()) {
            LdapEndPointLoader.fromFile(DEFAULT_LDAP_DATA_FILE, hashMap);
        }
        if (LDAP_DATA_FILE.exists()) {
            LdapEndPointLoader.fromFile(LDAP_DATA_FILE, hashMap);
        }
        return new ArrayList<LdapEndPoint>(hashMap.values());
    }

    private static void fromFile(File iterator, Map<String, LdapEndPoint> map) {
        try {
            iterator = (List)om.readValue((File)((Object)iterator), (TypeReference)new TypeReference<List<LdapEndPoint>>(){});
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                LdapEndPoint ldapEndPoint = (LdapEndPoint)iterator.next();
                map.put(ldapEndPoint.getName(), ldapEndPoint);
            }
            return;
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage(), (Throwable)iOException);
            return;
        }
    }

    static {
        om.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
    }
}

