/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider.manager;

import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.TokenManager;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.capi.provider.ExternalServerToken;
import it.actalis.ellips.capi.provider.SoftToken;
import it.actalis.ellips.capi.provider.Token;
import it.actalis.vol.utils.Constants;
import java.security.PrivateKey;
import java.security.Provider;
import org.slf4j.Logger;

public class DefaultTokenManagerImpl
implements TokenManager {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    @Override
    public Provider retrieveProviderForKey(PrivateKey privateKey) {
        if (privateKey instanceof Actalis_PrivateKey) {
            return ActalisSingleton.getActalisProvider();
        }
        return null;
    }

    @Override
    public TokenSpi retrieveTokenByAlias(String string) {
        try {
            return Token.getTokenSpi(string);
        }
        catch (CapiException capiException) {
            a.info("Nessun Token Trovato per questo alias.");
            return null;
        }
    }

    @Override
    public TokenSpi initToken(String string) {
        TokenSpi tokenSpi = null;
        if (string.equals("SoftToken") || string.equals("NetworkToken")) {
            a.debug("trying to load Token Software...");
            tokenSpi = new SoftToken();
        } else if (string.equals("ExternalServerToken")) {
            a.debug("trying to load Token External...");
            tokenSpi = new ExternalServerToken();
        }
        return tokenSpi;
    }
}

