var sign_scrollVisible = false;

var SIGN_MIN_CELL_WIDTH = 260;

var sign_window = {
    width: 0,
    heigth: 0
};

/**
 * Richiamato ogni volta che la finestra di marca viene ridimensionata
 * 
 * @returns {undefined}
 */
function timestamp_resize() {
    try {
        var headWidth = $("#timestamp_fileTableHead_container").width();
        var headCellDocumentsWidth = $("#timestamp_fileTableHeadCellDocuments").width();
        var headCellOutputWidth = $("#timestamp_fileTableHeadCellOutput").width();

        if (sign_window.width > 0) {
            if (headCellDocumentsWidth <= 0) {
                headCellDocumentsWidth = headWidth / 2;
            }
            var dx = window.innerWidth - sign_window.width;
            sign_window.width = window.innerWidth;
            var newHeadCellDocumentsWidth = headCellDocumentsWidth + (dx / 2);
            if (headCellOutputWidth < SIGN_MIN_CELL_WIDTH) {
                newHeadCellDocumentsWidth = headCellDocumentsWidth + dx;
            }
            if (newHeadCellDocumentsWidth < SIGN_MIN_CELL_WIDTH) {
                newHeadCellDocumentsWidth = SIGN_MIN_CELL_WIDTH;
            }
            headCellDocumentsWidth = newHeadCellDocumentsWidth;
            $("#timestamp_fileTableHeadCellDocuments").width(newHeadCellDocumentsWidth);

            if (headWidth + 20 < headCellDocumentsWidth + headCellOutputWidth) {
                headCellDocumentsWidth = headWidth / 2;
                headCellOutputWidth = headCellDocumentsWidth;
                $("#timestamp_fileTableHeadCellDocuments").width(headCellDocumentsWidth);
                $("#timestamp_fileTableHeadCellOutput").width(headCellOutputWidth);
            }
        } else {
            sign_window.width = window.innerWidth;
        }

        $("#timestamp_fileTableHeadCellDocuments").resizable("option", "maxWidth", headWidth - 300);

        $(".timestamp_filesToSignTable_fileToSignName").width(headCellDocumentsWidth - 200);

        $("#timestamp_textContainer").width(window.innerWidth - 450);

        timestamp_refreshCellWidth();
    } catch (exception) {
        error(exception.stack);
    }
}

/**
 * Richiamato ogni volta che la lista dei file viene modificata
 * 
 * @returns {undefined}
 */
function timestamp_refreshCellWidth() {
    try {
        var headWidth = $("#timestamp_fileTableHead_container").width();

        var leftHeadCellWidth = $("#timestamp_fileTableHeadCellDocuments").width();

        $("#timestamp_fileToSignColumn").width(leftHeadCellWidth);
        $("#timestamp_fileTableHeadCellOutput").width(headWidth - leftHeadCellWidth);
        $("#timestamp_signedFileColumn").width(headWidth - leftHeadCellWidth);

        var rect = $("#timestamp_fileTableHeadCellDocuments")[0].getBoundingClientRect();
        $(".timestamp_filesToSignTable_fileToSignName").width(rect.width - 200);
    } catch (exception) {
        error(exception.stack);
    }
}

function timestamp_signatureOutcomeAlignColumn() {
    try {
        var headWidth = $("#timestamp_SignatureOutcomePanel_errorDocumentsTableArea_tableHead").width();
        $("#timestamp_SignatureOutcomePanel_errorDocumentsTableArea_tableBody .cg-tableColumn").width((headWidth / 2) + 1);
    } catch (exception) {
        error(exception.stack);
    }
}

/**
 * Initialize  JQueryUI's tooltips
 * 
 * @returns {undefined}
 */
function timestamp_loadTooltip() {
    $(document).tooltip({
        content: function () {
            var element = $(this);
            if (element.is("[title]")) {
                return element.attr("title");
            }
        },
        open: function (event, ui) {
            $(".ui-tooltip").addClass("cg-custom-tooltip");
        }
    });
}

function timestamp_loadResizable() {
    $(".fileTableHeadCell").width("50%");
    $(".timestamp_tableColumn").width("50%");
    $("#timestamp_fileTableHeadCellDocuments").resizable({
        handles: "e",
        minWidth: 260,
        maxWidth: $("#timestamp_fileTableHead_container").width() - 300,
        resize: function (event, ui) {
            timestamp_refreshCellWidth();
        }
    });
}

function timestamp_toggleShowHideIcon(iconId, inputId) {
    try {
        var input = document.getElementById(inputId);
        if (input.getAttribute("type") == "password") {
            input.setAttribute("type", "text");
            removeClass(iconId, "cg-show-icon");
            addClass(iconId, "cg-hide-icon");
        } else {
            input.setAttribute("type", "password");
            removeClass(iconId, "cg-hide-icon");
            addClass(iconId, "cg-show-icon");
        }
    } catch (exception) {
        error(exception.stack);
    }
}

function passwordTextInputKeyUp(passwordTextInputId, markButtonId) {
    try {
        if (document.getElementById(passwordTextInputId).value != null && document.getElementById(passwordTextInputId).value != "") {
            document.getElementById(markButtonId).removeAttribute('disabled');
            removeClass(markButtonId, 'disabled');
        } else {
            document.getElementById(markButtonId).setAttribute('disabled', 'disabled');
            addClass(markButtonId, 'disabled');
        }
    } catch (exception) {
        error(exception.stack);
    }

}

var isKeyPressSupported;

function addMarkedFileNameEventListener(id) {
    if (typeof isKeyPressSupported === 'undefined' || isKeyPressSupported === null) {
        // L'evento keypress è deprecato https://developer.mozilla.org/en-US/docs/Web/API/Element/keypress_event
        isKeyPressSupported = checkIfKeyPressIsSupportedMark();
    }
    if (isKeyPressSupported) {
        document.getElementById(id).addEventListener('keypress', markedFileNameInputKeyPress);
    } else {
        document.getElementById(id).addEventListener('keydown', markedFileNameInputKeyPress);
    }
}

function checkIfKeyPressIsSupportedMark() {
    var el = document.createElement('input');
    eventName = 'onkeypress';
    var isSupported = (eventName in el);
    if (!isSupported) {
        el.setAttribute(eventName, 'return;');
        isSupported = typeof el[eventName] == 'function';
    }
    el = null;
    return isSupported;
}

/**
 * 
 * ------------------------------ START FilesToSignTable ------------------------------
 * 
 */

var forbiddenKey = ["\\", "/", ":", "*", "?", "\"", "<", ">", "|"];

/**
 * Previene l'inserimento di caratteri non supportati per i nomi dei 
 * @param {type} evt
 * @returns {undefined}
 */
function markedFileNameInputKeyPress(evt) {
    var key = evt.key;
    // Workaround per Xulrunner
    if (key == null || key == "" || key == "MozPrintableKey") {
        key = String.fromCharCode(evt.which);
    }
    if ($.inArray(key, forbiddenKey) >= 0) {
        evt.preventDefault();
        $controller$.showForbiddenCharMessageMark();
    }
}

/**
 * Aggiorna il nome del file firmato
 * @param {type} evt
 * @returns {undefined}
 */
function markedFileNameInputKeyUp(evt) {
    $controller$.updateFileToMarkName(evt.target.id, document.getElementById(evt.target.id).value);
}