/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import com.amazonaws.util.Base64;
import esecurity.statistics.util.StatisticKeyEnum;
import esecurity.statistics.util.StatisticsInfoUtils;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.PureSWKey;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.util.DigestFactory;
import org.slf4j.Logger;

public class ActalisECDSA
extends SignatureSpi {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private Actalis_PrivateKey b;
    protected Digest digest;

    ActalisECDSA(Digest digest) {
        this.digest = digest;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof Actalis_PrivateKey) {
            this.b = (Actalis_PrivateKey)privateKey;
        } else if (privateKey instanceof ECPrivateKey) {
            this.b = new PureSWKey("SW", null, privateKey);
        } else {
            throw new InvalidKeyException("Key not valid");
        }
        this.digest.reset();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.digest.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.digest.update(byArray, n, n2);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        byte[] byArray2 = null;
        if (this.b instanceof PureSWKey) {
            try {
                Signature signature = Signature.getInstance("NONEwithECDSA", ProvUtils.bcProvider);
                signature.initSign(((PureSWKey)this.b).getPrivateKeySpi());
                signature.update(byArray);
                byArray2 = signature.sign();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                a.error("Signature error", (Throwable)noSuchAlgorithmException);
            }
            catch (InvalidKeyException invalidKeyException) {
                a.error("Signature error", (Throwable)invalidKeyException);
            }
        } else {
            try {
                Object object = this.b;
                byArray2 = ((Actalis_PrivateKey)object).getCryptoDev().doSign(byArray, ((Actalis_PrivateKey)object).getAlias(), 0);
                if (byArray2 != null) {
                    if (byArray2.length % 2 != 0) {
                        a.info("Firma di dimensione dispari {}", (Object)Base64.encodeAsString((byte[])byArray2));
                    }
                    int n = byArray2.length / 2;
                    object = new ByteArrayOutputStream();
                    DERSequenceGenerator dERSequenceGenerator = new DERSequenceGenerator((OutputStream)object);
                    dERSequenceGenerator.addObject((ASN1Encodable)new ASN1Integer(new BigInteger(1, Arrays.copyOfRange(byArray2, 0, n))));
                    dERSequenceGenerator.addObject((ASN1Encodable)new ASN1Integer(new BigInteger(1, Arrays.copyOfRange(byArray2, n, byArray2.length))));
                    dERSequenceGenerator.close();
                    byArray2 = ((ByteArrayOutputStream)object).toByteArray();
                }
            }
            catch (CapiException capiException) {
                a.debug(capiException.getMessage(), (Throwable)capiException);
                throw new CapiError(capiException);
            }
            catch (IOException iOException) {
                a.debug(iOException.getMessage(), (Throwable)iOException);
                byArray2 = null;
            }
            finally {
                StatisticsInfoUtils.end(StatisticKeyEnum.SIGN_TIME);
            }
            System.out.println(Base64.encodeAsString((byte[])byArray2));
        }
        if (byArray2 == null) {
            throw new CapiError("Invalid signature", 3003);
        }
        return byArray2;
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class ecDSA
    extends ActalisECDSA {
        public ecDSA() {
            super(DigestFactory.createSHA1());
        }
    }

    public static class ecDSAnone
    extends ActalisECDSA {
        public ecDSAnone() {
            super((Digest)new NullDigest());
        }
    }

    public static class ecDSA224
    extends ActalisECDSA {
        public ecDSA224() {
            super(DigestFactory.createSHA224());
        }
    }

    public static class ecDSA256
    extends ActalisECDSA {
        public ecDSA256() {
            super(DigestFactory.createSHA256());
        }
    }

    public static class ecDSA384
    extends ActalisECDSA {
        public ecDSA384() {
            super(DigestFactory.createSHA384());
        }
    }

    public static class ecDSA512
    extends ActalisECDSA {
        public ecDSA512() {
            super(DigestFactory.createSHA512());
        }
    }

    public static class ecDSASha3_224
    extends ActalisECDSA {
        public ecDSASha3_224() {
            super(DigestFactory.createSHA3_224());
        }
    }

    public static class ecDSASha3_256
    extends ActalisECDSA {
        public ecDSASha3_256() {
            super(DigestFactory.createSHA3_256());
        }
    }

    public static class ecDSASha3_384
    extends ActalisECDSA {
        public ecDSASha3_384() {
            super(DigestFactory.createSHA3_384());
        }
    }

    public static class ecDSASha3_512
    extends ActalisECDSA {
        public ecDSASha3_512() {
            super(DigestFactory.createSHA3_512());
        }
    }

    public static class ecNR
    extends ActalisECDSA {
        public ecNR() {
            super(DigestFactory.createSHA1());
        }
    }

    public static class ecNR224
    extends ActalisECDSA {
        public ecNR224() {
            super(DigestFactory.createSHA224());
        }
    }

    public static class ecNR256
    extends ActalisECDSA {
        public ecNR256() {
            super(DigestFactory.createSHA256());
        }
    }

    public static class ecNR384
    extends ActalisECDSA {
        public ecNR384() {
            super(DigestFactory.createSHA384());
        }
    }

    public static class ecNR512
    extends ActalisECDSA {
        public ecNR512() {
            super(DigestFactory.createSHA512());
        }
    }

    public static class ecCVCDSA
    extends ActalisECDSA {
        public ecCVCDSA() {
            super(DigestFactory.createSHA1());
        }
    }

    public static class ecCVCDSA224
    extends ActalisECDSA {
        public ecCVCDSA224() {
            super(DigestFactory.createSHA224());
        }
    }

    public static class ecCVCDSA256
    extends ActalisECDSA {
        public ecCVCDSA256() {
            super(DigestFactory.createSHA256());
        }
    }

    public static class ecCVCDSA384
    extends ActalisECDSA {
        public ecCVCDSA384() {
            super(DigestFactory.createSHA384());
        }
    }

    public static class ecCVCDSA512
    extends ActalisECDSA {
        public ecCVCDSA512() {
            super(DigestFactory.createSHA512());
        }
    }
}

