/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.builders;

import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.builders.AmazonS3DataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.ArubaCloudDataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.CloudChooserDataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.GenericDataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.GenericS3DataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.S3ChooserDataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.URLDataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.inputs.AmazonS3InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.ArubaCloudS3InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.ByteInputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.FileInputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.S3InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.StreamInputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.TempFileInputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.URLInputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.AmazonS3OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.ArubaCloudS3OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.ByteOutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.FileOutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.S3OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.StreamOutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.TempFileOutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.URLOutputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;

public abstract class DataHandlerBuilder {
    protected String name = null;
    protected Long totalSize = null;
    protected boolean replace = false;
    protected DataHandler.DATA_TYPE type = null;
    protected byte[] byteData = null;
    protected File fileData = null;
    protected String prefix = null;
    protected String suffix = null;
    protected InputStream streamInputData = null;
    protected OutputStream streamOutputData = null;
    protected URL urlEndpoint = null;
    protected URLCredentials urlCreds = null;
    protected NetworkConfig urlNetConf = null;
    protected DataHandler.CLOUD_TYPE cloudType = null;
    protected DataHandler.S3_TYPE s3Type = null;
    protected AmazonS3ClientBuilder genericS3ClientBuilder = null;
    protected String s3Bucket = null;
    protected String s3Filepath = null;
    protected String as3UserId = null;
    protected String as3SecretKey = null;
    protected String arubaCloudUserId = null;
    protected String arubaCloudSecretKey = null;
    protected String arubaCloudEndpoint = null;

    protected static GenericDataHandlerBuilderFacade getNewGenericFacade() {
        return new GenericDataHandlerBuilderFacade();
    }

    protected static URLDataHandlerBuilderFacade getNewURLFacadeFrom(DataHandlerBuilder dataHandlerBuilder) {
        URLDataHandlerBuilderFacade uRLDataHandlerBuilderFacade = new URLDataHandlerBuilderFacade();
        uRLDataHandlerBuilderFacade.copyInfoFrom(dataHandlerBuilder);
        uRLDataHandlerBuilderFacade.type = DataHandler.DATA_TYPE.URL;
        return uRLDataHandlerBuilderFacade;
    }

    protected static CloudChooserDataHandlerBuilderFacade getNewCloudFacadeFrom(DataHandlerBuilder dataHandlerBuilder) {
        CloudChooserDataHandlerBuilderFacade cloudChooserDataHandlerBuilderFacade = new CloudChooserDataHandlerBuilderFacade();
        cloudChooserDataHandlerBuilderFacade.copyInfoFrom(dataHandlerBuilder);
        cloudChooserDataHandlerBuilderFacade.type = DataHandler.DATA_TYPE.CLOUD;
        return cloudChooserDataHandlerBuilderFacade;
    }

    protected static S3ChooserDataHandlerBuilderFacade getNewS3FacadeFrom(DataHandlerBuilder dataHandlerBuilder) {
        S3ChooserDataHandlerBuilderFacade s3ChooserDataHandlerBuilderFacade = new S3ChooserDataHandlerBuilderFacade();
        s3ChooserDataHandlerBuilderFacade.copyInfoFrom(dataHandlerBuilder);
        s3ChooserDataHandlerBuilderFacade.type = DataHandler.DATA_TYPE.CLOUD;
        s3ChooserDataHandlerBuilderFacade.cloudType = DataHandler.CLOUD_TYPE.S3;
        return s3ChooserDataHandlerBuilderFacade;
    }

    protected static GenericS3DataHandlerBuilderFacade getNewGenericS3FacadeFrom(DataHandlerBuilder dataHandlerBuilder) {
        GenericS3DataHandlerBuilderFacade genericS3DataHandlerBuilderFacade = new GenericS3DataHandlerBuilderFacade();
        genericS3DataHandlerBuilderFacade.copyInfoFrom(dataHandlerBuilder);
        genericS3DataHandlerBuilderFacade.type = DataHandler.DATA_TYPE.CLOUD;
        genericS3DataHandlerBuilderFacade.cloudType = DataHandler.CLOUD_TYPE.S3;
        genericS3DataHandlerBuilderFacade.s3Type = DataHandler.S3_TYPE.GENERIC;
        return genericS3DataHandlerBuilderFacade;
    }

    protected static AmazonS3DataHandlerBuilderFacade getNewAmazonS3FacadeFrom(DataHandlerBuilder dataHandlerBuilder) {
        AmazonS3DataHandlerBuilderFacade amazonS3DataHandlerBuilderFacade = new AmazonS3DataHandlerBuilderFacade();
        amazonS3DataHandlerBuilderFacade.copyInfoFrom(dataHandlerBuilder);
        amazonS3DataHandlerBuilderFacade.type = DataHandler.DATA_TYPE.CLOUD;
        amazonS3DataHandlerBuilderFacade.cloudType = DataHandler.CLOUD_TYPE.S3;
        amazonS3DataHandlerBuilderFacade.s3Type = DataHandler.S3_TYPE.AMAZON;
        return amazonS3DataHandlerBuilderFacade;
    }

    protected static ArubaCloudDataHandlerBuilderFacade getNewArubaCloudFacadeFrom(DataHandlerBuilder dataHandlerBuilder) {
        ArubaCloudDataHandlerBuilderFacade arubaCloudDataHandlerBuilderFacade = new ArubaCloudDataHandlerBuilderFacade();
        arubaCloudDataHandlerBuilderFacade.copyInfoFrom(dataHandlerBuilder);
        arubaCloudDataHandlerBuilderFacade.type = DataHandler.DATA_TYPE.CLOUD;
        arubaCloudDataHandlerBuilderFacade.cloudType = DataHandler.CLOUD_TYPE.S3;
        arubaCloudDataHandlerBuilderFacade.s3Type = DataHandler.S3_TYPE.ARUBA;
        return arubaCloudDataHandlerBuilderFacade;
    }

    public static GenericDataHandlerBuilderFacade get() {
        return DataHandlerBuilder.getNewGenericFacade();
    }

    protected DataHandlerBuilder() {
    }

    protected void copyInfoFrom(DataHandlerBuilder dataHandlerBuilder) {
        this.type = dataHandlerBuilder.type;
        this.name = dataHandlerBuilder.name;
        this.totalSize = dataHandlerBuilder.totalSize;
        this.byteData = dataHandlerBuilder.byteData;
        this.fileData = dataHandlerBuilder.fileData;
        this.streamInputData = dataHandlerBuilder.streamInputData;
        this.streamOutputData = dataHandlerBuilder.streamOutputData;
        this.urlCreds = dataHandlerBuilder.urlCreds;
        this.urlEndpoint = dataHandlerBuilder.urlEndpoint;
        this.urlNetConf = dataHandlerBuilder.urlNetConf;
        this.cloudType = dataHandlerBuilder.cloudType;
        this.s3Type = dataHandlerBuilder.s3Type;
        this.s3Bucket = dataHandlerBuilder.s3Bucket;
        this.s3Filepath = dataHandlerBuilder.s3Filepath;
        this.genericS3ClientBuilder = dataHandlerBuilder.genericS3ClientBuilder;
        this.as3UserId = dataHandlerBuilder.as3UserId;
        this.as3SecretKey = dataHandlerBuilder.as3SecretKey;
        this.arubaCloudUserId = dataHandlerBuilder.arubaCloudUserId;
        this.arubaCloudSecretKey = dataHandlerBuilder.arubaCloudSecretKey;
        this.arubaCloudEndpoint = dataHandlerBuilder.arubaCloudEndpoint;
    }

    public InputHandler buildInput() throws FileNotFoundException, IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        switch (this.type) {
            case TEMP: {
                if (this.fileData != null) {
                    return new TempFileInputHandler(this.fileData);
                }
                if (this.suffix != null || this.prefix != null) {
                    return new TempFileInputHandler(this.prefix, this.suffix);
                }
                return new TempFileInputHandler();
            }
            case BYTE: {
                return new ByteInputHandler(this.byteData, this.name);
            }
            case FILE: {
                return new FileInputHandler(this.fileData, this.name);
            }
            case STREAM: {
                return new StreamInputHandler(this.streamInputData, this.name);
            }
            case URL: {
                return new URLInputHandler(this.urlEndpoint, this.urlNetConf, this.urlCreds);
            }
            case CLOUD: {
                switch (this.cloudType) {
                    case S3: {
                        switch (this.s3Type) {
                            case GENERIC: {
                                return new S3InputHandler(this.genericS3ClientBuilder, this.s3Bucket, this.s3Filepath, this.name);
                            }
                            case AMAZON: {
                                return new AmazonS3InputHandler(this.as3UserId, this.as3SecretKey, this.s3Bucket, this.s3Filepath, this.name);
                            }
                            case ARUBA: {
                                return new ArubaCloudS3InputHandler(this.arubaCloudEndpoint, this.arubaCloudUserId, this.arubaCloudSecretKey, this.s3Bucket, this.s3Filepath, this.name);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unable to create input handler with the given data, try to add more configuration properties!");
            }
        }
        throw new UnsupportedOperationException("Unable to create input handler with the given data, try to add more configuration properties!");
    }

    public OutputHandler buildOutput() throws IOException, URISyntaxException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        switch (this.type) {
            case TEMP: {
                if (this.fileData != null) {
                    return new TempFileOutputHandler(this.fileData);
                }
                if (this.suffix != null || this.prefix != null) {
                    return new TempFileOutputHandler(this.prefix, this.suffix);
                }
                return new TempFileOutputHandler();
            }
            case BYTE: {
                return new ByteOutputHandler(this.name, this.totalSize);
            }
            case FILE: {
                return new FileOutputHandler(this.fileData, this.totalSize, this.replace);
            }
            case STREAM: {
                return new StreamOutputHandler(this.streamOutputData, this.name, this.totalSize);
            }
            case URL: {
                return new URLOutputHandler(this.urlEndpoint, this.urlNetConf, this.urlCreds, this.name, this.totalSize);
            }
            case CLOUD: {
                switch (this.cloudType) {
                    case S3: {
                        switch (this.s3Type) {
                            case GENERIC: {
                                return new S3OutputHandler(this.genericS3ClientBuilder, this.s3Bucket, this.s3Filepath, this.name, this.totalSize);
                            }
                            case AMAZON: {
                                return new AmazonS3OutputHandler(this.as3UserId, this.as3SecretKey, this.s3Bucket, this.s3Filepath, this.name, this.totalSize);
                            }
                            case ARUBA: {
                                return new ArubaCloudS3OutputHandler(this.arubaCloudEndpoint, this.arubaCloudUserId, this.arubaCloudSecretKey, this.s3Bucket, this.s3Filepath, this.name, this.totalSize);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unable to create input handler with the given data, try to add more configuration properties!");
            }
        }
        throw new UnsupportedOperationException("Unable to create input handler with the given data, try to add more configuration properties!");
    }

    public OutputHandler buildOutput(boolean bl) throws IOException, URISyntaxException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        switch (this.type) {
            case TEMP: {
                if (this.fileData != null) {
                    return new TempFileOutputHandler(this.fileData);
                }
                if (this.suffix != null || this.prefix != null) {
                    return new TempFileOutputHandler(this.prefix, this.suffix);
                }
                return new TempFileOutputHandler();
            }
            case BYTE: {
                return new ByteOutputHandler(this.name, this.totalSize);
            }
            case FILE: {
                return new FileOutputHandler(this.fileData, this.totalSize, bl);
            }
            case STREAM: {
                return new StreamOutputHandler(this.streamOutputData, this.name, this.totalSize);
            }
            case URL: {
                return new URLOutputHandler(this.urlEndpoint, this.urlNetConf, this.urlCreds, this.name, this.totalSize);
            }
            case CLOUD: {
                switch (this.cloudType) {
                    case S3: {
                        switch (this.s3Type) {
                            case GENERIC: {
                                return new S3OutputHandler(this.genericS3ClientBuilder, this.s3Bucket, this.s3Filepath, this.name, this.totalSize);
                            }
                            case AMAZON: {
                                return new AmazonS3OutputHandler(this.as3UserId, this.as3SecretKey, this.s3Bucket, this.s3Filepath, this.name, this.totalSize);
                            }
                            case ARUBA: {
                                return new ArubaCloudS3OutputHandler(this.arubaCloudEndpoint, this.arubaCloudUserId, this.arubaCloudSecretKey, this.s3Bucket, this.s3Filepath, this.name, this.totalSize);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unable to create input handler with the given data, try to add more configuration properties!");
            }
        }
        throw new UnsupportedOperationException("Unable to create input handler with the given data, try to add more configuration properties!");
    }
}

