/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.pkcs11.CapiPKCS11Exception;
import it.actalis.pkcs11.nat.NativePKCS11;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pkcs11.card.CNSStrategy;
import it.arubapec.ca.pkcs11.card.CardLibrary;
import it.arubapec.ca.pkcs11.card.CardStore;
import it.arubapec.ca.pkcs11.card.DSStrategy;
import it.arubapec.ca.pkcs11.card.FSStrategy;
import it.arubapec.ca.pkcs11.card.FamilyName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class CardFamily {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private String name;
    private transient CardLibrary selected_lib;
    private String defaultPIN;
    private String defaultPUK;
    private CNSStrategy cnsStrategy = CNSStrategy.NONE;
    private DSStrategy dsStrategy = DSStrategy.NONE;
    private FSStrategy fsStrategy = FSStrategy.NONE;
    private transient LinkedList<CardLibrary> libs = null;
    private final List<String> libReferences = new ArrayList<String>();

    public CardFamily(String string, String string2, String string3, CNSStrategy cNSStrategy, DSStrategy dSStrategy) {
        this(string, string2, string3, cNSStrategy, dSStrategy, FSStrategy.NONE);
    }

    public CardFamily(String string, String string2, String string3, CNSStrategy cNSStrategy, DSStrategy dSStrategy, FSStrategy fSStrategy) {
        this.name = string;
        this.defaultPIN = string2;
        this.defaultPUK = string3;
        this.cnsStrategy = cNSStrategy;
        this.dsStrategy = dSStrategy;
        this.fsStrategy = fSStrategy;
        this.libs = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public boolean isCustomOverride() {
        return this.name.equals((Object)FamilyName.CUSTOM);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDefaultPIN() {
        return this.defaultPIN;
    }

    public void setDefaultPIN(String string) {
        this.defaultPIN = string;
    }

    public String getDefaultPUK() {
        return this.defaultPUK;
    }

    public void setDefaultPUK(String string) {
        this.defaultPUK = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CardFamily)) {
            return false;
        }
        object = (CardFamily)object;
        return this.name.equals(((CardFamily)object).name);
    }

    public int hashCode() {
        int n = 679 + (this.name != null ? this.name.hashCode() : 0);
        return n;
    }

    public LinkedList<CardLibrary> getLib() {
        return this.libs;
    }

    public void addLib(CardLibrary cardLibrary) {
        LinkedList<CardLibrary> linkedList = this.getLib();
        if (!linkedList.contains(cardLibrary)) {
            linkedList.add(cardLibrary);
            this.libReferences.add(cardLibrary.getDriveName());
        }
    }

    public String toString() {
        String string = "";
        if (this.name != null) {
            string = string + "name " + this.name + "\n";
        }
        if (this.selected_lib != null) {
            string = string + "selected_lib " + this.selected_lib.getDrive() + "\n";
        }
        if (this.defaultPIN != null) {
            string = string + "defaultPIN " + this.defaultPIN + "\n";
        }
        if (this.defaultPUK != null) {
            string = string + "defaultPUK " + this.defaultPUK + "\n";
        }
        if (this.cnsStrategy != null) {
            string = string + "cnsStrategy " + this.cnsStrategy.name() + "\n";
        }
        if (this.dsStrategy != null) {
            string = string + "dsStrategy " + this.dsStrategy.name() + "\n";
        }
        if (this.fsStrategy != null) {
            string = string + "fsStrategy " + this.fsStrategy.name() + "\n";
        }
        if (this.libReferences != null) {
            for (String object : this.libReferences) {
                string = string + "lib ref " + object + "\n";
            }
        }
        if (this.libs != null) {
            for (CardLibrary cardLibrary : this.libs) {
                string = string + "lib " + cardLibrary.getDriveName() + "\n";
                if (cardLibrary.getWindowsDrive() != null) {
                    string = string + "    " + cardLibrary.getWindowsDrive() + "\n";
                }
                if (cardLibrary.getLinuxDrive() != null) {
                    string = string + "    " + cardLibrary.getLinuxDrive() + "\n";
                }
                if (cardLibrary.getOsxDrive() == null) continue;
                string = string + "    " + cardLibrary.getOsxDrive() + "\n";
            }
        }
        return string;
    }

    public CardLibrary getSelected_lib() {
        return this.selected_lib;
    }

    public void setSelected_lib(CardLibrary cardLibrary) {
        this.selected_lib = cardLibrary;
    }

    void rebuild(CardStore cardStore) throws IOException {
        if (this.libs == null) {
            this.libs = new LinkedList();
        }
        for (String string : this.libReferences) {
            boolean bl = false;
            for (CardLibrary cardLibrary : cardStore.getCardLibraries()) {
                if (!cardLibrary.getDriveName().equals(string)) continue;
                this.libs.add(cardLibrary);
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IOException("No Drive Found --> " + string);
        }
    }

    public NativePKCS11 getPKCS11() throws CapiPKCS11Exception, IOException {
        return this.getPKCS11(true);
    }

    public NativePKCS11 getPKCS11(boolean bl) throws CapiPKCS11Exception, IOException {
        if (this.getSelected_lib() != null) {
            logger.info("pkcs11: " + this.getSelected_lib().getDriveName());
            return NativePKCS11.getInstance(this.getSelected_lib().getDrive(), bl);
        }
        for (CardLibrary cardLibrary : this.getLib()) {
            logger.info("look for library " + cardLibrary.getDriveName());
            try {
                NativePKCS11 nativePKCS11 = NativePKCS11.getInstance(cardLibrary.getDrive(), bl);
                this.setSelected_lib(cardLibrary);
                logger.info("library selected");
                return nativePKCS11;
            }
            catch (Throwable throwable) {
                logger.debug("library not found {}", (Object)cardLibrary.getDrive(), (Object)throwable);
            }
        }
        throw new UnsatisfiedLinkError("Unable to link any library of family " + this.getName());
    }

    public CNSStrategy getCnsStrategy() {
        return this.cnsStrategy;
    }

    public DSStrategy getDsStrategy() {
        return this.dsStrategy;
    }

    public FSStrategy getFsStrategy() {
        return this.fsStrategy;
    }
}

