/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11.nat;

import com.sun.jna.ptr.LongByReference;
import it.actalis.pkcs11.CapiPKCS11Exception;
import it.actalis.pkcs11.PKCS11Object;
import it.actalis.pkcs11.PKCS11Session;
import it.actalis.pkcs11.nat.NativePKCS11Session;
import java.math.BigInteger;
import java.util.Date;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;

public class NativePKCS11Object
extends PKCS11Object {
    protected NativePKCS11Session session;
    protected long objectID;

    protected NativePKCS11Object(NativePKCS11Session nativePKCS11Session, long l) {
        this.session = nativePKCS11Session;
        this.objectID = l;
    }

    @Override
    public PKCS11Session getSession() {
        return this.session;
    }

    @Override
    public PKCS11Object copy(long[] lArray, Object[] objectArray) throws CapiPKCS11Exception {
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                cK_ATTRIBUTEArray[i] = new CK_ATTRIBUTE(lArray[i], objectArray[i]);
            }
            long l = this.session.a().a().C_CopyObject(this.session.sessionID, this.objectID, cK_ATTRIBUTEArray);
            return new NativePKCS11Object(this.session, l);
        }
        catch (Exception exception) {
            throw new CapiPKCS11Exception(exception.getMessage(), exception);
        }
    }

    @Override
    public void destroy() throws CapiPKCS11Exception {
        try {
            this.session.a().a().C_DestroyObject(this.session.sessionID, this.objectID);
            return;
        }
        catch (Exception exception) {
            throw new CapiPKCS11Exception(exception.getMessage(), exception);
        }
    }

    @Override
    public long size() throws CapiPKCS11Exception {
        LongByReference longByReference = new LongByReference();
        long l = this.session.a().getExtraFunctionPointer().a(this.session.sessionID, this.objectID, longByReference);
        if (l != 0L) {
            throw new CapiPKCS11Exception(l);
        }
        return longByReference.getValue();
    }

    @Override
    public Object getAttributeValue(long l) throws CapiPKCS11Exception {
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = cK_ATTRIBUTEArray;
            cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE();
            cK_ATTRIBUTEArray2[0].type = l;
            this.session.a().a().C_GetAttributeValue(this.session.sessionID, this.objectID, cK_ATTRIBUTEArray2);
            return cK_ATTRIBUTEArray2[0].pValue;
        }
        catch (Exception exception) {
            throw new CapiPKCS11Exception(exception.getMessage(), exception);
        }
    }

    @Override
    public void setAttributeValues(long[] lArray, Object[] objectArray) throws CapiPKCS11Exception {
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                cK_ATTRIBUTEArray[i] = new CK_ATTRIBUTE(lArray[i], objectArray[i]);
            }
            this.session.a().a().C_SetAttributeValue(this.session.sessionID, this.objectID, cK_ATTRIBUTEArray);
            return;
        }
        catch (Exception exception) {
            throw new CapiPKCS11Exception(exception.getMessage(), exception);
        }
    }

    @Override
    public void setAttributeValue(long l, Object object) throws CapiPKCS11Exception {
        try {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = cK_ATTRIBUTEArray;
            cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE(l, object);
            this.session.a().a().C_SetAttributeValue(this.session.sessionID, this.objectID, cK_ATTRIBUTEArray2);
            return;
        }
        catch (Exception exception) {
            throw new CapiPKCS11Exception(exception.getMessage(), exception);
        }
    }

    @Override
    public boolean getBoolAttributeValue(long l) throws CapiPKCS11Exception {
        return (Boolean)this.getAttributeValue(l);
    }

    @Override
    public int getIntAttributeValue(long l) throws CapiPKCS11Exception {
        return ((Long)this.getAttributeValue(l)).intValue();
    }

    @Override
    public String getStringAttributeValue(long l) throws CapiPKCS11Exception {
        return new String((char[])this.getAttributeValue(l));
    }

    @Override
    public byte[] getByteArrayAttributeValue(long l) throws CapiPKCS11Exception {
        return (byte[])this.getAttributeValue(l);
    }

    @Override
    public Date getDateAttributeValue(long l) throws CapiPKCS11Exception {
        return (Date)this.getAttributeValue(l);
    }

    @Override
    public BigInteger getBigIntegerAttributeValue(long l) throws CapiPKCS11Exception {
        byte[] byArray = (byte[])this.getAttributeValue(l);
        byte[] byArray2 = new byte[byArray.length + 1];
        byte[] byArray3 = byArray2;
        byArray2[0] = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i + 1] = byArray[i];
        }
        return new BigInteger(byArray3);
    }

    @Override
    public void setBoolAttributeValue(long l, boolean bl) throws CapiPKCS11Exception {
        this.setAttributeValue(l, bl);
    }

    @Override
    public void setIntAttributeValue(long l, int n) throws CapiPKCS11Exception {
        this.setAttributeValue(l, n);
    }
}

