/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.functionality;

import esecurity.crypto.gui.facade.StatusLevel;
import esecurity.crypto.gui.functionality.ValidationFacade;
import esecurity.crypto.gui.model.FileToSign;
import esecurity.crypto.gui.model.OperationResult;
import esecurity.crypto.gui.model.Status;
import esecurity.crypto.gui.model.TimeStampRequest;
import esecurity.crypto.gui.properties.ClientProperties;
import esecurity.crypto.gui.utils.files.FileSystemUtils;
import esecurity.validator.ValidatorConfig;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSAUtil;
import it.actalis.ellips.capi.tsa.TSDUtils;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;

public class TimestampFacade {
    private static final EllipsLogger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OperationResult mark(TimeStampRequest timeStampRequest) throws IOException {
        StatusLevel statusLevel;
        boolean bl = true;
        boolean bl2 = false;
        ClientProperties clientProperties = ClientProperties.getInstance();
        for (FileToSign fileToSign : timeStampRequest.getFiles()) {
            File file = timeStampRequest.getDestinationFolder();
            if (file == null) {
                file = fileToSign.getParentFile();
            }
            file = FileSystemUtils.renameFilesWithSameName(file, fileToSign.getDestinationFileName(), fileToSign.getDestinationFileExtension());
            Status status = null;
            try {
                block26: {
                    Throwable throwable;
                    InputHandler inputHandler = DataHandlerBuilder.get().setFile((File)fileToSign).buildInput();
                    Throwable throwable2 = null;
                    try {
                        block25: {
                            Throwable throwable3;
                            throwable = DataHandlerBuilder.get().setFile(file).setReplace(true).buildOutput();
                            Throwable throwable4 = null;
                            try {
                                if (TimestampType.TSR.equals((Object)timeStampRequest.getMarkType())) {
                                    throwable3 = TSAUtil.getMark((InputStream)inputHandler.getInputAsNewStream(), (boolean)true, (TSAData)timeStampRequest.getTsaData(), (NetworkConfig)clientProperties.getNetworkConfig());
                                    throwable.write(throwable3.getEncoded());
                                } else {
                                    TSDUtils.createTsd((InputHandler)inputHandler, (OutputHandler)throwable, (TSAData)timeStampRequest.getTsaData(), (String)fileToSign.getName(), (String)"application/pkcs7-mime", (ValidatorConfig)ValidationFacade.getValidatorConfig(), (boolean)false);
                                }
                                status = new Status(StatusLevel.SUCCESS, "OK");
                                bl = false;
                                if (throwable == null) break block25;
                            }
                            catch (Throwable throwable5) {
                                try {
                                    throwable3 = throwable5;
                                    throwable4 = throwable5;
                                    throw throwable3;
                                }
                                catch (Throwable throwable6) {
                                    if (throwable == null) throw throwable6;
                                    if (throwable4 == null) {
                                        throwable.close();
                                        throw throwable6;
                                    }
                                    try {
                                        throwable.close();
                                        throw throwable6;
                                    }
                                    catch (Throwable throwable7) {
                                        throwable4.addSuppressed(throwable7);
                                        throw throwable6;
                                    }
                                }
                            }
                            throwable.close();
                        }
                        if (inputHandler == null) break block26;
                    }
                    catch (Throwable throwable8) {
                        try {
                            throwable = throwable8;
                            throwable2 = throwable8;
                            throw throwable;
                        }
                        catch (Throwable throwable9) {
                            if (inputHandler == null) throw throwable9;
                            if (throwable2 == null) {
                                inputHandler.close();
                                throw throwable9;
                            }
                            try {
                                inputHandler.close();
                                throw throwable9;
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                                throw throwable9;
                            }
                        }
                    }
                    inputHandler.close();
                }
                fileToSign.setSignResult(status);
            }
            catch (Throwable throwable) {
                try {
                    a.error(throwable.getMessage(), throwable);
                    status = new Status(StatusLevel.ERROR, throwable);
                    bl2 = true;
                    Files.delete(file.toPath());
                    if (throwable.getMessage().endsWith("PIN_INCORRECT")) {
                        fileToSign.setSignResult(status);
                        break;
                    }
                    fileToSign.setSignResult(status);
                }
                catch (Throwable throwable11) {
                    fileToSign.setSignResult(status);
                    throw throwable11;
                }
            }
        }
        if (bl) {
            statusLevel = StatusLevel.ERROR;
            return new OperationResult<FileToSign>(new Status(statusLevel, ""), timeStampRequest.getFiles(), timeStampRequest.getDestinationFolder());
        }
        if (bl2) {
            statusLevel = StatusLevel.WARNING;
            return new OperationResult<FileToSign>(new Status(statusLevel, ""), timeStampRequest.getFiles(), timeStampRequest.getDestinationFolder());
        }
        statusLevel = StatusLevel.SUCCESS;
        return new OperationResult<FileToSign>(new Status(statusLevel, ""), timeStampRequest.getFiles(), timeStampRequest.getDestinationFolder());
    }

    public static enum TimestampType {
        TSR(".tsr"),
        TSD(".tsd");

        private final String a;

        private TimestampType(String string2) {
            this.a = string2;
        }

        public final String getExtension() {
            return this.a;
        }
    }
}

