/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.parser;

import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.ParserUtils;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.TempFileOutputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsa.TimeStampedData;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.slf4j.Logger;

public class TSDParser
extends SignatureParser {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private DateFormat b = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");

    public TSDParser(SignatureParserBuilder signatureParserBuilder) {
        super(signatureParserBuilder);
        this.b.setTimeZone(Constants.DEFAULT_TIMEZONE);
    }

    public ParsedTransientDocument parse(InputHandler object, EventHandlerSelector timeStampAndCRLArray, NetworkConfig networkConfig, TimeZone timeZone, File file) throws ParsingException {
        ParsedTransientDocument parsedTransientDocument = new ParsedTransientDocument((InputHandler)object);
        InputHandler inputHandler = null;
        OutputHandler outputHandler = null;
        if (timeZone != null) {
            this.b.setTimeZone(timeZone);
        }
        timeZone = null;
        try {
            timeZone = new TimeStampedData(object.getInputAsNewStream(), object.getName());
            if (timeZone.getContent() == null) {
                throw new IOException("Empty Content");
            }
            object = null;
            try {
                object = timeZone.getMetaData();
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
            }
            boolean bl = false;
            try {
                bl = timeZone.getHashProtected();
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
            }
            outputHandler = DataHandlerBuilder.get().setTemp((File)TmpFileUtils.createTempFile((String)"sub_", (String)".data", (File)file)).buildOutput();
            OutputStream outputStream = outputHandler.getAsOutputStream();
            if (bl) {
                outputStream.write((byte[])object);
            }
            object = ((String)(object = parsedTransientDocument.getShortName())).lastIndexOf(".") != -1 ? ((String)object).substring(0, ((String)object).lastIndexOf(".")) : object;
            object = timeZone.getDataURI() != null ? DataHandlerBuilder.get().setUrl(new URL(timeZone.getDataURI())).setUrlNetConf(networkConfig).setName((String)object).buildInput() : DataHandlerBuilder.get().setInputStream(timeZone.getContent()).setName((String)object).buildInput();
            Util.copyStream((InputStream)object.getInputAsNewStream(), (OutputStream)outputStream);
            object = ParserUtils.parseDoc((InputHandler)object, (EventHandlerSelector)timeStampAndCRLArray, (NetworkConfig)networkConfig, (TimeZone)this.b.getTimeZone(), (File)file);
            parsedTransientDocument.addRefDoc((TransientDocument)object);
            outputStream.flush();
            inputHandler = DataHandlerBuilder.get().setTemp(((TempFileOutputHandler)outputHandler).getFile()).buildInput();
            timeStampAndCRLArray = timeZone.getTstEvidence();
            for (int i = 0; i < timeStampAndCRLArray.length; ++i) {
                parsedTransientDocument.setSigned(true);
                file = timeStampAndCRLArray[i];
                file = TSTUtils.tstToVol((TransientDocument)parsedTransientDocument, (byte[])file.getTimeStampToken(), (InputHandler)inputHandler, (String)object.getId(), (DateFormat)this.b);
                parsedTransientDocument.addSignerInfo((SignatureInformation)file);
            }
        }
        catch (Exception exception) {
            try {
                throw new ParsingException("Unable to parse file", (Throwable)exception);
            }
            catch (Throwable throwable) {
                if (timeZone != null) {
                    timeZone.free();
                }
                Util.closeQuietly(inputHandler);
                Util.closeQuietly(outputHandler);
                throw throwable;
            }
        }
        timeZone.free();
        Util.closeQuietly((Closeable)inputHandler);
        Util.closeQuietly((Closeable)outputHandler);
        return parsedTransientDocument;
    }
}

