/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.annotation;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationSquareCircle;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.annotation.AnnotationValidator;
import org.apache.pdfbox.preflight.exception.ValidationException;

public class SquareCircleAnnotationValidator
extends AnnotationValidator {
    protected PDAnnotationSquareCircle pdSquareCircle = null;

    public SquareCircleAnnotationValidator(PreflightContext ctx, COSDictionary annotDictionary) {
        super(ctx, annotDictionary);
        this.pdSquareCircle = new PDAnnotationSquareCircle(annotDictionary);
        this.pdAnnot = this.pdSquareCircle;
    }

    @Override
    public boolean validate() throws ValidationException {
        boolean isValid = super.validate();
        isValid = this.checkIColors() && isValid;
        return isValid;
    }

    protected boolean checkIColors() throws ValidationException {
        if (this.pdSquareCircle.getInteriorColor() != null && !this.searchRGBProfile()) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.2.3", "Annotation uses a Color profile which isn't the same than the profile contained by the OutputIntent"));
            return false;
        }
        return true;
    }
}

