/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.signature;

import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.crl.CRLUtils;
import esecurity.validator.x509status.ocsp.HttpOCSPClient;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.LTResource;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.slf4j.Logger;

public class LTResourceResolver {
    private NetworkConfig a = HTTP.defaultConfig;
    private Logger b;
    private CertDB c;

    public LTResourceResolver(NetworkConfig networkConfig, Logger logger, CertDB certDB) {
        if (networkConfig != null) {
            this.a = networkConfig;
        }
        this.b = logger == null ? EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME) : logger;
        this.c = certDB;
    }

    public LTResource resolve(X509Certificate x509Certificate) throws CapiException, IOException, CertificateException {
        return this.resolve(x509Certificate, null);
    }

    public LTResource resolve(X509Certificate x509Certificate, Date date) throws CapiException, IOException, CertificateException {
        LTResource lTResource = new LTResource();
        CertDBItem[] certDBItemArray = this.c.onLineVerify(this.a, x509Certificate.getEncoded());
        if (certDBItemArray.length == 0) {
            throw new CapiException("Unable to resolve the certificate chain for cert " + x509Certificate.getSubjectDN(), 1003);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        simpleDateFormat.setTimeZone(Constants.DEFAULT_TIMEZONE);
        for (int i = 0; i < certDBItemArray.length; ++i) {
            int n;
            Object object;
            int n2;
            lTResource.addCert(certDBItemArray[i].getCertificate().getInternalCert());
            CertDBItem[] certDBItemArray2 = null;
            for (n2 = 0; n2 < 2 && (certDBItemArray2 = this.a(x509Certificate, certDBItemArray[i].getCertificate().getInternalCert())) != null; ++n2) {
                if (certDBItemArray2.getBasicOcspResponse().getCerts() == null || certDBItemArray2.getBasicOcspResponse().getCerts().length == 0) {
                    this.b.debug("OCSP response for certificate " + x509Certificate.getSubjectDN() + " has not certificate itself. Try with CRL...");
                    certDBItemArray2 = null;
                    break;
                }
                object = "";
                n = 1;
                if (date != null && certDBItemArray2.getProducedAt().before(date)) {
                    object = String.format("OCSP response date (%s) produced before than time stamp (%s)", simpleDateFormat.format(certDBItemArray2.getProducedAt()), simpleDateFormat.format(date));
                    this.b.debug("trial " + (n2 + 1) + ": " + (String)object);
                    n = 0;
                }
                if (n != 0) break;
                if (n2 == 2) {
                    throw new CapiException((String)object, 1003);
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (certDBItemArray2 != null) {
                lTResource.addOcspResponse((OCSPResponse)certDBItemArray2);
                object = certDBItemArray2.getBasicOcspResponse().getCerts();
                n = ((X509CertificateHolder[])object).length;
                for (n2 = 0; n2 < n; ++n2) {
                    certDBItemArray2 = object[n2];
                    X509Certificate x509Certificate2 = new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate((X509CertificateHolder)certDBItemArray2);
                    lTResource.addCert(x509Certificate2);
                    try {
                        x509Certificate2.verify(certDBItemArray[i].getCertificate().getPublicKey());
                        continue;
                    }
                    catch (Exception exception) {
                        certDBItemArray2 = this.c.onLineVerify(this.a, certDBItemArray2.getEncoded());
                        if (certDBItemArray2 == null || certDBItemArray2.length <= 0) continue;
                        for (CertDBItem certDBItem : certDBItemArray2) {
                            lTResource.addCert(certDBItem.getCertificate().getInternalCert());
                        }
                    }
                }
                continue;
            }
            certDBItemArray2 = x509Certificate;
            LTResourceResolver lTResourceResolver = this;
            object = new UrlClient(lTResourceResolver.a);
            ValidatorConfig validatorConfig = new ValidatorConfig();
            validatorConfig.setElement("verify.mode", "CRLONLY");
            object = CRLUtils.getCrlForCertificate(object, validatorConfig, new Certificate((X509Certificate)certDBItemArray2), new Date(), lTResourceResolver.c);
            if (object == null) {
                throw new CapiException("Unable to get revocation status for certificate " + x509Certificate.getSubjectDN(), 30005);
            }
            lTResource.addCrl((CRL)object);
        }
        if (!lTResource.isResolved()) {
            throw new CapiException("Unable to resolve LT resources for certificate " + x509Certificate.getSubjectDN(), 1003);
        }
        return lTResource;
    }

    private OCSPResponse a(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        try {
            HttpOCSPClient httpOCSPClient = new HttpOCSPClient(this.a, this.b, this.c);
            if (this.a(x509Certificate) != null) {
                return httpOCSPClient.sendOCSPRequest(this.a(x509Certificate), x509Certificate, x509Certificate2);
            }
        }
        catch (CapiException capiException) {
            this.b.error("unable to call OCSP: " + capiException.getMessage() + " " + capiException.getErrorCode(), (Throwable)capiException);
        }
        catch (OCSPException oCSPException) {
            this.b.error("unable to call OCSP: " + oCSPException.getMessage(), (Throwable)oCSPException);
        }
        catch (Exception exception) {
            this.b.error("unable to call OCSP: " + exception.getMessage(), (Throwable)exception);
        }
        return null;
    }

    private String a(X509Certificate dERTaggedObject) {
        try {
            byte[] byArray = dERTaggedObject.getExtensionValue(Extension.authorityInfoAccess.getId());
            dERTaggedObject = (DERTaggedObject)byArray;
            if (byArray != null) {
                dERTaggedObject = X509ExtensionUtil.fromExtensionValue((byte[])dERTaggedObject);
                dERTaggedObject = AuthorityInformationAccess.getInstance((Object)((ASN1Sequence)dERTaggedObject));
                dERTaggedObject = dERTaggedObject.getAccessDescriptions();
                int n = ((AccessDescription[])dERTaggedObject).length;
                for (int i = 0; i < n; ++i) {
                    AccessDescription accessDescription = dERTaggedObject[i];
                    if (!accessDescription.getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_ocsp)) continue;
                    dERTaggedObject = (DERTaggedObject)accessDescription.getAccessLocation().toASN1Primitive();
                    dERTaggedObject = dERTaggedObject.getObjectParser(6, true).toASN1Primitive();
                    return dERTaggedObject.toString();
                }
            }
        }
        catch (Exception exception) {
            this.b.error(exception.getMessage(), (Throwable)exception);
            return null;
        }
        return null;
    }
}

