/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;

public class Util {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final SecureRandom secureRandom = new SecureRandom();
    public static final int noWarning = 0;
    public static final int DigestNotCompliant = 1;
    public static final int SHA1NotCompliant = 2;
    public static final int NoSignerCertV2 = 3;
    public static final String enchar = "ISO8859_1";

    public static Date getDateFromTStamp(TimeStampToken timeStampToken) {
        if (timeStampToken == null) {
            return null;
        }
        try {
            return timeStampToken.getTimeStampInfo().getGenTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isDerSequence(String object) throws IOException {
        object = new FileInputStream((String)object);
        int n = ((FileInputStream)object).read();
        ((FileInputStream)object).close();
        return n == 48;
    }

    public static boolean isDerSequence(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        return byArray[0] == 48;
    }

    public static byte[] base64Decode(byte[] byArray) throws CapiException {
        if (byArray == null) {
            return null;
        }
        try {
            return Base64.decode((byte[])byArray);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Wrong Base64 format", 5001);
        }
    }

    public static byte[] base64DecodeStr(String string) throws CapiException {
        if (string == null) {
            return null;
        }
        try {
            return Base64.decode((String)string);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Wrong Base64 format", 5001);
        }
    }

    public static byte[] base64Encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return Base64.encode((byte[])byArray);
    }

    public static String base64EncodeStr(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return Util.newString(Util.base64Encode(byArray));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFile(String object) throws CapiException {
        if (object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        Object object2 = null;
        try {
            object2 = new FileInputStream((String)object);
            object = Streams.readAll((InputStream)object2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new CapiException("File not found", 4002);
                catch (IOException iOException) {
                    a.debug(iOException.getMessage(), (Throwable)iOException);
                    throw new CapiException("File read error", 4000);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (object2 == null) throw throwable;
                    ((FileInputStream)object2).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            ((FileInputStream)object2).close();
            return object;
        }
        catch (IOException iOException) {
            object2 = iOException;
            iOException.printStackTrace();
        }
        return object;
    }

    public static byte[] digestStreams(String object, InputStream ... inputStreamArray) throws CapiException {
        SHA1Digest sHA1Digest;
        if (((String)object).equals(Constants.SHA1)) {
            sHA1Digest = new SHA1Digest();
        } else if (((String)object).equals(Constants.SHA256)) {
            sHA1Digest = new SHA256Digest();
        } else {
            throw new CapiException("Invalid Digest Type", 1002);
        }
        object = new byte[sHA1Digest.getDigestSize()];
        if (inputStreamArray == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (inputStreamArray.length == 0) {
            throw new CapiException("No stream", 1002);
        }
        try {
            byte[] byArray = new byte[64000];
            for (InputStream inputStream : inputStreamArray) {
                int n;
                while ((n = inputStream.read(byArray, 0, 64000)) >= 0) {
                    sHA1Digest.update(byArray, 0, n);
                }
            }
            sHA1Digest.doFinal((byte[])object, 0);
        }
        catch (IOException iOException) {
            a.debug(iOException.getMessage(), (Throwable)iOException);
            throw new CapiException("File read error", 4000);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveToFile(byte[] byArray, String string) throws CapiException {
        if (byArray == null) throw new CapiException("Null parameters", 1001);
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            try {
                a.debug(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("File write error", 4001);
            }
            catch (Throwable throwable) {
                try {
                    if (fileOutputStream == null) throw throwable;
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    a.error(iOException2.getMessage(), (Throwable)iOException2);
                }
                throw throwable;
            }
        }
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
            return;
        }
    }

    public static boolean equalsBlock(byte[] byArray, byte[] byArray2) throws CapiException {
        if (byArray == null || byArray2 == null) {
            throw new CapiException("Null parameters", 1001);
        }
        return Arrays.areEqual((byte[])byArray, (byte[])byArray2);
    }

    public static String bigIntToHexStr(BigInteger object) throws CapiException {
        if (object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (((String)(object = ((BigInteger)object).toString(16))).length() % 2 == 0) {
            return object;
        }
        return "0" + (String)object;
    }

    public static BigInteger bigIntFromHexStr(String object) throws CapiException {
        if (object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            object = new BigInteger((String)object, 16);
            return object;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Wrong format", 6001);
        }
    }

    public static String getRDN(String object, String string) {
        if (object == null || string == null) {
            return null;
        }
        object = new StringTokenizer((String)object, ",", false);
        string = string.toUpperCase() + "=";
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object).nextToken();
            if (!string2.toUpperCase().startsWith(string)) continue;
            return string2.substring(string.length());
        }
        return null;
    }

    public static String fromPemString(String string, boolean bl) {
        String string2 = System.getProperty("line.separator");
        if (string == null || string.equals("")) {
            return string;
        }
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.setLength(0);
            int n = 0;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.startsWith("-----BEGIN")) {
                    stringBuffer.setLength(0);
                    n = 1;
                    continue;
                }
                if (bl && n == 0) break;
                if (n == 1 && string3.startsWith("-----END")) {
                    n = 2;
                    break;
                }
                stringBuffer.append(string3.trim());
                stringBuffer.append(string2);
            }
            if (n == 0) {
                return string;
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            a.debug(iOException.getMessage(), (Throwable)iOException);
            return string;
        }
    }

    public static String formatDate(Date date, String string) throws CapiException {
        return Util.formatDate(date, string, null);
    }

    public static String formatDate(Date object, String object2, String object3) throws CapiException {
        if (object2 == null) {
            object2 = "yyyyMMddHHmmss";
        }
        try {
            object2 = new SimpleDateFormat((String)object2);
            object3 = object3 == null ? TimeZone.getDefault() : TimeZone.getTimeZone((String)object3);
            if (object3 == null) {
                throw new CapiException("Timezone not present", 6002);
            }
            ((DateFormat)object2).setTimeZone((TimeZone)object3);
            object = ((DateFormat)object2).format((Date)object);
            return object;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Format date error", 6000);
        }
    }

    public static Date parseDate(String string, String string2) throws CapiException {
        return Util.parseDate(string, string2, null);
    }

    public static Date parseDate(String string, String object, String object2) throws CapiException {
        if (object == null) {
            object = "yyyyMMddHHmmss";
        }
        try {
            object = new SimpleDateFormat((String)object);
            object2 = object2 == null ? TimeZone.getDefault() : TimeZone.getTimeZone((String)object2);
            if (object2 == null) {
                throw new CapiException("Timezone not present", 6002);
            }
            ((DateFormat)object).setTimeZone((TimeZone)object2);
            return ((DateFormat)object).parse(string);
        }
        catch (ParseException parseException) {
            a.debug(parseException.getMessage(), (Throwable)parseException);
            throw new CapiException("Date format alert", 6000);
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Wrong date format", 6000);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean fromPemString(InputStream inputStream, OutputStream outputStream, boolean bl) throws CapiException {
        InputStreamReader inputStreamReader;
        BufferedReader bufferedReader;
        block33: {
            if (inputStream == null) {
                return true;
            }
            if (outputStream == null) {
                return true;
            }
            bufferedReader = null;
            inputStreamReader = null;
            try {
                String string;
                inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader, 4096);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 4096);
                int n = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("-----BEGIN")) {
                        n = 1;
                        continue;
                    }
                    if (bl && n == 0) break;
                    if (n == 1 && string.startsWith("-----END")) {
                        n = 2;
                        break;
                    }
                    string = string.trim() + System.getProperty("line.separator");
                    bufferedOutputStream.write(Util.getBytes(string), 0, string.length());
                }
                bufferedReader.close();
                bufferedOutputStream.flush();
                if (n != 0) break block33;
            }
            catch (Exception exception) {
                try {
                    a.debug(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("fromPemStream error", 1003);
                }
                catch (Throwable throwable) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception2) {}
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception3) {}
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception4) {}
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception5) {}
                    throw throwable;
                }
            }
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
            try {
                inputStreamReader.close();
            }
            catch (Exception exception) {}
            try {
                inputStream.close();
                return false;
            }
            catch (Exception exception) {}
            return false;
        }
        try {
            outputStream.close();
        }
        catch (Exception exception) {}
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {}
        try {
            inputStreamReader.close();
        }
        catch (Exception exception) {}
        try {
            inputStream.close();
            return true;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static byte[] getBytes(String string) throws CapiException {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(enchar);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            a.debug(unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
            throw new CapiException("ISO8859_1:why encoding unsupported?", 1003);
        }
    }

    public static String newString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, enchar);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            a.debug(unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
            return null;
        }
    }

    public static boolean isSHA1ForbiddenToSign(Date date) {
        return Util.isDateInvalid("20110701", "yyyyMMdd", date);
    }

    public static boolean isDateInvalid(String object, String object2, Date date) {
        boolean bl = true;
        object2 = new SimpleDateFormat((String)object2);
        try {
            object = ((DateFormat)object2).parse((String)object);
            if (!date.after((Date)object)) {
                bl = false;
            }
            return bl;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static int warningDelibera45Compliant(Date date, boolean bl, String string, boolean bl2) {
        if (!bl) {
            return 0;
        }
        if (string.compareToIgnoreCase("SHA-256") != 0 && string.compareToIgnoreCase(Constants.SHA256) != 0 && string.compareToIgnoreCase("SHA-1") != 0 && string.compareToIgnoreCase(Constants.SHA1) != 0 && string.compareToIgnoreCase("SHA") != 0 && string.compareToIgnoreCase("1.3.14.3.2.26") != 0 && string.compareToIgnoreCase("2.16.840.1.101.3.4.2.1") != 0) {
            return 1;
        }
        if (string.compareToIgnoreCase("SHA-256") != 0 && string.compareToIgnoreCase(Constants.SHA256) != 0 && string.compareToIgnoreCase("2.16.840.1.101.3.4.2.1") != 0) {
            if (date == null) {
                return 2;
            }
            if (date != null && Util.isSHA1ForbiddenToSign(date)) {
                return 2;
            }
        }
        if (!bl2) {
            if (date == null) {
                return 3;
            }
            if (date != null && Util.isSHA1ForbiddenToSign(date)) {
                return 3;
            }
        }
        return 0;
    }

    public static String dumpHex(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = byArray[i];
            StringBuffer stringBuffer = new StringBuffer(2);
            int n2 = (n & 0xF0) >> 4;
            stringBuffer.append(new Character((char)(n2 <= 9 ? n2 + 48 : n2 + 55)));
            stringBuffer.append(new Character((char)(n <= 9 ? n + 48 : (n &= 0xF) + 55)));
            String string2 = stringBuilder.append(stringBuffer.toString()).append(i == byArray.length - 1 ? "" : ":").toString();
            string = string.concat(string2);
        }
        return string;
    }

    public static void setRemoteSignProxyParams(String string, String string2, String string3, String string4, String string5, String string6, Boolean bl) throws Throwable {
        try {
            GenericDeclaration genericDeclaration = Class.forName("it.actalis.ellips.capi.RemoteSignatureToken");
            genericDeclaration = genericDeclaration.getMethod("setProxyParams", String.class, String.class, String.class, String.class, String.class, String.class, Boolean.class);
            ((Method)genericDeclaration).invoke(null, string, string2, string3, string4, string5, string6, bl);
            return;
        }
        catch (Throwable throwable) {
            a.debug(throwable.getMessage(), throwable);
            throw throwable;
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public static byte[] getBytesFromInputStream(InputStream inputStream) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[65535];
            while ((n = inputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            throw throwable;
        }
        byteArrayOutputStream.close();
        return byArray;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void closeQuietly(AutoCloseable autoCloseable) {
        try {
            if (autoCloseable != null) {
                autoCloseable.close();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static byte[] copyOf(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        return byArray2;
    }

    public static <T> T[] copyOf(T[] TArray, int n) {
        return Util.copyOf(TArray, n, TArray.getClass());
    }

    public static <T, U> T[] copyOf(U[] UArray, int n, Class<? extends T[]> objectArray) {
        objectArray = objectArray == Object[].class ? new Object[n] : (Object[])Array.newInstance(objectArray.getComponentType(), n);
        System.arraycopy(UArray, 0, objectArray, 0, Math.min(UArray.length, n));
        return objectArray;
    }

    public static short[] copyOf(short[] sArray, int n) {
        short[] sArray2 = new short[n];
        System.arraycopy(sArray, 0, sArray2, 0, Math.min(sArray.length, n));
        return sArray2;
    }

    public static int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        return nArray2;
    }

    public static long[] copyOf(long[] lArray, int n) {
        long[] lArray2 = new long[n];
        System.arraycopy(lArray, 0, lArray2, 0, Math.min(lArray.length, n));
        return lArray2;
    }

    public static char[] copyOf(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, Math.min(cArray.length, n));
        return cArray2;
    }

    public static float[] copyOf(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(fArray.length, n));
        return fArray2;
    }

    public static double[] copyOf(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, Math.min(dArray.length, n));
        return dArray2;
    }

    public static boolean[] copyOf(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(blArray, 0, blArray2, 0, Math.min(blArray.length, n));
        return blArray2;
    }

    public static List<String> readAllLines(File file) throws IOException {
        return Util.readAllLines(file, Charset.forName("UTF-8"));
    }

    public static List<String> readAllLines(File object, Charset object2) throws IOException {
        String string;
        if (object == null || object2 == null) {
            return null;
        }
        object = new FileInputStream((File)object);
        object2 = new BufferedReader(new InputStreamReader((InputStream)object));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = ((BufferedReader)object2).readLine()) != null) {
            arrayList.add(string);
        }
        ((BufferedReader)object2).close();
        ((FileInputStream)object).close();
        return arrayList;
    }

    public static byte[] getBytesFromPemOrBase64(byte[] byArray) throws CapiException {
        byte[] byArray2;
        block5: {
            byte by;
            block4: {
                byArray2 = byArray;
                by = byArray[0];
                boolean bl = by == 48;
                if ((by = by == 45 ? (byte)1 : 0) != 0 || bl) break block4;
                byArray2 = Util.base64Decode(byArray);
                break block5;
            }
            if (by != 0) {
                ByteArrayInputStream byteArrayInputStream;
                ByteArrayOutputStream byteArrayOutputStream;
                block3: {
                    byteArrayOutputStream = null;
                    byteArrayInputStream = null;
                    try {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        if (!Util.fromPemString(byteArrayInputStream, byteArrayOutputStream, true)) break block3;
                        byArray2 = Util.base64Decode(byteArrayOutputStream.toByteArray());
                    }
                    catch (Throwable throwable) {
                        Util.closeQuietly(byteArrayOutputStream);
                        Util.closeQuietly(byteArrayInputStream);
                        throw throwable;
                    }
                }
                Util.closeQuietly(byteArrayOutputStream);
                Util.closeQuietly(byteArrayInputStream);
            }
        }
        return byArray2;
    }

    public static String getRelativePath(String string, String charSequence, String string2) {
        int n;
        Object object;
        if ((string = FilenameUtils.normalizeNoEndSeparator((String)string)).equals(object = FilenameUtils.normalizeNoEndSeparator((String)charSequence))) {
            return "";
        }
        if (string2.equals("/")) {
            string = FilenameUtils.separatorsToUnix((String)string);
            object = FilenameUtils.separatorsToUnix((String)object);
        } else if (string2.equals("\\")) {
            string = FilenameUtils.separatorsToWindows((String)string);
            object = FilenameUtils.separatorsToWindows((String)object);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + string2 + "'");
        }
        String[] stringArray = ((String)object).split(Pattern.quote(string2));
        String[] stringArray2 = string.split(Pattern.quote(string2));
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < stringArray2.length && n < stringArray.length && stringArray2[n].equals(stringArray[n]); ++n) {
            stringBuffer.append(stringArray2[n] + string2);
        }
        if (n == 0) {
            throw new IllegalArgumentException("No common path element found for '" + string + "' and '" + (String)object + "'");
        }
        boolean bl = true;
        if (((File)(object = new File((String)object))).exists()) {
            bl = ((File)object).isFile();
        } else if (((String)charSequence).endsWith(string2)) {
            bl = false;
        }
        charSequence = new StringBuffer();
        if (stringArray.length != n) {
            int n2 = bl ? stringArray.length - n - 1 : stringArray.length - n;
            for (int i = 0; i < n2; ++i) {
                ((StringBuffer)charSequence).append(".." + string2);
            }
        }
        ((StringBuffer)charSequence).append(string.substring(stringBuffer.length()));
        return ((StringBuffer)charSequence).toString();
    }

    public static int[] intArrayFromList(List<Integer> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = list.get(i);
        }
        return nArray;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

