/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.ocsp;

import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.CertificateStatus;
import esecurity.validator.x509status.X509StatusValidator;
import esecurity.validator.x509status.ocsp.HttpOCSPClient;
import esecurity.validator.x509status.ocsp.OCSPCacheManager;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.util.DigestUtils;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.I;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class OCSPX509StatusValidator
implements X509StatusValidator {
    private ValidatorConfig a;
    private Logger b;
    private HttpOCSPClient c;
    private OCSPCacheManager d;
    private boolean e;

    public OCSPX509StatusValidator(ValidatorConfig validatorConfig, OCSPCacheManager oCSPCacheManager, Logger logger) throws CapiException {
        this.a = validatorConfig;
        this.e = validatorConfig.getBinElement("x509StatusService.cacheEnabled", true);
        this.c = new HttpOCSPClient(validatorConfig.getNetConfiguration(), logger, validatorConfig.getCertDB());
        this.d = oCSPCacheManager;
        this.b = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        if (logger != null) {
            this.b = logger;
        }
    }

    @Override
    public CertificateStatus checkStatus(Certificate certificate, ValidationDate validationDate) {
        CertificateStatus certificateStatus = new CertificateStatus();
        certificateStatus.setCrlBean(null);
        try {
            CertDBItem[] certDBItemArray;
            Object object;
            String string;
            block44: {
                if (certificate.getSubjectDN().equalsIgnoreCase(certificate.getIssuerDN())) {
                    this.b.debug(I.d() + "e' selfsigned: non fa la verifica OCSP");
                    certificateStatus.setCertValid(true);
                    certificateStatus.setCrlStatus("NO_CHECK");
                    CertificateStatus certificateStatus2 = certificateStatus;
                    return certificateStatus2;
                }
                if (certificate.isRsVerified()) {
                    this.b.debug(I.d() + "e' RsVerified");
                    certificateStatus.setCertValid(true);
                    certificateStatus.setCrlStatus("VERIFIED SIGNATURE");
                    CertificateStatus certificateStatus3 = certificateStatus;
                    return certificateStatus3;
                }
                string = certificate.getOcspUrl();
                if (string == null || string.isEmpty()) {
                    this.b.debug("no valid OCSP url found");
                    certificateStatus.setCrlStatus("NOT FOUND");
                    CertificateStatus certificateStatus4 = certificateStatus;
                    return certificateStatus4;
                }
                object = new ArrayList<CertDBItem>();
                try {
                    this.a.getCertDB().onLineVerify(this.a.getNetConfiguration(), certificate.getInternalCert().getEncoded(), (List<CertDBItem>)object);
                }
                catch (CapiException certDBItemArray2) {
                    certDBItemArray = certDBItemArray2;
                    if (certDBItemArray2.getErrorCode() != 30007) break block44;
                    certificateStatus.setCertCorrupted(true);
                }
            }
            ArrayList<CertDBItem> arrayList = object;
            certDBItemArray = arrayList.toArray(new CertDBItem[arrayList.size()]);
            if (certDBItemArray.length == 0) {
                this.b.debug(I.d() + "e' selfsigned: non fa la verifica OCSP");
                certificateStatus.setCertValid(false);
                certificateStatus.setInvalidityReason("No chain in CDB");
                object = certificateStatus;
                return object;
            }
            certificateStatus.setCertRevoked(false);
            certificateStatus.setCertValid(true);
            certificateStatus.setCrlStatus("OCSP_CHECK");
            certificateStatus.setVerificationType("OCSP");
            object = null;
            boolean bl = this.e;
            String string2 = null;
            if (bl) {
                try {
                    string2 = OCSPX509StatusValidator.a(certificate);
                }
                catch (CapiException capiException) {
                    this.b.error(capiException.getMessage(), (Throwable)capiException);
                }
            }
            if (bl &= string2 != null) {
                object = this.d.get(string2);
            }
            if (object == null) {
                Certificate certificate2 = certDBItemArray[0].getCertificate();
                object = this.c.sendOCSPRequest(string, certificate.getInternalCert(), certificate2.getInternalCert());
                if (this.e) {
                    this.d.addToCache(string2, (OCSPResponse)object);
                }
                if (this.b.isDebugEnabled()) {
                    this.b.debug("got ocsp response from server for " + string2);
                }
            } else if (this.b.isDebugEnabled()) {
                this.b.debug("got ocsp response from cache for " + string2);
            }
            int n = ((OCSPResponse)object).getCertStatus();
            if (n == OCSPResponse.REVOKED) {
                String string3;
                int n2 = ((OCSPResponse)object).getReasonCode();
                switch (n2) {
                    case 3: {
                        string3 = "AffiliationChanged";
                        break;
                    }
                    case 2: {
                        string3 = "CACompromise";
                        break;
                    }
                    case 6: {
                        string3 = "CertificateHold";
                        break;
                    }
                    case 5: {
                        string3 = "CessationOfOperation";
                        break;
                    }
                    case 1: {
                        string3 = "KeyCompromise";
                        break;
                    }
                    case 8: {
                        string3 = "RemoveFromCRL";
                        break;
                    }
                    case 4: {
                        string3 = "Superseded";
                        break;
                    }
                    case 0: {
                        string3 = "Unspecified";
                        break;
                    }
                    case 9: {
                        string3 = "PrivilegeWithdrawn";
                        break;
                    }
                    case 10: {
                        string3 = "AACompromise";
                        break;
                    }
                    default: {
                        string3 = "Unknown";
                    }
                }
                if (((OCSPResponse)object).getRevocationTime() != null && validationDate.getDate().before(((OCSPResponse)object).getRevocationTime())) {
                    string3 = string3 + " - After the verification date";
                } else {
                    certificateStatus.setCertRevoked(true);
                    certificateStatus.setCertValid(false);
                }
                certificateStatus.setInvalidityReason(string3);
                certificateStatus.setRevocationReason(Integer.toString(((OCSPResponse)object).getReasonCode()));
                certificateStatus.setRevocationDate(((OCSPResponse)object).getRevocationTime());
                certificateStatus.setCrlStatus("VALID");
            } else if (n == OCSPResponse.GOOD) {
                certificateStatus.setCrlStatus("VALID");
            } else if (n == OCSPResponse.UNKNOWN) {
                certificateStatus.setInvalidityReason("Unknown revocation status");
                certificateStatus.setCrlStatus("NOT FOUND");
            }
        }
        catch (Exception exception) {
            certificateStatus.setCrlStatus("NOT FOUND");
            this.b.error(I.d() + exception.getMessage());
        }
        finally {
            if (this.b.isDebugEnabled()) {
                this.b.debug("CRLX509StatusValidator result:");
                this.b.debug(certificateStatus.toString());
            }
        }
        return certificateStatus;
    }

    private static String a(Certificate certificate) throws CapiException {
        try {
            return DigestUtils.calculateHexString(DigestAlgorithm.SHA512, certificate.getDerEncoded());
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            throw new CapiException("Unable to calculate cert Identifier", 1003, exception);
        }
    }
}

