/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import esecurity.validator.bean.ValidatedBean;
import esecurity.validator.x509status.CertificateStatus;
import esecurity.validator.x509status.CrlBean;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.vol.utils.Constants;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ValidatedCertificate
extends ValidatedBean {
    private String a = null;
    private String b = null;
    private String c = null;
    private String d = null;
    private String e = null;
    private String f = null;
    private ValidatedCertificate g;
    private CertificateStatus h = null;
    private Certificate i = null;
    private boolean j = false;

    @JsonIgnore
    public Certificate getCert() {
        return this.i;
    }

    public void setCert(Certificate certificate) {
        this.i = certificate;
    }

    public String getCertSerial() {
        return this.a;
    }

    public void setCertSerial(String string) {
        this.a = string;
    }

    public String getCertNotBefore() {
        return this.b;
    }

    public void setCertNotBefore(String string) {
        this.b = string;
    }

    public String getCertNotAfter() {
        return this.c;
    }

    public void setCertNotAfter(String string) {
        this.c = string;
    }

    public String getCertSubject() {
        return this.d;
    }

    public void setCertSubject(String string) {
        this.d = string;
    }

    public String getCertIssuer() {
        return this.e;
    }

    public void setCertIssuer(String string) {
        this.e = string;
    }

    public ValidatedCertificate getIssuer() {
        return this.g;
    }

    public void setIssuer(ValidatedCertificate validatedCertificate) {
        this.g = validatedCertificate;
    }

    public String getCertName() {
        return this.f;
    }

    public void setCertName(String string) {
        this.f = string;
    }

    public boolean isCertRevoked() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.h.getCertRevoked();
    }

    public void setCertRevoked(boolean bl) {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        this.h.setCertRevoked(bl);
    }

    public boolean isCertTimeValid() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.h.getCertTimeValid();
    }

    public void setCertTimeValid(boolean bl) {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        this.h.setCertTimeValid(bl);
    }

    public boolean isCertCorrupted() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.h.getCertCorrupted();
    }

    public void setCertCorrupted(boolean bl) {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        this.h.setCertCorrupted(bl);
    }

    public boolean isCertTrusted() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.h.getCertTrusted();
    }

    public void setCertTrusted(boolean bl) {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        this.h.setCertTrusted(bl);
    }

    public boolean isCertValid() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.h.getCertValid();
    }

    public void setCertValid(boolean bl) {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        this.h.setCertValid(bl);
    }

    public boolean isRsVerified() throws CapiException {
        return this.j;
    }

    public void setRsVerified(boolean bl) {
        this.j = bl;
    }

    public Date getRevocationDate() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.h.getRevocationDate();
    }

    public void setRevocationDate(Date date) {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        this.h.setRevocationDate(date);
    }

    public String getRevocationReason() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.h.getRevocationReason();
    }

    public void setRevocationReason(String string) {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        this.h.setRevocationReason(string);
    }

    public String getInvalidityReason() throws CapiException {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        return this.h.getInvalidityReason();
    }

    public void setInvalidityReason(String string) {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        this.h.setInvalidityReason(string);
    }

    public String getCrlStatus() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.h.getCrlStatus();
    }

    public void setCrlStatus(String string) {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        this.h.setCrlStatus(string);
    }

    public String getVerificationType() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.h.getVerificationType();
    }

    public void setVerificationType(String string) {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        this.h.setVerificationType(string);
    }

    public CrlBean getCrlBean() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.h.getCrlBean();
    }

    public void setCrlBean(CrlBean crlBean) {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        this.h.setCrlBean(crlBean);
    }

    public boolean isCheckAnotherHelper() throws CapiException {
        if (this.h == null) {
            throw new CapiException("Undefined certificate status. CRL/OCSPHelper was not called", 30005);
        }
        return this.h.isCheckAnotherHelper();
    }

    public void setCheckAnotherHelper(boolean bl) {
        if (this.h == null) {
            this.h = new CertificateStatus();
        }
        this.h.setCheckAnotherHelper(bl);
    }

    public static ValidatedCertificate newInstance(Certificate certificate) {
        ValidatedCertificate validatedCertificate = new ValidatedCertificate();
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            simpleDateFormat.setTimeZone(Constants.DEFAULT_TIMEZONE);
            validatedCertificate.setCert(certificate);
            validatedCertificate.setCertIssuer(certificate.getIssuerDN());
            validatedCertificate.setCertSubject(certificate.getSubjectDN());
            validatedCertificate.setCertNotAfter(simpleDateFormat.format(certificate.getInternalCert().getNotAfter()));
            validatedCertificate.setCertNotBefore(simpleDateFormat.format(certificate.getInternalCert().getNotBefore()));
            validatedCertificate.setCertSerial(Util.bigIntToHexStr(certificate.getSerialNumber()));
            validatedCertificate.setCertName(certificate.getName());
            validatedCertificate.setRsVerified(certificate.isRsVerified());
        }
        catch (CapiException capiException) {}
        return validatedCertificate;
    }

    public boolean equals(Object object) {
        return object instanceof ValidatedCertificate && ((ValidatedCertificate)object).getCert().getInternalCert().equals(this.getCert().getInternalCert());
    }
}

