/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms;

import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.cms.CadesSignatureUpdater;
import it.actalis.ellips.capi.cms.CadesSignedAttributeGenerator;
import it.actalis.ellips.capi.cms.CadesSignedDataProxy;
import it.actalis.ellips.capi.cms.CadesUnSignedAttributeGenerator;
import it.actalis.ellips.capi.cms.a;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.util.CacheOutputStream;
import it.actalis.ellips.capi.pkcs7.VerRsContentSignerBuilder;
import it.actalis.ellips.capi.pkcs7.VerRsSignerInfoGenerator;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.LTResourceResolver;
import it.actalis.ellips.capi.signature.SignatureGenerator;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.util.SignUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cert.jcajce.JcaCRLStore;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.io.Streams;

public class CadesSignatureGenerator
extends SignatureGenerator<CadesSignatureOptions> {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void innerSign(CadesSignatureOptions object) throws CapiException {
        InputStream inputStream = null;
        try {
            inputStream = object.getDetachedContent() != null ? object.getDetachedContent().getInputAsNewStream() : object.getInput().getInputAsNewStream();
            OutputStream outputStream = object.getOutput().getAsOutputStream();
            object = this.a((CadesSignatureOptions)((Object)object), null, false, false);
            ((a)object).a(inputStream, outputStream, false);
            logger.debug("Signer added");
        }
        catch (CapiError capiError) {
            try {
                logger.debug(capiError.getMessage(), (Throwable)capiError);
                throw capiError.getCapiException();
                catch (CapiException capiException) {
                    logger.debug(capiException.getMessage(), (Throwable)capiException);
                    throw capiException;
                }
                catch (CMSAttributeTableGenerationException cMSAttributeTableGenerationException) {
                    object = cMSAttributeTableGenerationException;
                    if (cMSAttributeTableGenerationException.getCause() instanceof TSAException) {
                        throw (TSAException)object.getCause();
                    }
                    logger.debug(object.getMessage(), (Throwable)object);
                    throw new CapiException("Cades Generation Exception:" + object.getMessage(), 50040);
                }
                catch (Exception exception) {
                    logger.debug(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("Cades Generation Exception:" + exception.getMessage(), 50040);
                }
                catch (Error error) {
                    logger.debug(error.getMessage(), (Throwable)error);
                    throw new CapiException(error.getMessage(), 50040);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(inputStream);
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)inputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void innerAddSign(CadesSignatureOptions cadesSignatureOptions) throws CapiException {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        CacheOutputStream cacheOutputStream = null;
        try {
            DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            CMSSignedDataParser cMSSignedDataParser = new CMSSignedDataParser(digestCalculatorProvider, cadesSignatureOptions.getInput().getInputAsNewStream());
            Object object = cMSSignedDataParser.getSignedContent();
            if (object != null) {
                cacheOutputStream = new CacheOutputStream(64000);
                Streams.pipeAll((InputStream)object.getContentStream(), (OutputStream)cacheOutputStream);
                inputStream2 = cacheOutputStream.getCache();
            } else {
                if (cadesSignatureOptions.getDetachedContent() == null) {
                    logger.debug("no content found into envelope... is detached... but attached is required");
                    throw new CapiException("Envelope is detached", 50000);
                }
                inputStream2 = cadesSignatureOptions.getDetachedContent().getInputAsNewStream();
            }
            if (!Util.isNullOrEmpty((String)cadesSignatureOptions.getSignaturePath())) {
                LinkedList<OCSPResp> linkedList;
                LinkedList<BasicOCSPResp> linkedList2;
                X509Certificate[] x509CertificateArray;
                object = this.a(new CadesSignedDataProxy(cMSSignedDataParser), cadesSignatureOptions.getSignaturePath());
                if (object == null) {
                    throw new CapiException("Wrong signer path", 50010);
                }
                inputStream = ((CMSProcessableByteArray)((CadesSignedDataProxy)object).getSignedData().getSignedContent()).getInputStream();
                CMSSignedData cMSSignedData = ((a)(object = this.a(cadesSignatureOptions, (CadesSignedDataProxy)object, true, false))).a(inputStream, new ByteArrayOutputStream(), true);
                if (cMSSignedData == null) {
                    throw new CapiException("Unable to apply counter signature", 50010);
                }
                CadesSignedDataProxy cadesSignedDataProxy = new CadesSignedDataProxy(cMSSignedData);
                object = this.a(cadesSignatureOptions, new CadesSignedDataProxy(cMSSignedDataParser), false, true);
                SignerInformationStore signerInformationStore = this.a(cMSSignedData, cMSSignedDataParser.getSignerInfos(), cadesSignatureOptions.getSignaturePath());
                ((a)object).a(signerInformationStore);
                X509Certificate[] x509CertificateArray2 = x509CertificateArray = Certificate.getX509CertificatesFromStore((Store)cMSSignedData.getCertificates());
                int n = x509CertificateArray.length;
                for (int i = 0; i < n; ++i) {
                    X509Certificate x509Certificate = x509CertificateArray2[i];
                    ((a)object).a(x509Certificate);
                }
                LinkedList<CRL> linkedList3 = cadesSignedDataProxy.getCRLS();
                if (linkedList3 != null) {
                    for (CRL cRL : linkedList3) {
                        ((a)object).a(cRL);
                    }
                }
                if ((linkedList2 = cadesSignedDataProxy.getBasicOCSPResponses()) != null) {
                    for (BasicOCSPResp basicOCSPResp : linkedList2) {
                        ((a)object).a(basicOCSPResp);
                    }
                }
                if ((linkedList = cadesSignedDataProxy.getOCSPResponses()) != null) {
                    for (OCSPResp oCSPResp : linkedList) {
                        ((a)object).a(oCSPResp);
                    }
                }
                ((a)object).a(inputStream2, cadesSignatureOptions.getOutput().getAsOutputStream(), false);
            } else {
                object = this.a(cadesSignatureOptions, new CadesSignedDataProxy(cMSSignedDataParser), false, false);
                ((a)object).a(inputStream2, cadesSignatureOptions.getOutput().getAsOutputStream(), false);
            }
            logger.debug("Signer added");
        }
        catch (CapiError capiError) {
            try {
                logger.debug(capiError.getMessage(), (Throwable)capiError);
                throw capiError.getCapiException();
                catch (CapiException capiException) {
                    logger.debug(capiException.getMessage(), (Throwable)capiException);
                    throw capiException;
                }
                catch (CMSAttributeTableGenerationException cMSAttributeTableGenerationException) {
                    CMSAttributeTableGenerationException cMSAttributeTableGenerationException2 = cMSAttributeTableGenerationException;
                    if (cMSAttributeTableGenerationException.getCause() instanceof TSAException) {
                        throw (TSAException)cMSAttributeTableGenerationException2.getCause();
                    }
                    logger.debug(cMSAttributeTableGenerationException2.getMessage(), (Throwable)cMSAttributeTableGenerationException2);
                    throw new CapiException("Cades Generation Exception:" + cMSAttributeTableGenerationException2.getMessage(), 50040);
                }
                catch (Exception exception) {
                    logger.debug(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("Cades generation Exception:" + exception.getMessage(), 50040);
                }
                catch (Error error) {
                    logger.debug(error.getMessage(), (Throwable)error);
                    throw new CapiException(error.getMessage(), 50040);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(cacheOutputStream);
                Util.closeQuietly(inputStream);
                Util.closeQuietly(inputStream2);
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)cacheOutputStream);
        Util.closeQuietly((Closeable)inputStream);
        Util.closeQuietly((Closeable)inputStream2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void innerUpdateSign(CadesSignatureOptions cadesSignatureOptions) throws CapiException {
        InputStream inputStream = null;
        CacheOutputStream cacheOutputStream = null;
        try {
            Object object = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            object = new CMSSignedDataParser(object, cadesSignatureOptions.getInput().getInputAsNewStream());
            Object object2 = object.getSignedContent();
            if (object2 != null) {
                cacheOutputStream = new CacheOutputStream(64000);
                Streams.pipeAll((InputStream)object2.getContentStream(), (OutputStream)cacheOutputStream);
                inputStream = cacheOutputStream.getCache();
            } else {
                if (cadesSignatureOptions.getDetachedContent() == null) {
                    logger.debug("no content found into envelope... is detached... but attached is required");
                    throw new CapiException("Envelope is detached", 50000);
                }
                inputStream = cadesSignatureOptions.getDetachedContent().getInputAsNewStream();
            }
            object2 = new CadesSignedDataProxy((CMSSignedDataParser)object);
            a a2 = this.a(cadesSignatureOptions, (CadesSignedDataProxy)object2, false, true);
            object2 = ((CadesSignedDataProxy)object2).getCertificates();
            CadesSignatureOptions cadesSignatureOptions2 = cadesSignatureOptions;
            LTResourceResolver lTResourceResolver = this.getLTResourceResolver(cadesSignatureOptions2, cadesSignatureOptions2.isResolveCertificateChainResources());
            object = new CadesSignatureUpdater(cadesSignatureOptions, (CMSSignedDataParser)object, a2, (LinkedList<X509Certificate>)object2, lTResourceResolver);
            object.a();
            a2.a(inputStream, cadesSignatureOptions.getOutput().getAsOutputStream(), false);
            logger.debug("Signature updated");
        }
        catch (CapiError capiError) {
            try {
                logger.debug(capiError.getMessage(), (Throwable)capiError);
                throw capiError.getCapiException();
                catch (CapiException capiException) {
                    logger.debug(capiException.getMessage(), (Throwable)capiException);
                    throw capiException;
                }
                catch (CMSAttributeTableGenerationException cMSAttributeTableGenerationException) {
                    CMSAttributeTableGenerationException cMSAttributeTableGenerationException2 = cMSAttributeTableGenerationException;
                    if (cMSAttributeTableGenerationException.getCause() instanceof TSAException) {
                        throw (TSAException)cMSAttributeTableGenerationException2.getCause();
                    }
                    logger.debug(cMSAttributeTableGenerationException2.getMessage(), (Throwable)cMSAttributeTableGenerationException2);
                    throw new CapiException("Cades Generation Exception:" + cMSAttributeTableGenerationException2.getMessage(), 50040);
                }
                catch (Exception exception) {
                    logger.debug(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("Cades generation Exception:" + exception.getMessage(), 50040);
                }
                catch (Error error) {
                    logger.debug(error.getMessage(), (Throwable)error);
                    throw new CapiException(error.getMessage(), 50040);
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(cacheOutputStream);
                Util.closeQuietly(inputStream);
                throw throwable;
            }
        }
        Util.closeQuietly((Closeable)cacheOutputStream);
        Util.closeQuietly((Closeable)inputStream);
    }

    private SignerInformationStore a(CMSSignedData cMSSignedData, SignerInformationStore object, String string) throws CMSException, CapiException, OperatorCreationException, CertificateEncodingException {
        if (string != null && !string.equals("")) {
            String[] stringArray = string.split(":");
            object = object.getSigners();
            object = new LinkedList(object);
            int n = string.indexOf(58);
            if (n != -1) {
                SignerInformation signerInformation = (SignerInformation)((LinkedList)object).get(Integer.parseInt(stringArray[0]));
                Object object2 = signerInformation.getUnsignedAttributes();
                SignerInformationStore signerInformationStore = this.a(cMSSignedData, signerInformation.getCounterSignatures(), string.substring(n + 1));
                if (object2 != null) {
                    logger.debug("replacing CS attribute... ");
                    object2 = object2.toHashtable();
                    object2.remove(CMSAttributes.counterSignature);
                    object2 = new AttributeTable((Hashtable)object2);
                    cMSSignedData = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)object2);
                    signerInformation = cMSSignedData;
                }
                signerInformation = SignerInformation.addCounterSigners((SignerInformation)signerInformation, (SignerInformationStore)signerInformationStore);
                ((LinkedList)object).set(Integer.parseInt(stringArray[0]), signerInformation);
                return new SignerInformationStore((Collection)object);
            }
            SignerInformation signerInformation = (SignerInformation)((LinkedList)object).get(Integer.parseInt(string));
            AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
            if (attributeTable != null) {
                logger.debug("replacing CS attribute... ");
                Hashtable hashtable = attributeTable.toHashtable();
                hashtable.remove(CMSAttributes.counterSignature);
                attributeTable = new AttributeTable(hashtable);
                attributeTable = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)attributeTable);
                signerInformation = attributeTable;
            }
            signerInformation = SignerInformation.addCounterSigners((SignerInformation)signerInformation, (SignerInformationStore)cMSSignedData.getSignerInfos());
            ((LinkedList)object).set(Integer.parseInt(string), signerInformation);
            return new SignerInformationStore((Collection)object);
        }
        return null;
    }

    private a a(CadesSignatureOptions cadesSignatureOptions, CadesSignedDataProxy object, boolean bl, boolean bl2) throws CapiException, OperatorCreationException, CertificateEncodingException, SignatureException, CMSException, CertificateException {
        try {
            object = new a(cadesSignatureOptions, bl, (CadesSignedDataProxy)object, bl2);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error: " + exception.getMessage(), 1003, (Throwable)exception);
        }
        if (bl2) {
            return object;
        }
        X509Certificate x509Certificate = this.retrieveCert(cadesSignatureOptions);
        PrivateKey privateKey = this.retrieveKey(cadesSignatureOptions);
        Provider provider = this.retrieveProvider(cadesSignatureOptions);
        try {
            ((a)object).a(x509Certificate);
            logger.debug("Adding signer OK");
        }
        catch (IOException | CertificateEncodingException | CMSException throwable) {
            logger.error(throwable.getMessage(), throwable);
            throw new CapiException("Internal error: " + throwable.getMessage(), 1003, throwable);
        }
        logger.debug("Pkcs7addSigner ...");
        String string = SignUtils.algoByKeyAndDigest((PrivateKey)privateKey, (DigestAlgorithm)cadesSignatureOptions.getDigestAlgorithm()).getJavaName();
        boolean bl3 = new Certificate(x509Certificate.getEncoded()).isRsVerified();
        privateKey = bl3 ? new VerRsContentSignerBuilder(string).setProvider(provider).build(privateKey) : new JcaContentSignerBuilder(string).setProvider(provider).build(privateKey);
        provider = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
        CadesSignatureOptions cadesSignatureOptions2 = cadesSignatureOptions;
        string = this.getLTResourceResolver(cadesSignatureOptions2, cadesSignatureOptions2.isResolveCertificateChainResources());
        provider = new JcaSignerInfoGeneratorBuilder((DigestCalculatorProvider)provider);
        provider.setSignedAttributeGenerator(new CadesSignedAttributeGenerator(cadesSignatureOptions, x509Certificate));
        provider.setUnsignedAttributeGenerator(new CadesUnSignedAttributeGenerator((LTResourceResolver)string, cadesSignatureOptions, (a)object, x509Certificate, bl3));
        cadesSignatureOptions = provider.build((ContentSigner)privateKey, x509Certificate);
        if (bl3) {
            ((a)object).a(new VerRsSignerInfoGenerator((SignerInfoGenerator)cadesSignatureOptions));
        } else {
            ((a)object).a((SignerInfoGenerator)cadesSignatureOptions);
        }
        logger.debug("Pkcs7 generating...");
        return object;
    }

    private CadesSignedDataProxy a(CadesSignedDataProxy cadesSignedDataProxy, String string) throws CMSException, CertificateEncodingException, IOException, Exception {
        while (string != null && !string.equals("")) {
            LinkedList linkedList = cadesSignedDataProxy.getSignerInfos().getSigners();
            linkedList = new LinkedList(linkedList);
            String[] stringArray = string.split(":");
            int n = string.indexOf(58);
            if (n != -1) {
                cadesSignedDataProxy = CadesSignatureGenerator.a(cadesSignedDataProxy, (SignerInformation)linkedList.get(Integer.parseInt(stringArray[0])));
                string = string.substring(n + 1);
                continue;
            }
            return CadesSignatureGenerator.a(cadesSignedDataProxy, (SignerInformation)linkedList.get(Integer.parseInt(string)));
        }
        return null;
    }

    private static CadesSignedDataProxy a(CadesSignedDataProxy object, SignerInformation signerInformation) throws CMSException, CertificateEncodingException, OperatorCreationException, IOException, Exception {
        CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
        CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(signerInformation.getSignature());
        signerInformation = signerInformation.getCounterSignatures();
        Object object2 = ((CadesSignedDataProxy)object).getCertificates();
        object = ((CadesSignedDataProxy)object).getCRLS();
        if (signerInformation == null || signerInformation.size() == 0) {
            object = cMSSignedDataGenerator.generate((CMSTypedData)cMSProcessableByteArray, true);
        } else {
            object2 = new JcaCertStore(object2);
            object = new JcaCRLStore((Collection)object);
            cMSSignedDataGenerator.addCertificates((Store)object2);
            cMSSignedDataGenerator.addCRLs((Store)object);
            cMSSignedDataGenerator.addSigners((SignerInformationStore)signerInformation);
            object = cMSSignedDataGenerator.generate((CMSTypedData)cMSProcessableByteArray, true);
        }
        object2 = new CadesSignedDataProxy((CMSSignedData)object);
        return object2;
    }
}

