/*
 * Decompiled with CFR 0.152.
 */
package esecurity.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.rest.RestRequest;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.Logger;

public class BodyRequest
extends RestRequest {
    public BodyRequest(UrlClient client, String url, Logger logger) {
        super(client, url, "POST", logger);
    }

    public BodyRequest body(Object obj, String contentType) {
        if (contentType == null || !contentType.equals("application/json")) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        byte[] request_byte = null;
        try {
            request_byte = mapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Could not transofrm to Json : " + e.getMessage(), (Throwable)e);
            return null;
        }
        return this.body(request_byte, contentType);
    }

    public BodyRequest body(InputStream is, String contentType) {
        this.contentType = contentType;
        this.body_content = is;
        return this;
    }

    public BodyRequest body(byte[] content, String contentType) {
        this.contentType = contentType;
        this.body_content = new ByteArrayInputStream(content);
        return this;
    }

    public BodyRequest body(InputStream is) {
        return this.body(is, "octect/stream");
    }

    public BodyRequest body(byte[] content) {
        return this.body(content, "octect/stream");
    }

    public BodyRequest auth(URLCredentials cred) {
        this.cred = cred;
        return this;
    }
}

