/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.utils;

import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.naming.OperationNotSupportedException;
import org.slf4j.Logger;

public class ASiCCommonUtils {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static final String getExtensionForFormat(ASiCFormat aSiCFormat) {
        switch (aSiCFormat) {
            case SIMPLE: {
                return ".asics";
            }
            case EXTENDED: {
                return ".asice";
            }
        }
        a.error("Unable to find file extension for format '" + aSiCFormat.toString() + "'.");
        return null;
    }

    public static final String getMimeTypeForFormat(ASiCFormat aSiCFormat) {
        switch (aSiCFormat) {
            case SIMPLE: {
                return "application/vnd.etsi.asic-s+zip";
            }
            case EXTENDED: {
                return "application/vnd.etsi.asic-e+zip";
            }
        }
        a.error("Unable to find MIME type for format '" + aSiCFormat.toString() + "'.");
        return null;
    }

    public static final String getExtensionShortForFormat(ASiCFormat aSiCFormat) {
        switch (aSiCFormat) {
            case SIMPLE: {
                return ".scs";
            }
            case EXTENDED: {
                return ".sce";
            }
        }
        a.error("Unable to find file extension for format '" + aSiCFormat.toString() + "'.");
        return null;
    }

    public static final String getFilePath(ASiCFormat object, String string, String string2) {
        string = string.endsWith(File.separator) ? string : string + File.separator;
        object = new File(string + string2 + ASiCCommonUtils.getExtensionForFormat(object));
        return ((File)object).getAbsolutePath();
    }

    public static void throwExceptionIfUnsupportedGetSignature(ASiCSignatureType aSiCSignatureType, ASiCSignatureType aSiCSignatureType2) throws OperationNotSupportedException {
        if (aSiCSignatureType != aSiCSignatureType2) {
            throw new OperationNotSupportedException("Unable to get " + (Object)((Object)aSiCSignatureType2) + " signature on a " + (Object)((Object)aSiCSignatureType) + " ASiC container!");
        }
    }

    public static boolean isValidManifestFilename(String string) {
        return string.matches("META-INF/ASiCManifest.*[.]xml") || string.equals("META-INF/manifest.xml");
    }

    public static boolean isValidSignatureFilename(String string, ASiCFormat aSiCFormat) {
        block3: {
            block2: {
                ASiCFormat aSiCFormat2 = aSiCFormat;
                String string2 = string;
                if (ASiCFormat.SIMPLE.equals((Object)aSiCFormat2) && (string2.equals("META-INF/signature.p7s") || string2.equals("META-INF/signatures.xml") || string2.equals("META-INF/timestamp.tst"))) break block2;
                aSiCFormat2 = aSiCFormat;
                string2 = string;
                if (!(ASiCFormat.EXTENDED.equals((Object)aSiCFormat2) && (string2.matches("META-INF/.*signature.*[.]p7s") || string2.matches("META-INF/.*signatures.*[.]xml") || string2.matches("META-INF/.*timestamp.*[.]tst")))) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ASiCFormat getFormatFromMime(InputHandler object) throws IOException, CapiException {
        try {
            block22: {
                Object object2;
                Object object3;
                Throwable throwable;
                block21: {
                    object = new ZipInputStream(new BufferedInputStream(object.getInputAsNewStream()));
                    throwable = null;
                    object3 = "";
                    boolean bl = false;
                    while ((object2 = ((ZipInputStream)object).getNextEntry()) != null && !bl) {
                        if (!((ZipEntry)object2).getName().equals("mimetype")) continue;
                        bl = true;
                        try {
                            object2 = new ByteArrayOutputStream();
                            Throwable throwable2 = null;
                            try {
                                int n;
                                object3 = new byte[4096];
                                while ((n = ((FilterInputStream)object).read((byte[])object3)) > 0) {
                                    ((ByteArrayOutputStream)object2).write((byte[])object3, 0, n);
                                }
                                object3 = new String(((ByteArrayOutputStream)object2).toByteArray());
                            }
                            catch (Throwable throwable3) {
                                try {
                                    object3 = throwable3;
                                    throwable2 = throwable3;
                                    throw object3;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        ((ByteArrayOutputStream)object2).close();
                                        throw throwable4;
                                    }
                                    try {
                                        ((ByteArrayOutputStream)object2).close();
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                }
                            }
                            ((ByteArrayOutputStream)object2).close();
                        }
                        catch (IOException iOException) {
                            object2 = iOException;
                            throw iOException;
                        }
                    }
                    if (!"application/vnd.etsi.asic-s+zip".equals(object3)) break block21;
                    object2 = ASiCFormat.SIMPLE;
                    ((ZipInputStream)object).close();
                    return object2;
                }
                try {
                    if (!"application/vnd.etsi.asic-e+zip".equals(object3)) break block22;
                    object2 = ASiCFormat.EXTENDED;
                }
                catch (Throwable throwable6) {
                    try {
                        object2 = throwable6;
                        throwable = throwable6;
                        throw object2;
                    }
                    catch (Throwable throwable7) {
                        if (throwable == null) {
                            ((ZipInputStream)object).close();
                            throw throwable7;
                        }
                        try {
                            ((ZipInputStream)object).close();
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                            throw throwable7;
                        }
                    }
                }
                ((ZipInputStream)object).close();
                return object2;
            }
            ((ZipInputStream)object).close();
            throw new CapiException("ASiC format should be specified in mimetype or file extension.", 50023);
        }
        catch (Throwable throwable) {
            a.error("ASIC/Zip decoding error", throwable);
            throw new CapiException("ASiC format should be specified in mimetype or file extension.", 50023);
        }
    }
}

