/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.JsUtils;
import esecurity.desktop.View;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.TableBodyCell;
import esecurity.desktop.dom.TableRow;
import java.util.ArrayList;
import java.util.List;

public class TableBody
extends DOMElement {
    private List<TableRow> rows = new ArrayList<TableRow>();

    public TableBody(String id, String parentId, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("tbody", id, parentId);
    }

    public TableBody(String id, DOMElement parent, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("tbody", id, parent.getId());
    }

    public void addRow(TableRow row) {
        this.rows.add(row);
    }

    public List<TableRow> getRows() {
        return this.rows;
    }

    public TableBodyCell getCell(int row, int column) {
        if (row >= this.rows.size()) {
            return null;
        }
        TableRow tableRow = this.rows.get(row);
        if (column >= tableRow.getCells().size()) {
            return null;
        }
        return (TableBodyCell)tableRow.getCells().get(column);
    }

    public void removeRow(int index) {
        TableRow row = this.rows.remove(index);
        if (row != null) {
            row.delete();
        }
    }

    public void removeRow(String rowId) {
        boolean found = false;
        for (int i = 0; !found && i < this.rows.size(); ++i) {
            if (!this.rows.get((int)i).id.equals(rowId)) continue;
            this.rows.remove(i).delete();
            found = true;
        }
    }

    public void empty() {
        for (TableRow row : this.rows) {
            row.delete();
        }
        this.rows.clear();
    }
}

