/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.mc;

import org.sqlite.mc.SQLiteMCConfig;

public class SQLiteMCSqlCipherConfig
extends SQLiteMCConfig.Builder {
    public SQLiteMCSqlCipherConfig() {
        this.setCipher(SQLiteMCConfig.CipherAlgorithm.SQL_CIPHER);
    }

    @Override
    public SQLiteMCSqlCipherConfig setLegacy(int value) {
        assert (this.isValid(value, 0, 4));
        super.setLegacy(value);
        return this;
    }

    @Override
    public SQLiteMCSqlCipherConfig setLegacyPageSize(int value) {
        assert (this.isValid(value, 0, 65536));
        super.setLegacyPageSize(value);
        return this;
    }

    @Override
    public SQLiteMCSqlCipherConfig setKdfIter(int value) {
        assert (this.isValid(value, 1, Integer.MAX_VALUE));
        super.setKdfIter(value);
        return this;
    }

    @Override
    public SQLiteMCSqlCipherConfig setFastKdfIter(int value) {
        assert (this.isValid(value, 1, Integer.MAX_VALUE));
        super.setFastKdfIter(value);
        return this;
    }

    @Override
    public SQLiteMCSqlCipherConfig setHmacUse(boolean value) {
        super.setHmacUse(value);
        return this;
    }

    @Override
    public SQLiteMCSqlCipherConfig setHmacPgno(SQLiteMCConfig.HmacPgno value) {
        assert (this.isValid(value.ordinal(), 0, 2));
        super.setHmacPgno(value);
        return this;
    }

    @Override
    public SQLiteMCSqlCipherConfig setHmacSaltMask(int value) {
        assert (this.isValid(value, 0, 255));
        super.setHmacSaltMask(value);
        return this;
    }

    @Override
    public SQLiteMCSqlCipherConfig setKdfAlgorithm(SQLiteMCConfig.KdfAlgorithm value) {
        assert (this.isValid(value.ordinal(), 0, 2));
        super.setKdfAlgorithm(value);
        return this;
    }

    @Override
    public SQLiteMCSqlCipherConfig setHmacAlgorithm(SQLiteMCConfig.HmacAlgorithm value) {
        assert (this.isValid(value.ordinal(), 0, 2));
        super.setHmacAlgorithm(value);
        return this;
    }

    @Override
    public SQLiteMCSqlCipherConfig setPlaintextHeaderSize(int value) {
        assert (this.isValid(value, 0, 100));
        assert (value % 16 == 0);
        super.setPlaintextHeaderSize(value);
        return this;
    }

    public static SQLiteMCSqlCipherConfig getDefault() {
        return new SQLiteMCSqlCipherConfig();
    }

    public static SQLiteMCSqlCipherConfig getV1Defaults() {
        SQLiteMCSqlCipherConfig config = new SQLiteMCSqlCipherConfig();
        config.setKdfIter(4000);
        config.setFastKdfIter(2);
        config.setHmacUse(false);
        config.setLegacy(1);
        config.setLegacyPageSize(1024);
        config.setKdfAlgorithm(SQLiteMCConfig.KdfAlgorithm.SHA1);
        config.setHmacAlgorithm(SQLiteMCConfig.HmacAlgorithm.SHA1);
        return config;
    }

    public static SQLiteMCSqlCipherConfig getV2Defaults() {
        SQLiteMCSqlCipherConfig config = new SQLiteMCSqlCipherConfig();
        config.setKdfIter(4000);
        config.setFastKdfIter(2);
        config.setHmacUse(true);
        config.setHmacPgno(SQLiteMCConfig.HmacPgno.LITTLE_ENDIAN);
        config.setHmacSaltMask(58);
        config.setLegacy(2);
        config.setLegacyPageSize(1024);
        config.setKdfAlgorithm(SQLiteMCConfig.KdfAlgorithm.SHA1);
        config.setHmacAlgorithm(SQLiteMCConfig.HmacAlgorithm.SHA1);
        return config;
    }

    public static SQLiteMCSqlCipherConfig getV3Defaults() {
        SQLiteMCSqlCipherConfig config = new SQLiteMCSqlCipherConfig();
        config.setKdfIter(64000);
        config.setFastKdfIter(2);
        config.setHmacUse(true);
        config.setHmacPgno(SQLiteMCConfig.HmacPgno.LITTLE_ENDIAN);
        config.setHmacSaltMask(58);
        config.setLegacy(3);
        config.setLegacyPageSize(1024);
        config.setKdfAlgorithm(SQLiteMCConfig.KdfAlgorithm.SHA1);
        config.setHmacAlgorithm(SQLiteMCConfig.HmacAlgorithm.SHA1);
        return config;
    }

    public static SQLiteMCSqlCipherConfig getV4Defaults() {
        SQLiteMCSqlCipherConfig config = new SQLiteMCSqlCipherConfig();
        config.setKdfIter(256000);
        config.setFastKdfIter(2);
        config.setHmacUse(true);
        config.setHmacPgno(SQLiteMCConfig.HmacPgno.LITTLE_ENDIAN);
        config.setHmacSaltMask(58);
        config.setLegacy(4);
        config.setLegacyPageSize(4096);
        config.setKdfAlgorithm(SQLiteMCConfig.KdfAlgorithm.SHA512);
        config.setHmacAlgorithm(SQLiteMCConfig.HmacAlgorithm.SHA512);
        config.setPlaintextHeaderSize(0);
        return config;
    }
}

