/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.signature.tableview;

import esecurity.crypto.gui.functionality.SignatureFacade;
import esecurity.crypto.gui.model.FileToSign;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.crypto.gui.signature.models.FilesToSignHandler;
import esecurity.crypto.gui.signature.tableview.hgbuinzg;
import esecurity.crypto.gui.signature.tableview.iclyasmt;
import esecurity.crypto.gui.signature.tableview.mzzpvrfg;
import esecurity.crypto.gui.signature.tableview.yxtospkn;
import esecurity.crypto.gui.utils.guielements.CGTooltip;
import esecurity.desktop.BaseController;
import esecurity.desktop.DOMEvent;
import esecurity.desktop.InternalController;
import esecurity.desktop.View;
import esecurity.desktop.annotation.JSFunction;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.DivContainer;
import esecurity.desktop.dom.Image;
import esecurity.desktop.dom.Paragraph;
import esecurity.desktop.dom.SpanContainer;
import esecurity.desktop.dom.TextInput;
import esecurity.desktop.dom.TimedMessage;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FilesToSignTable {
    private static final EllipsLogger LOGGER = FilesToSignTable.Lj("-o24pjp", Constants.CAPI_LOGGER_NAME);
    private static final I18N i18n;
    private static final String TRASH_IMG;
    private static final String TRASH_HOVER_IMG;
    private static final String ARROW_IMG;
    private final DOMElement parent;
    private final View view;
    private final String onEmptyText;
    private Runnable onEmpty = null;
    private String destinationFileExtension;
    private SignatureFacade.SignatureType signatureType;
    private TimedMessage message;
    private DivContainer tableBody;
    private DivContainer tableBodyContent;
    private DivContainer tableBodyContentContainer;
    private DivContainer emptyTextDummy;
    private DivContainer emptyText;
    private DivContainer fileToSignColumn;
    private DivContainer signedFileColumn;
    private DivContainer asicEFileColumn;
    private final List<Paragraph> fileExtensionList;
    private final List<Thread> iconLoaders;
    private final Map<String, FileToSign> filesToSignNameMap;
    private boolean applyTsd;
    private FilesToSignHandler filesToSignHandler;

    public FilesToSignTable(DOMElement parent, String onEmptyText, BaseController mainController, View view) {
        char[] cArray = "\ud782\ucd15\ua59f\ub7cf\u4609".toCharArray();
        cArray[3] = (char)(cArray[3] ^ 0x40D0);
        this.destinationFileExtension = yxtospkn.f(cArray, (short)8989, (byte)2, (short)1);
        this.signatureType = SignatureFacade.SignatureType.CADES;
        this.fileExtensionList = new ArrayList<Paragraph>();
        this.iconLoaders = new ArrayList<Thread>();
        this.filesToSignNameMap = new HashMap<String, FileToSign>();
        this.applyTsd = false;
        this.filesToSignHandler = FilesToSignTable.Lj("-1t0epg5");
        this.parent = parent;
        this.view = view;
        this.onEmptyText = onEmptyText;
        this.createTable();
        FileToSignTableController tableController = new FileToSignTableController(mainController, view);
    }

    public void onEmpty(Runnable onEmpty) {
        this.onEmpty = onEmpty;
    }

    public void setSignatureType(SignatureFacade.SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    public void setApplyTsd(boolean apply) {
        this.applyTsd = apply;
    }

    private void createTable() {
        char[] cArray = "\u202b\ub0e4\u6fea\ue23e\u45ca\u8b10\u3356\u4ada\uc65c\u862e\ud134\u809b\uf7bb\u054f\udac2\u386b\u296c\u98bc\ua04b\u33f0\u5b23\u3cbe\u5e45".toCharArray();
        cArray[14] = (char)(cArray[14] ^ 0x7E6A);
        this.message = new TimedMessage(yxtospkn.f(cArray, (short)32743, (byte)5, (short)0), this.parent, this.view, null);
        FilesToSignTable.Lj("-q76rtt", this.message, (int)(FilesToSignTable.Lj("d8542h", this.view) / 2 - 125), (int)(FilesToSignTable.Lj("1l0p422", this.view) / 2 - 35));
        FilesToSignTable.Lj("-4gpg4", this.message, 3000);
        char[] cArray2 = "\ucd68\u5bc9\u5160\u01fa\u78d6\udcff\uc11c\u8093\u3b62\uc4f9\ubb99\uc475\u84ff\u27c8\u9478\uc1b9\u61f6\u4c2b\uff6a\u2c6d\u48d9\uecce\ub39d\uc6d8\u3d9f\uf887\u4d6e\ud375\u3fa6\u42d5\ub36e\u5884\u1a13\u2cee\u2e6d\u0952\u5b78".toCharArray();
        cArray2[15] = (char)(cArray2[15] ^ 0x3AEF);
        FilesToSignTable.Lj("-1834pgb", this.message, yxtospkn.f(cArray2, (short)19139, (byte)1, (short)1));
        char[] cArray3 = "\ufc03\u8b25\u13c5\ue448\u5b21\u62e4\u08e1\uaf22\u8fb3\ua876\u9419\u933c\ud780\u1da2\uf092\u5b6c".toCharArray();
        cArray3[12] = (char)(cArray3[12] ^ 0x1273);
        Image messageImg = new Image(yxtospkn.f(cArray3, (short)5320, (byte)1, (short)0), (DOMElement)this.message, this.view);
        char[] cArray4 = "\ucfd4\u6301\ub9a7\ub92f\u805b\ufbc6\u227b\ue082\u8d65\u52b1\u53f9\u5075\uae48\ubedd\u9ca3\u53bc".toCharArray();
        cArray4[0] = (char)(cArray4[0] ^ 0x24DC);
        FilesToSignTable.Lj("sdp6fn", messageImg, FilesToSignTable.Lj("55j6fm", yxtospkn.f(cArray4, (short)11692, (byte)2, (short)2)));
        char[] cArray5 = "\ub56f\uce48\u26bf\u456f\u9c4d\u6085\ucda5\u9d3b\ue24d\u98cf\u9c30\ue24f\u902a\ub261\ued30\uce69\u6ffb".toCharArray();
        cArray5[14] = (char)(cArray5[14] ^ 0x2538);
        FilesToSignTable.Lj("-1vg2pg8", messageImg, yxtospkn.f(cArray5, (short)13590, (byte)2, (short)5));
        char[] cArray6 = "\u12cc\u07dd\u374c\u0aaf\ubee0\uf454\uc999\u757f\u7526\u3e03\u9f67\u97d3\u9ce3\u2e1a\u26e5\u8245\uadec\u2ad5\u58bc".toCharArray();
        cArray6[15] = (char)(cArray6[15] ^ 0x3ECD);
        DivContainer tableHead = new DivContainer(yxtospkn.f(cArray6, (short)23486, (byte)1, (short)0), this.parent, this.view);
        char[] cArray7 = "\u3c9e\u00b3\u1050\uf6df\u69f1\u8b8c\u2f09\u1e8c\u8c1c\udf81\ue397\udc30\u6698\u6069".toCharArray();
        cArray7[4] = (char)(cArray7[4] ^ 0xB83);
        FilesToSignTable.Lj("nhp6c1", tableHead, yxtospkn.f(cArray7, (short)32035, (byte)4, (short)1));
        char[] cArray8 = "\uf7e9\uddb4\u6d8b\u5bf5\u2e01\u91f3\u69af\u135e\u072c\u0339\u3734\ud4a6\u48af\u575c\ubff2\udeba\u2a56\u5d95\ue040\ue9c8\u605d\u4975\u8995\u3e34\ub513\u7755\u85bc\ub8bd\u3a78".toCharArray();
        cArray8[7] = (char)(cArray8[7] ^ 0x4359);
        DivContainer tableHeadContainer = new DivContainer(yxtospkn.f(cArray8, (short)14780, (byte)1, (short)0), (DOMElement)tableHead, this.view);
        char[] cArray9 = "\uda28\ucfd0\u179c\ueab2\uac5f\u7e97\ua7d7\udb04\u1ecc\ua048\uef59\u45f0\u5332\ubf46\u25a1\u23a2\ue19e\u6f06\u7353\ua09e\u0c0e\ub3a4\u47d7\u4628".toCharArray();
        cArray9[12] = (char)(cArray9[12] ^ 0x2897);
        FilesToSignTable.Lj("nhp6c1", tableHeadContainer, yxtospkn.f(cArray9, (short)24585, (byte)4, (short)1));
        char[] cArray10 = "\u8945\u6fa7\u8c4f\uc219\uabcf\ue8a1\ua1e3\u6892\uea5e\ud841\u89ab\u3a2d\u4ad6\u16d2\u12df\ue8ed\uefe6\uf564\ufcdf\u39ae\u8d20\u066f\u473d\u8e5d\u95c0\u4ec6\ua47b\uf6e4\u77f7\u644e\udb4c\u1352".toCharArray();
        cArray10[11] = (char)(cArray10[11] ^ 0x51B7);
        DivContainer documentsHeadCell = new DivContainer(yxtospkn.f(cArray10, (short)17568, (byte)0, (short)0), (DOMElement)tableHeadContainer, this.view);
        char[] cArray11 = "\ufc19\u13ea\u612f\ueb5f\u4afb\u4782\uebf1\u1884\u16f8\u7d04\uc6be\uffa3\u359a\ua71b\u6215\uee63\u21e10".toCharArray();
        cArray11[12] = (char)(cArray11[12] ^ 0x64B3);
        FilesToSignTable.Lj("nhp6c1", documentsHeadCell, yxtospkn.f(cArray11, (short)8306, (byte)0, (short)3));
        char[] cArray12 = "\u93eb\u691e\u5ba0\u0d74\u1c14\uf535\u4f6a\u0e9a\ua788\u651c\u0ab2\uf46f\u8404\u0c84\u7c7b\ub1d0\u4029\ufb88\u8c06\u5b9a\uba31\u049a".toCharArray();
        cArray12[8] = (char)(cArray12[8] ^ 0x5D16);
        FilesToSignTable.Lj("nhp6c1", documentsHeadCell, yxtospkn.f(cArray12, (short)19907, (byte)1, (short)4));
        char[] cArray13 = "\ue263\u7c9b\uda65\ud45d\u9ee9\u82ea\u6543\u3b0d\u7fad\u7a84\uf53a\u8591\u7b7a\u3843\uf801\u9ea7\u19eb\u1657\uc53e\u98a4\ue42e\uca9f\u75ab\u9f84\u8f87\u4fbc\uc0b0\u47fd\u0cfd\u619d\u7857\ucd39\ud1b4\u190e\uf0fd\u14f0\uc798\uc1dd\ufb13\u41c1\u560e\u47e8\u0e17\u7fcd\ubfc5\ue427\u120e\u45fb\u6824\u237f\u8ad3\u6a9a".toCharArray();
        cArray13[3] = (char)(cArray13[3] ^ 0x22B2);
        FilesToSignTable.Lj("-1ldapge", documentsHeadCell, FilesToSignTable.Lj("qef41t", i18n, yxtospkn.f(cArray13, (short)23439, (byte)3, (short)5), (Object[])new Object[0]));
        char[] cArray14 = "\u024a\u2283\uc417\u3214\u6b97\u841e\u4d74\u0257\u99df\u60fc\ucaf2\ue1b3\u989d\u1cdc\ue488\udb7c\u0952\uc9d9\u1983\u677e\u7efc\u603e\ubff3\u2436\uc8cf\ub28c\u4641\u60f3\u31ce".toCharArray();
        cArray14[27] = (char)(cArray14[27] ^ 0x15AE);
        DivContainer outputHeadCell = new DivContainer(yxtospkn.f(cArray14, (short)6391, (byte)2, (short)0), (DOMElement)tableHeadContainer, this.view);
        char[] cArray15 = "\u1f96\u9644\ue856\ue092\u2f20\ufdfa\u7699\uad3a\u061d\u21d8\u4334\u38cc\u8d5b\u9d89\u99c1\uc135\ud9d0\u4ad1".toCharArray();
        cArray15[2] = (char)(cArray15[2] ^ 0x366D);
        FilesToSignTable.Lj("nhp6c1", outputHeadCell, yxtospkn.f(cArray15, (short)31604, (byte)4, (short)1));
        char[] cArray16 = "\u3aff\u6f1c\u9d9e\u9437\uc64a\u00f5\u083f\ua9e3\uab06\u2eba\u0218\ua2b6\u1dc7\u1bbb\u922c\ua19d\u61e1\u2db0\uc03e\u10b9\ub570\u0f66\u1bb2\u8816\uc0d3\u6e60\u62f6\u9ca4\ud52e\u94f0\uf78e\u6dd7\u4f19\ud073\u653a\uf3d8\u8800\uef13\ub64b\uc4f7\u4a54\ud387\ua876\u3af7\u0b6b\ue2db\u50a9\u726a\uc357\u73fa".toCharArray();
        cArray16[29] = (char)(cArray16[29] ^ 0x3E1E);
        FilesToSignTable.Lj("-1ldapge", outputHeadCell, FilesToSignTable.Lj("qef41t", i18n, yxtospkn.f(cArray16, (short)6549, (byte)1, (short)5), (Object[])new Object[0]));
        char[] cArray17 = "\uacbe\u410e\ue836\u6702\u4e92\ue6ed\u35ce\u9279\ubb8b\uf98c\u9f8b\ue837\uf5a6\u61bd\u53c1\u7565\u99df\ube9e\u0ed8".toCharArray();
        cArray17[2] = (char)(cArray17[2] ^ 0x1910);
        this.tableBody = new DivContainer(yxtospkn.f(cArray17, (short)25261, (byte)1, (short)1), this.parent, this.view);
        char[] cArray18 = "\ub4db\u9e6c\u4027\u6c4a\u5dc9\udb83\u1013\u0def\ufa9d\u94d4\u5ae4\u019b\ued47\u240d\u7e55\ufdc6\ud950\udbe8\u360d".toCharArray();
        cArray18[1] = (char)(cArray18[1] ^ 0x6015);
        FilesToSignTable.Lj("nhp6c1", this.tableBody, yxtospkn.f(cArray18, (short)16532, (byte)3, (short)2));
        char[] cArray19 = "\u4d23\u2d5e\u3e41\uab80\ufd61\u91e1\u6c1a\ub06d\ubf56\u51a0\uacec\u358b\ufb60\ue02e\u11ac\uca64\u428d\u9480\ud99d\u265f".toCharArray();
        cArray19[3] = (char)(cArray19[3] ^ 0x76A4);
        this.emptyTextDummy = new DivContainer(yxtospkn.f(cArray19, (short)2710, (byte)3, (short)4), (DOMElement)this.tableBody, this.view);
        char[] cArray20 = "\ub18a\u42b0\ua3cd\ueb27\ud032\u241d\uf957\u606c\u5b5e\uac3b\u689b\ud67a\u7910\u5584\u2ebc".toCharArray();
        cArray20[7] = (char)(cArray20[7] ^ 0x7A49);
        this.emptyText = new DivContainer(yxtospkn.f(cArray20, (short)3725, (byte)5, (short)0), (DOMElement)this.tableBody, this.view);
        char[] cArray21 = "\ube25\ue57e\uec18\ud2c4\u12d3\ubea3\ub94b\u1e03\u2d51\u4006\u9c6b\u8fb5\ud6f7\u083e\u4c37".toCharArray();
        cArray21[1] = (char)(cArray21[1] ^ 0x513B);
        FilesToSignTable.Lj("nhp6c1", this.emptyText, yxtospkn.f(cArray21, (short)13946, (byte)1, (short)1));
        char[] cArray22 = "\u04c7\u8f28\u85d1\u8079\u6b27\u33ea\u0380\u2878\uac1a\uf120\u4cce\ua9cb\u25cd\u4a99\u6895\u2ff5\u6430\u2ab9\u7a45\u0171".toCharArray();
        cArray22[17] = (char)(cArray22[17] ^ 0x744F);
        FilesToSignTable.Lj("nhp6c1", this.emptyTextDummy, yxtospkn.f(cArray22, (short)18494, (byte)2, (short)0));
        FilesToSignTable.Lj("-1ldapge", this.emptyText, this.onEmptyText);
        char[] cArray23 = "\ua6a9\uee0d\u173b\ucff2\uad0b\uaaf4\udaa8\u8062\u3628\u5cc8\u57ac\u1873\u51d6\u7e56\uc175\u2591\u3013\uca7a\u95be\u5be4\u5b19\u8015\ub3ae\u942e\uf8cd\u2f80".toCharArray();
        cArray23[24] = (char)(cArray23[24] ^ 0x57AF);
        this.tableBodyContent = new DivContainer(yxtospkn.f(cArray23, (short)30026, (byte)1, (short)5), (DOMElement)this.tableBody, this.view);
        char[] cArray24 = "\u9b66\uf0c1\u676d\u0a00\u3406\ub132\u48ae\uf5a7\ua3f2\u240f\ua8d0\uc4b3\u5d5b\u222b\u538b\u3b7e\u3c62\u794e\u2083\ude02\u6dfe\uea30\udf4d\uc2e6\u99ea\u7f9b".toCharArray();
        cArray24[0] = (char)(cArray24[0] ^ 0x1F05);
        FilesToSignTable.Lj("nhp6c1", this.tableBodyContent, yxtospkn.f(cArray24, (short)26162, (byte)1, (short)4));
        char[] cArray25 = "\u659c\u254d\ud8dd\u09fa\u605e\u2f07\u9010\uc255\ue084\u2ce6\ue3e0\u10aa\ub6ff\u4941\u4af9\u80dd\u6966\ub0ab\u2a10\uf069\u9476\u2726\uf6f8\ua17b\u712d\u41f2\u50dc\uf6dd\u26b2\u4b9d\u75fd".toCharArray();
        cArray25[20] = (char)(cArray25[20] ^ 0x1A47);
        this.tableBodyContentContainer = new DivContainer(yxtospkn.f(cArray25, (short)19803, (byte)3, (short)0), (DOMElement)this.tableBodyContent, this.view);
        char[] cArray26 = "\u08ba\ud1e9\uc1c2\uedcc\uf2e6\uf49f\u844e\u05d8\ue256\u2813\u9262\ua3e7\u1b10\u8fa2\u4643\u2ba1\ud0ff\u3539\u75e6\ua20f\u6c98\u3bef\u235d\ufc2f\ue6e3\uf62e\u0a3c\ufb75\ub63f\u4b6d\u1cbb".toCharArray();
        cArray26[28] = (char)(cArray26[28] ^ 0x6282);
        FilesToSignTable.Lj("nhp6c1", this.tableBodyContentContainer, yxtospkn.f(cArray26, (short)30131, (byte)0, (short)1));
        char[] cArray27 = "\ub71d\u25a1\u37df\u2450\uf428\uc23d\u664f\uf908\uabf6\u75af\u7077\u87e2\u8528\u7d53\u86e7\uf490\u8c83\u6fb2\u38a3\ucc4a\u3c22\u6073".toCharArray();
        cArray27[15] = (char)(cArray27[15] ^ 0x3DA5);
        this.fileToSignColumn = new DivContainer(yxtospkn.f(cArray27, (short)4817, (byte)4, (short)4), (DOMElement)this.tableBodyContentContainer, this.view);
        char[] cArray28 = "\u5b0b\ubf5c\ud133\ua9a0\ube2d\ub47c\u4f15\u06a9\u044b\u09bc\u8761\ub3ea\ucc7b\u38ba\ubdd9\uc2b8\u92a2\u4186\u9327\ud6a5\u672c\u697b".toCharArray();
        cArray28[9] = (char)(cArray28[9] ^ 0x6797);
        this.signedFileColumn = new DivContainer(yxtospkn.f(cArray28, (short)11707, (byte)1, (short)4), (DOMElement)this.tableBodyContentContainer, this.view);
        char[] cArray29 = "\u29ee\u8ec8\u49af\ue81b\u4284\uac50\u258f\ucf1a\u4ec4\u36e3\u5ef1\u6cbd\u6d2a\u91e8\uab1c\u1524\ud321\u4f2d\u20c7\ue585\u4c09".toCharArray();
        cArray29[7] = (char)(cArray29[7] ^ 0x7FC);
        this.asicEFileColumn = new DivContainer(yxtospkn.f(cArray29, (short)31395, (byte)2, (short)3), (DOMElement)this.tableBodyContentContainer, this.view);
        FilesToSignTable.Lj("-l2kpgd", this.asicEFileColumn, false);
        char[] cArray30 = "\u811f\u1e5a\uf638\u2c2c\ue424\u0bab\u198d\u7a6f\u2b0f\u7aa0\u9b31\ueb15\uefde\u66a8\u218b\ueadb\u418e".toCharArray();
        cArray30[10] = (char)(cArray30[10] ^ 0x61FE);
        FilesToSignTable.Lj("nhp6c1", this.fileToSignColumn, yxtospkn.f(cArray30, (short)21698, (byte)5, (short)0));
        char[] cArray31 = "\ued06\u077d\u6e4a\ubbd1\ud79e\u0a9b\u50f0\ue440\u6d60\ued85\u9d47\u2cc4\ud4bc\u0ac0\ub8b8\u8121\u4c29".toCharArray();
        cArray31[2] = (char)(cArray31[2] ^ 0x4C6A);
        FilesToSignTable.Lj("nhp6c1", this.signedFileColumn, yxtospkn.f(cArray31, (short)31932, (byte)1, (short)2));
        char[] cArray32 = "\u0df6\u7a99\u97a6\u9098\uce1c\u0f40\u85f7\u7f6a\u7671\uf032\u912a\u6660\u47c7\u3c1e\ucd75\u419c\u5095".toCharArray();
        cArray32[4] = (char)(cArray32[4] ^ 0x2A3C);
        FilesToSignTable.Lj("nhp6c1", this.asicEFileColumn, yxtospkn.f(cArray32, (short)8586, (byte)2, (short)0));
        char[] cArray33 = "\ua904\uf803\u736f\u3a2e\u5848\u15c4\uf3d5\uaa6d\u5f73".toCharArray();
        cArray33[2] = (char)(cArray33[2] ^ 0x4D10);
        char[] cArray34 = "\u1921\uf3b8\u9415\u19d5\u83a5\u1aab\ubbcb\u7da6\u32a8".toCharArray();
        cArray34[5] = (char)(cArray34[5] ^ 0x1C7F);
        FilesToSignTable.Lj("mi36fk", this.asicEFileColumn, yxtospkn.f(cArray33, (short)16291, (byte)2, (short)0), (Object)yxtospkn.f(cArray34, (short)9066, (byte)4, (short)2));
        this.showEmptyText();
    }

    public synchronized void update(boolean externallyLoaded) {
        FilesToSignTable.Lj("-16papgj", this.view);
        FilesToSignTable.Lj("-1ldapge", this.fileToSignColumn, "");
        FilesToSignTable.Lj("-1ldapge", this.signedFileColumn, "");
        FilesToSignTable.Lj("-1ldapge", this.asicEFileColumn, "");
        this.fileExtensionList.clear();
        this.filesToSignNameMap.clear();
        this.iconLoaders.clear();
        if (FilesToSignTable.Lj("s9l6fe", (Object)this.filesToSignHandler).isEmpty()) {
            this.showEmptyText();
            this.finalizeTableRefresh();
            return;
        }
        this.hideEmptyText();
        int i = 0;
        Iterator iterator = FilesToSignTable.Lj("s9l6fe", (Object)this.filesToSignHandler).iterator();
        while (iterator.hasNext()) {
            FileToSign fts = (FileToSign)iterator.next();
            this.drawFileToSignCell(fts, i, externallyLoaded);
            if (FilesToSignTable.Lj("-1ik8pgh", SignatureFacade.SignatureType.ASICE, this.signatureType) == false) {
                this.drawSignedFileCell(fts, i);
            }
            ++i;
        }
        if (FilesToSignTable.Lj("-1ik8pgh", SignatureFacade.SignatureType.ASICE, this.signatureType) != false) {
            this.drawAsicECell(i);
        }
        this.finalizeTableRefresh();
        this.iconLoaders.forEach(iconLoader -> FilesToSignTable.Lj("-1538pjq", iconLoader));
    }

    private void drawFileToSignCell(FileToSign fts, int i, boolean externallyLoaded) {
        Object tooltipText;
        char[] cArray = "\u054d\ue0d8\u8f66\udbb0\u32e5\uccea\u15da\u35d3\u69f5\uc2df\ud7c4\u5ebf\ubbbd\u711e\ub446\u7e89\udf6e\uaf8d\u4f05\u4fd6\u4603".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0xF0E);
        DivContainer fileToSignCell = new DivContainer((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray, (short)17884, (byte)0, (short)2)), i)), (DOMElement)this.fileToSignColumn, this.view);
        char[] cArray2 = "\u0981\u2198\u54aa\uca05\u69a8\ua477\u766c\uc516\udb97\u1f14\u606e\u7bf9\u2bfd\u0c7d\u96cb\u1bf7\u03e0\u0617\uce18\u3971".toCharArray();
        cArray2[7] = (char)(cArray2[7] ^ 0x391E);
        FilesToSignTable.Lj("nhp6c1", fileToSignCell, yxtospkn.f(cArray2, (short)26660, (byte)0, (short)1));
        char[] cArray3 = "\u0350\u626e\ue3c9\u3eba\u0485\u3667\u99ca\u4086\u52ea\u407e\uc3c2\u6fe5".toCharArray();
        cArray3[3] = (char)(cArray3[3] ^ 0x2D65);
        FilesToSignTable.Lj("nhp6c1", fileToSignCell, yxtospkn.f(cArray3, (short)11524, (byte)0, (short)1));
        char[] cArray4 = "\ub5c9\u7d8c\u5173\u1e94\u7140\ud6bd\u3d0b".toCharArray();
        cArray4[1] = (char)(cArray4[1] ^ 0x80F);
        char[] cArray5 = "\udec8\u60d8\u1e19\u9855\u2eec\uea1e\u9a38\u18ba\u485f\u95de\u4b05\ud380\u24ff\uc254\u7a9f\u1413\u3fcd\ua195\uc0fc\ub8f8\ud3ee\u150a\ufbd2\ud715\ud950\u7685\ueb6e\ue9a6\u322e".toCharArray();
        cArray5[27] = (char)(cArray5[27] ^ 0x2836);
        char[] cArray6 = "\u91d8\u1c15\u2576\u6e41\u229f".toCharArray();
        cArray6[0] = (char)(cArray6[0] ^ 0x516B);
        FilesToSignTable.Lj("1p5d6fc", fileToSignCell, yxtospkn.f(cArray4, (short)10042, (byte)4, (short)3), (Object)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray5, (short)9679, (byte)0, (short)0)), FilesToSignTable.Lj("-31ipgl", fileToSignCell)), yxtospkn.f(cArray6, (short)1856, (byte)5, (short)0))));
        char[] cArray7 = "\u7a2e\u7d0c\u766b\u22bf\u5335\u8545\u13eb\ue367\u081e\ue956\udeb1\ud8c2\u8add\ue4f1\u0d42\uc607\u0e15\u7493\uea9c\u63a7\u6e64\u3b8a\uffab\uf23a\ub549\u7def\uabd7\u3c8f\u0bb3\u22c6\u8a35\u13ad".toCharArray();
        cArray7[6] = (char)(cArray7[6] ^ 0x506A);
        Image fileIcon = new Image((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray7, (short)8827, (byte)3, (short)2)), i)), (DOMElement)fileToSignCell, this.view);
        char[] cArray8 = "\u4f64\u24fd\uc6f1\uc124\u7c46\u288b\u8ad7\ube2c\ua291\u1a2f\udcb0\u99b4\uc438\u617e".toCharArray();
        cArray8[6] = (char)(cArray8[6] ^ 0x5B49);
        FilesToSignTable.Lj("-1vg2pg8", fileIcon, yxtospkn.f(cArray8, (short)11473, (byte)5, (short)5));
        this.iconLoaders.add(new Thread(() -> {
            try {
                FilesToSignTable.Lj("sdp6fn", fileIcon, FilesToSignTable.Lj("15j96cb", fts, FilesToSignTable.Lj("asn6f5", fts)));
            }
            catch (IOException ex) {
                FilesToSignTable.Lj("-15jkpjr", LOGGER, FilesToSignTable.Lj("-p4gpjk", ex), (Object)ex);
            }
        }));
        char[] cArray9 = "\u8dfc\ua3aa\u454e\u7c23\u8799\u692e\u9340\ub922\u57e1\uaf4b\uee0b\ub234\u87fe\u299c\u7258\uf44e\udae8\u7059\u8e23\u2813\u23f8\u21d5\u0f91\u8553\uda4d\u8e0b\ue596\u14fc\u6c07\u0531\uf4e9\u3371\u03d3\u7533\ua33a\uf28f\uf0d5\u6cda".toCharArray();
        cArray9[16] = (char)(cArray9[16] ^ 0x6658);
        DivContainer fileNameDiv = new DivContainer((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray9, (short)22291, (byte)5, (short)0)), i)), (DOMElement)fileToSignCell, this.view);
        char[] cArray10 = "\u6728\u9709\ue2cb\u05ad\uebfc\u93fb\u3686\u28dc\ue5aa\u4ba4\u0c5e\u9141\ua620\u2df6\u02e5\u6fc2\u213f\u87fd\uc1f3\u9bbf\u5d39\u77f4\ube61\u0e2b\ud180\u9b28\uc131\u55ed\ub458\ua53b\u252e\u9852\ua36b\uf20b\u8b06\u6075\u1a4d".toCharArray();
        cArray10[9] = (char)(cArray10[9] ^ 0x6EB0);
        FilesToSignTable.Lj("nhp6c1", fileNameDiv, yxtospkn.f(cArray10, (short)15510, (byte)5, (short)3));
        char[] cArray11 = "\ud4f1\u8e6d\ub6eb\udabb\uf0fe\u1486".toCharArray();
        cArray11[4] = (char)(cArray11[4] ^ 0x6BED);
        char[] cArray12 = "\ud014\ue336\u9f65\ue262\u4ef9".toCharArray();
        cArray12[3] = (char)(cArray12[3] ^ 0x4E4A);
        FilesToSignTable.Lj("mi36fk", fileNameDiv, yxtospkn.f(cArray11, (short)31087, (byte)1, (short)4), (Object)yxtospkn.f(cArray12, (short)527, (byte)1, (short)3));
        FilesToSignTable.Lj("-1ldapge", fileNameDiv, FilesToSignTable.Lj("asn6f5", fts));
        try {
            SimpleDateFormat sdf = new SimpleDateFormat();
            Object attr = FilesToSignTable.Lj("-ku0pgp", FilesToSignTable.Lj("-vnupgq", fts), BasicFileAttributes.class, (LinkOption[])new LinkOption[0]);
            char[] cArray13 = "\ue901\ud921\u5057\ue329\u2ce5\ube4c\ud1f2\u3a67\u3047\uf0f3\u134e\uc4d4\u8814\u9efe\ua034\ub603\u2929\ue18c\u4bf9\u65af\u2796\u3ebe\u6795\u178f\u1c87\u8fa7\uae66\u9f61\u1270\ud406\ucf62\u0670\u46fa\u7049\u3f68\u87f4\u928b\u0e38\u78c1\ua567\u8ea0\u3943\u5cb1\ufea9\u938b\ue0c8\u0570\uba98\ua091\u1b02".toCharArray();
            cArray13[41] = (char)(cArray13[41] ^ 0x7D4A);
            tooltipText = FilesToSignTable.Lj("qef41t", i18n, yxtospkn.f(cArray13, (short)25423, (byte)2, (short)1), (Object[])new Object[]{FilesToSignTable.Lj("5dn6f2", sdf, FilesToSignTable.Lj("-j24pgf", (long)FilesToSignTable.Lj("-1c16pgo", attr.creationTime()))), FilesToSignTable.Lj("5dn6f2", sdf, FilesToSignTable.Lj("-j24pgf", (long)FilesToSignTable.Lj("-1c16pgo", attr.lastModifiedTime())))});
        }
        catch (IOException ex) {
            tooltipText = "";
        }
        char[] cArray14 = "\uc0fd\u0f77\ua5a3\u94f9\uf18f\u6c8c\ued3e\u67a4\u04ef\u8b4f\u9e50\u0b5a\u21a1\u56c3\u69d9\u140a\u00f6\u1f3d\u89b8\uba64\uab6d\u5715\uacc4\ua04e\ued36\u65ae\ue902\u25a7\ue866\u3b82\u9308\ub8e8\uedad\u7fe6".toCharArray();
        cArray14[17] = (char)(cArray14[17] ^ 0x532B);
        DivContainer tooltip = new DivContainer((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray14, (short)5445, (byte)5, (short)3)), i)), (DOMElement)fileToSignCell, this.view);
        char[] cArray15 = "\u045c\udfd7\u7667\uc78a\udb97\u4580\udc0b\ud29a\ucf2a\u08f7\ue271\u9a2f\ua732\u821e\udeb0\ubfc5\ube91\u53aa\u79c6\u45aa\u54a0\u1126\ub851\udcd3\u4f1e\u3227\ub7a8\u9926\u6b1b\u78fb".toCharArray();
        cArray15[22] = (char)(cArray15[22] ^ 0x66CE);
        FilesToSignTable.Lj("nhp6c1", tooltip, yxtospkn.f(cArray15, (short)23204, (byte)4, (short)4));
        char[] cArray16 = "\uc9b8\u57ea\u7317\uedca\u49b3\ud712\u2eee\u4acb\u155a\u5b83\u6e80\ua082\u3de0\ub79b\u933e\u9687\ubdbf\u10b2\ub7ad\u7700\uaf0f\u6210\u4b0d\uf9b8\u6ad4\u53f5\u2745\u64d6".toCharArray();
        cArray16[21] = (char)(cArray16[21] ^ 0x6145);
        Image infoImg = new Image((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray16, (short)20371, (byte)5, (short)3)), i)), (DOMElement)tooltip, this.view);
        char[] cArray17 = "\u3a33\u6bca\ud768\u96c1\uafe7\ubc4e\u0220\u8ab1\uea88\u7733".toCharArray();
        cArray17[5] = (char)(cArray17[5] ^ 0x373E);
        FilesToSignTable.Lj("-1vg2pg8", infoImg, yxtospkn.f(cArray17, (short)11374, (byte)4, (short)0));
        char[] cArray18 = "\ucdaf\u4df9\uf8e4\u44dd\u3dcb\u3c9b\u129f\u50c4\u1516".toCharArray();
        cArray18[4] = (char)(cArray18[4] ^ 0x4BCE);
        FilesToSignTable.Lj("sdp6fn", infoImg, FilesToSignTable.Lj("55j6fm", yxtospkn.f(cArray18, (short)28885, (byte)1, (short)3)));
        char[] cArray19 = "\ub439\u7a01\ue2fe\uc8d3\u1925\u62ca\u05e8\u37f7\ud41c\u8154\u8e46\uf689\u61f6\ufe25\u832b\uc94d\u9485\u0c4a".toCharArray();
        cArray19[14] = (char)(cArray19[14] ^ 0x69A6);
        SpanContainer tooltipContainer = new SpanContainer((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray19, (short)7006, (byte)4, (short)2)), i)), (DOMElement)tooltip, this.view);
        Object tooltipTextFinal = tooltipText;
        char[] cArray20 = "\u5803\ua2b6\u8a23\ubce6\udffb\ud2d4\u641c\uf86d\u3dc1\uee2d\uea89\ua13a\u7f4d\u339c".toCharArray();
        cArray20[5] = (char)(cArray20[5] ^ 0x2873);
        CGTooltip fileTooltip = new CGTooltip((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray20, (short)20506, (byte)2, (short)5)), i)), (DOMElement)tooltipContainer, this.view, () -> FilesToSignTable.lambda$drawFileToSignCell$2((String)tooltipTextFinal));
        char[] cArray21 = "\u7c72\u83ce\u0777\u7e0e\u9d7d\u27e4\ubc7c\ub085\u7060\u3ff3\u80ec\ua96e\u7f1e".toCharArray();
        cArray21[10] = (char)(cArray21[10] ^ 0x794);
        FilesToSignTable.Lj("-11nupgt", fileTooltip, yxtospkn.f(cArray21, (short)29659, (byte)1, (short)2));
        char[] cArray22 = "\u2718\u1545\u6215\u0100\u30cb\u5b0a\u4b28\u3c5c\ufdc2\u1d67".toCharArray();
        cArray22[0] = (char)(cArray22[0] ^ 0x15D3);
        char[] cArray23 = "\u8a68\u7dd7\ua1c9\u97e6\ud867\u6b58\u4404\u44d7\ufd29\u8d9c\u964f\u3999\u1219\ud193\ufa2a\ucfe7\uda17\uf184\ue212\ud878\u8a7f\u0dc5\uf618\u88f2\u480a\u854c\u67dd\u6384".toCharArray();
        cArray23[24] = (char)(cArray23[24] ^ 0x660A);
        char[] cArray24 = "\u3760\u0886\ufc15\u2dd0\u0ad4".toCharArray();
        cArray24[2] = (char)(cArray24[2] ^ 0x5B47);
        char[] cArray25 = "\u0586\ub512\u17f9\u5617\u59c7".toCharArray();
        cArray25[2] = (char)(cArray25[2] ^ 0x5A51);
        FilesToSignTable.Lj("-hreph2", infoImg, yxtospkn.f(cArray22, (short)3965, (byte)2, (short)3), (Object)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray23, (short)24618, (byte)1, (short)0)), FilesToSignTable.Lj("756f4", infoImg)), yxtospkn.f(cArray24, (short)28670, (byte)0, (short)2)), FilesToSignTable.Lj("-1h1kph3", fileTooltip)), yxtospkn.f(cArray25, (short)12999, (byte)1, (short)0))));
        char[] cArray26 = "\u6e91\ue2af\u0b77\u7395\u97f1\u1ac3\u6ecd\udd08\ud92b\uadfa\u1568".toCharArray();
        cArray26[7] = (char)(cArray26[7] ^ 0x7C80);
        char[] cArray27 = "\ue8ed\u814a\uc838\uf676\u73a1\u00ac\ud0f3\u2f98\u4703\u180a\u40b4\u0c5c\ud918\uba69\u2104\u5da4\u9ba8\u4925\uf164\uc0fe\ue6dd\u099d\u17b4\u95f2\u50f9\u66c4\u99e7\u73cb".toCharArray();
        cArray27[11] = (char)(cArray27[11] ^ 0x33F2);
        char[] cArray28 = "\u8bda\u6537\u3bac\uc28e\u4b84".toCharArray();
        cArray28[3] = (char)(cArray28[3] ^ 0x7520);
        FilesToSignTable.Lj("-hreph2", infoImg, yxtospkn.f(cArray26, (short)20446, (byte)2, (short)4), (Object)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray27, (short)19699, (byte)5, (short)5)), FilesToSignTable.Lj("-1h1kph3", fileTooltip)), yxtospkn.f(cArray28, (short)1601, (byte)5, (short)2))));
        char[] cArray29 = "\uf50c\u82c9\u57f4\u3f91\u24d8\ud095\u998e\u70f0\u2034\uf25d\uc04c\u7f08\u32f7\u5d32\u97fe\u65c1".toCharArray();
        cArray29[6] = (char)(cArray29[6] ^ 0x651E);
        char[] cArray30 = "\ua100\u0a5d\u3c16\u19c5\u2920".toCharArray();
        cArray30[3] = (char)(cArray30[3] ^ 0xDEB);
        char[] cArray31 = "\u3bbe\uf823\u48fc\u54ba".toCharArray();
        cArray31[0] = (char)(cArray31[0] ^ 0x23FB);
        FilesToSignTable.Lj("-1m9aph1", this.view, FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray29, (short)27106, (byte)4, (short)1)), FilesToSignTable.Lj("756f4", infoImg)), yxtospkn.f(cArray30, (short)13845, (byte)3, (short)1)), FilesToSignTable.Lj("-1h1kph3", fileTooltip)), yxtospkn.f(cArray31, (short)14982, (byte)4, (short)1))));
        char[] cArray32 = "\uae9b\u2da7\u102c\uc3f8\u0b09\ua27d\u2d11\u5b31\ua988\u9bdc\ud69c\u994c\u47e0\u3b3d\u0b19\u7dae".toCharArray();
        cArray32[6] = (char)(cArray32[6] ^ 0x1747);
        char[] cArray33 = "\u6052\u04da\ubf9a\u0624".toCharArray();
        cArray33[2] = (char)(cArray33[2] ^ 0x135);
        FilesToSignTable.Lj("-1m9aph1", this.view, FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray32, (short)4017, (byte)2, (short)3)), FilesToSignTable.Lj("-1h1kph3", fileTooltip)), yxtospkn.f(cArray33, (short)27255, (byte)1, (short)3))));
        char[] cArray34 = "\uf7fd\u7d5b\ub704\u793a\u2dd9\uf270\u8e6b\ue2b4\ubc07\u6263\u5175\u7683\u544b\ua1b0\u7181\u6f54\u6886\ud2f8\u9e66\u458e\u42e7\u29df\u0c7a\u5980\u9abb\u038d\u459d\u91b0\u028f".toCharArray();
        cArray34[7] = (char)(cArray34[7] ^ 0x19AC);
        Image trash = new Image((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray34, (short)25776, (byte)3, (short)1)), i)), (DOMElement)fileToSignCell, this.view);
        char[] cArray35 = "\ue11a\ud5bc\uc0cd\u7ef5\uae57\u21f0\u5903\u24ea\u91b2\u8e88\u18fe".toCharArray();
        cArray35[6] = (char)(cArray35[6] ^ 0x4D41);
        FilesToSignTable.Lj("-1vg2pg8", trash, yxtospkn.f(cArray35, (short)922, (byte)3, (short)5));
        FilesToSignTable.Lj("sdp6fn", trash, TRASH_IMG);
        FilesToSignTable.Lj("-1rp6ph0", trash, DOMEvent.MOUSEENTER, t -> FilesToSignTable.Lj("sdp6fn", trash, TRASH_HOVER_IMG), (boolean)true);
        FilesToSignTable.Lj("-1rp6ph0", trash, DOMEvent.MOUSELEAVE, t -> FilesToSignTable.Lj("sdp6fn", trash, TRASH_IMG), (boolean)true);
        if (externallyLoaded) {
            char[] cArray36 = "\u86ad\uf259\u49b9\ub2cc\ua65b\u77bb\u2a35".toCharArray();
            cArray36[2] = (char)(cArray36[2] ^ '\u0000');
            char[] cArray37 = "\u061a\u695f\ue325\u33cf\uc4a6\u570d\ucb17\u1594\ub6f9\ud5bd\u0b95\u229b".toCharArray();
            cArray37[9] = (char)(cArray37[9] ^ 0x5EAF);
            FilesToSignTable.Lj("-1jsspgn", trash, yxtospkn.f(cArray36, (short)20481, (byte)0, (short)4), (Object)yxtospkn.f(cArray37, (short)6540, (byte)4, (short)2));
        }
        FilesToSignTable.Lj("1kcv6cq", trash, evt -> {
            if (externallyLoaded) {
                return;
            }
            FilesToSignTable.Lj("-1pgopjm", (Object)this.filesToSignHandler, fts);
            if (FilesToSignTable.Lj("s9l6fe", (Object)this.filesToSignHandler).isEmpty()) {
                this.showEmptyText();
                if (this.onEmpty != null) {
                    this.onEmpty.run();
                }
            }
        });
    }

    private void drawSignedFileCell(FileToSign fts, int i) {
        FilesToSignTable.Lj("-l2kpgd", this.signedFileColumn, true);
        FilesToSignTable.Lj("-l2kpgd", this.asicEFileColumn, false);
        char[] cArray = "\ua769\u2e17\u6ac2\uc1f8\u12fa\u9dc5\u8da7\ue61a\u07c9\uf8e6\u2819\uf77f\ub938\udeff\uc84a\u386d".toCharArray();
        cArray[2] = (char)(cArray[2] ^ 0x7BE0);
        DivContainer signedFileCell = new DivContainer((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray, (short)15625, (byte)5, (short)3)), i)), (DOMElement)this.signedFileColumn, this.view);
        char[] cArray2 = "\u2519\u3bb4\u496e\u2371\u767d\uc214\u316a\ubfc5\u8a9e\u58af\ub9c6\u2581".toCharArray();
        cArray2[4] = (char)(cArray2[4] ^ 0x3DF4);
        FilesToSignTable.Lj("nhp6c1", signedFileCell, yxtospkn.f(cArray2, (short)11556, (byte)3, (short)4));
        char[] cArray3 = "\u5292\u789e\u0e80\ud41c\u1a32\u4a62\u7ac9\u1c47\u9738\ua738\ue332\ue970\u7743\uc2f6\u2a4c\u8735\u2879\u4099\ua75a\ua904\u644b\u9b67\u5b2b\u51bc\ub27d\uc3bb\u0850\uc583\u962f\udaa5\ued6e\ub49b\u56ec\ucf5b\u1ae9".toCharArray();
        cArray3[26] = (char)(cArray3[26] ^ 0x7118);
        char[] cArray4 = "\u747c\u2d39\u7a51\u8cd6\uf12c\u1058\u74ea".toCharArray();
        cArray4[5] = (char)(cArray4[5] ^ 0x20A6);
        Image arrow = new Image((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray3, (short)10952, (byte)1, (short)0)), i), yxtospkn.f(cArray4, (short)29530, (byte)4, (short)5))), (DOMElement)signedFileCell, this.view);
        char[] cArray5 = "\u516d\u9d21\u0173\ub052\u89ae\u0929\uefa6\uce43\ua1af\u02e4\u5498".toCharArray();
        cArray5[2] = (char)(cArray5[2] ^ 0xE0E);
        FilesToSignTable.Lj("-1vg2pg8", arrow, yxtospkn.f(cArray5, (short)15105, (byte)1, (short)4));
        FilesToSignTable.Lj("sdp6fn", arrow, ARROW_IMG);
        char[] cArray6 = "\u959a\u135c\ufda6\u7552\ue2a3\ua243\uaf14\u9ae4\u39f8\u3cc9\u69d5\u5a62\u04cf\ubba0\u9423\u287f\uf1fc\u4fd6\ubaab\uc267\u718c\ud3a0\u7991\u4108\u7bef\ub1bd\u395f\uc116\u6349\u0b34\uedbb\u2340\udf1a\u7593\u64d2".toCharArray();
        cArray6[7] = (char)(cArray6[7] ^ 0x4441);
        char[] cArray7 = "\ud218\u29dc\u7d39\u6c9a\u16f5\u7807\u9600\ud21f\u2f27\uba0f\u747c\u4bac".toCharArray();
        cArray7[4] = (char)(cArray7[4] ^ 0x70A6);
        Object signedNameId = FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray6, (short)24135, (byte)5, (short)5)), i), yxtospkn.f(cArray7, (short)18143, (byte)5, (short)4)));
        this.filesToSignNameMap.put((String)signedNameId, fts);
        TextInput signedName = new TextInput((String)signedNameId, (DOMElement)signedFileCell, this.view);
        char[] cArray8 = "\u950a\u59df\u1d11\ub41b\uac95\u5d34\uc9a8\u1692\uaf1b\uf896\u7429\u1532\u21b8".toCharArray();
        cArray8[3] = (char)(cArray8[3] ^ 0x1870);
        FilesToSignTable.Lj("-vropj5", signedName, yxtospkn.f(cArray8, (short)7042, (byte)2, (short)3));
        char[] cArray9 = "\ufd37\u457b\u8539\u4f0c\u32e6\u130f\ua12e\uc5ff\ud363\ud558\u2640\u9ceb\ub357\u84f9\u8d92\u2e3f\uab8f\ufac6\uf890\u67b0\u04cd\u80d0\u0e66\u3374\u3438\ue7ef\ud487\u69a9".toCharArray();
        cArray9[23] = (char)(cArray9[23] ^ 0x6EFF);
        FilesToSignTable.Lj("-vropj5", signedName, yxtospkn.f(cArray9, (short)24648, (byte)4, (short)3));
        FilesToSignTable.Lj("-fl4pjb", signedName, FilesToSignTable.Lj("-g5epj4", fts));
        char[] cArray10 = "\u259c\ufa4b\ue618\u309c\u2701\uf2d0\u7610\u5c71\ubcb4\ud30e\u4fb4\ufee7\u07ca\ua0b7\ubff6\ue2db\u996a\u5d2e\ub3c6\ue4cb\ufe02\u17ed\ubce5\u6ab0\u43e5\u5532\u2f9e".toCharArray();
        cArray10[20] = (char)(cArray10[20] ^ 0x5025);
        char[] cArray11 = "\ud7ec\u2e31\u3b9a\u5406".toCharArray();
        cArray11[0] = (char)(cArray11[0] ^ 0x4376);
        FilesToSignTable.Lj("-1m9aph1", this.view, FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray10, (short)22594, (byte)2, (short)3)), signedNameId), yxtospkn.f(cArray11, (short)19744, (byte)0, (short)4))));
        char[] cArray12 = "\u6a2f\ub8e0\u7036\u96d1\u7d9f\u04d8".toCharArray();
        cArray12[2] = (char)(cArray12[2] ^ 0x3658);
        char[] cArray13 = "\u71d6\u41e2\uf897\ud0e4\u060f\u0412\uea80\ub7d3\u640c\uffd3\u159c\u7696\u60dd\u1acb\uac29\ufc61\u4e33\u3e51\u9b80\u80a1\ue067\u8b1d\ucfa4\ufad4\u0149\u79fe\uae15\u593c\u19f9\u2383\u5895\u7456\u7872\udb40\udc11\u47b9\u9fe6\ud020\u09d8\u4993\u6896\ue7db\uafaf\u8e73\uc1fc\u4d00".toCharArray();
        cArray13[20] = (char)(cArray13[20] ^ 0x4F50);
        FilesToSignTable.Lj("1ubd6cm", signedName, yxtospkn.f(cArray12, (short)6865, (byte)5, (short)3), (Object)yxtospkn.f(cArray13, (short)14213, (byte)3, (short)5));
        char[] cArray14 = "\u0357\u98f7\u876a\u95b2\ub66f\udcc7\u08f8\uf3e3\u1e3a\u9a31\u60e0\uac6b\ub61e\u7105\u970c\ud53b\u3ea7\u6257\u00a7\uba32\ue5b2\ud78f\ucd65\u6ef4\u5743\u888c\ud1af\udcb3\u5704\u62f4\u125c\ud4a2\uf1e6\ua681\u2551".toCharArray();
        cArray14[0] = (char)(cArray14[0] ^ 0x282);
        char[] cArray15 = "\u0220\uace2\u6e58\u861f\u70f6\u356a\ue2ad\ua1fe\uc15b\ub956\u251b\uaa15\u2999\ua7d4\u40fc".toCharArray();
        cArray15[9] = (char)(cArray15[9] ^ 0x1FC9);
        Paragraph fileExtension = new Paragraph((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), yxtospkn.f(cArray14, (short)5888, (byte)1, (short)1)), i), yxtospkn.f(cArray15, (short)6314, (byte)5, (short)1))), (DOMElement)signedFileCell, this.view, () -> FilesToSignTable.Lj("-en0pji", fts));
        char[] cArray16 = "\ud31d\uf129\ud4a5\u9ddb\u93ea\ua5da\u3978\ue098\u8c48\uf5bf\ucabe\u3c9f\u0e16\ucccf\u1645\uf710\u0b60\u59d2\ua616\u8d8b\ueb67\u0639\u53c9\u7e34\ud456\u9f44\u0b4b".toCharArray();
        cArray16[19] = (char)(cArray16[19] ^ 0x5F29);
        FilesToSignTable.Lj("43p6cn", fileExtension, yxtospkn.f(cArray16, (short)1673, (byte)4, (short)4));
        this.fileExtensionList.add(fileExtension);
    }

    private void drawAsicECell(int i) {
        char[] cArray = "\ufab0\ua83d\uf297\ub1ea\u45db\uabea\uc489\u5e2a\u1227\u4409\uf1f8\u6be9\u12fa\uaf99\ufcef\ube46\u3193\u81b0\u588c\u5519".toCharArray();
        cArray[16] = (char)(cArray[16] ^ 0x4CE4);
        FilesToSignTable.Lj("-1m9aph1", this.view, hgbuinzg.x(cArray, (short)15847, true, (short)1));
        FilesToSignTable.Lj("-l2kpgd", this.signedFileColumn, false);
        FilesToSignTable.Lj("-l2kpgd", this.asicEFileColumn, true);
        char[] cArray2 = "\uebae\ua5f1\ud647\u58c7\ue78d\ue7cf\uf8a6\uce9f\uc6fa\ue48c\uf25e\u568c\u721e\u6e2e\u4a2c\u9ed5\u1be6\u8b11\u7a23\u4e7d\u18f5\udc23\u8a06\u4ed3\u6ad3\uceea\u7386\u91e3\ud4b0\u6786\ue5c3\ua8d0\uc6fd\u2e9f\u2d80\u9ed2\ue89b\u6d01".toCharArray();
        cArray2[8] = (char)(cArray2[8] ^ 0x140A);
        DivContainer asicECellContainer = new DivContainer(hgbuinzg.x(cArray2, (short)31167, false, (short)3), (DOMElement)this.asicEFileColumn, this.view);
        char[] cArray3 = "\u27b8\ue0f0\ue25e\u5ac8\u2dfb\ud20b\uc8d5\ua257\ua9b2\ue466\u8e4f\ubc94\u0bff\u854b\udfb0\ua8c1\u904f\u8fe1\uf782\u3a6c\u4350\uc319\u70db\u6147\u246a\u07d0\u6ce0\u3c70\u2ce8\u64d0\u780c\u160f\u66b1\uf844\u7c39\ub804\u3f25\u563d".toCharArray();
        cArray3[3] = (char)(cArray3[3] ^ 0x2D5C);
        FilesToSignTable.Lj("nhp6c1", asicECellContainer, hgbuinzg.x(cArray3, (short)22483, false, (short)5));
        char[] cArray4 = "\u1390\u7bd1\u23be\u5cd9\ucae9\uec83\u8b67\u8677\u0f46".toCharArray();
        cArray4[4] = (char)(cArray4[4] ^ 0x3A8A);
        DivContainer asicECell = new DivContainer(hgbuinzg.x(cArray4, (short)18268, true, (short)0), (DOMElement)asicECellContainer, this.view);
        char[] cArray5 = "\ued6f\u15a4\u1435\ue32c\ua9a9\u6da3\ud73c\ub6cb\u954f\u1711\u6501\ud4ef\uecbc\ub796\uebf3\ud92d\u30aa\ue9e3\u179e\ud45d\uc57f\u5fed".toCharArray();
        cArray5[7] = (char)(cArray5[7] ^ 0x2B3B);
        FilesToSignTable.Lj("nhp6c1", asicECell, hgbuinzg.x(cArray5, (short)23201, true, (short)2));
        char[] cArray6 = "\u8697\u86668\u6502\u674c\u7ce2\u7cd0\u94af\ub826\u43fc\ua0ba\uff9f\u23d7\u7048\u11c6\u866b\u35b5\u971a\u7430\uace3\u966d\u7aeb\u4d6d\u4e60\u54ce\u53b9\u7a05\u9099\u73d0\u2b69".toCharArray();
        cArray6[3] = (char)(cArray6[3] ^ 0x477C);
        char[] cArray7 = "\u1f97\u2ff3\u71da\u5a6c\ubf06\uede5\u59f7".toCharArray();
        cArray7[2] = (char)(cArray7[2] ^ 0x99A);
        Image arrow = new Image((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), hgbuinzg.x(cArray6, (short)14659, false, (short)2)), i), hgbuinzg.x(cArray7, (short)23949, false, (short)0))), (DOMElement)asicECell, this.view);
        char[] cArray8 = "\u4fa5\u5546\u0e24\ue053\u1ef0\uf917\ud193\u0222\uc592\u9ce2\u7b52".toCharArray();
        cArray8[8] = (char)(cArray8[8] ^ 0x763);
        FilesToSignTable.Lj("-1vg2pg8", arrow, hgbuinzg.x(cArray8, (short)2704, false, (short)3));
        FilesToSignTable.Lj("sdp6fn", arrow, ARROW_IMG);
        char[] cArray9 = "\ua4ec\u6ca9\u14b5\u2d99\u8f2e\u919a\ua84b\u1360\u375c\ud00c\u72a1\u26a5\u0a4a\ue932\u84c5\uc49b\u47e7\ufda0\u9ad1\u73d0\u83a6\u9284\u73f3\u64fc\u85f3\uff0a\u7f12\ua726\u0663\u22ca".toCharArray();
        cArray9[22] = (char)(cArray9[22] ^ 0x54F3);
        char[] cArray10 = "\uc194\u08e5\u3365\uec13\ubd1f\ue7b6\u5b78\u7b82\ub66b\u9941\ud095\u7d52".toCharArray();
        cArray10[7] = (char)(cArray10[7] ^ 0x19EC);
        Object signedNameId = FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), hgbuinzg.x(cArray9, (short)9658, true, (short)5)), i), hgbuinzg.x(cArray10, (short)26185, true, (short)0)));
        this.filesToSignNameMap.put((String)signedNameId, (FileToSign)FilesToSignTable.Lj("-1i4kpj8", (Object)this.filesToSignHandler));
        TextInput signedName = new TextInput((String)signedNameId, (DOMElement)asicECell, this.view);
        char[] cArray11 = "\u95b1\u7ad3\u8c88\u0b2e\u996c\u5f56\u6eb5\u015f\ucfae\u7b0a\ue372\u7ac9\u77ad".toCharArray();
        cArray11[4] = (char)(cArray11[4] ^ 0xBD1);
        FilesToSignTable.Lj("-vropj5", signedName, hgbuinzg.x(cArray11, (short)30114, true, (short)1));
        char[] cArray12 = "\uda73\ue5ee\u7ce7\u7890\ubc31\ub023\u1c54\u27c6\uc895\u71e5\u874a\u8ac9\ufe5b\u340e\u17c4\u0ed2\u66e1\u02d3\u38c2\u6104\u0eda\ube85\u32e6\u10dc\u6915\u430b\u8903\u1a39".toCharArray();
        cArray12[8] = (char)(cArray12[8] ^ 0x2F82);
        FilesToSignTable.Lj("-vropj5", signedName, hgbuinzg.x(cArray12, (short)17154, false, (short)0));
        FilesToSignTable.Lj("-fl4pjb", signedName, FilesToSignTable.Lj("-g5epj4", FilesToSignTable.Lj("-1i4kpj8", (Object)this.filesToSignHandler)));
        char[] cArray13 = "\u01cc\uc9af\uec94\u5616\u977c\u6aba\u9abe\u28c5\ua738\ub610\u718d\u9176\u6346\u1335\ue13e\uc53e\uf7bd\ucb78\u75d6\udd8c\ud7c5\u7631\u8fe7\u4aab\ueb0a\u6ea7\u2108".toCharArray();
        cArray13[5] = (char)(cArray13[5] ^ 0x6364);
        char[] cArray14 = "\u6cbe\u57a0\u4333\u32ee".toCharArray();
        cArray14[1] = (char)(cArray14[1] ^ 0x4631);
        FilesToSignTable.Lj("-1m9aph1", this.view, FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", new StringBuilder(), hgbuinzg.x(cArray13, (short)25159, false, (short)4)), signedNameId), hgbuinzg.x(cArray14, (short)3122, true, (short)0))));
        char[] cArray15 = "\ud0a4\u91a8\u40ba\u15ba\ueb17\u6e58".toCharArray();
        cArray15[4] = (char)(cArray15[4] ^ 0x320F);
        char[] cArray16 = "\uc03f\uf477\u6dbf\uda0a\u3e2a\u48b9\u74fb\u1541\udb80\u9572\u4122\u9fa1\ud991\u4a11\uc3a1\u7c5d\u07a3\uf8c4\uad69\ub094\ud9e1\uca2e\ud484\u8935\u1815\u66e1\u633a\u544d\u5fa6\ue5f3\u8653\ud2fb\u924e\u29e7\u67ce\u1fa5\ud740\u3b1f\u6357\ubf50\ud894\uadb8\u8a1f\ud16b\u501f\u2cf7".toCharArray();
        cArray16[9] = (char)(cArray16[9] ^ 0x48D4);
        FilesToSignTable.Lj("1ubd6cm", signedName, hgbuinzg.x(cArray15, (short)6865, false, (short)2), (Object)hgbuinzg.x(cArray16, (short)20510, true, (short)2));
        char[] cArray17 = "\u8cf0\ucd85\ucaba\u1494\uc84d\uc3e1\u577b\u6a60\u14c7\u8110\u2132\u7389\u2cba\uc949\uf7b8\u7706\uc54d\u65e5\u044f\u17f8\u8f8a\ucc55\u940a\uf27e\ud140\ub11e\u8ca7\u60c6\ua8b1\u4941".toCharArray();
        cArray17[25] = (char)(cArray17[25] ^ 0x273);
        char[] cArray18 = "\u8b0f\u599e\u99a5\u588d\u35e3\ubb9d\ub1f1\u70a6\ua836\u2203\u9f49\ude42\ued9c\u2de2\u6c39".toCharArray();
        cArray18[10] = (char)(cArray18[10] ^ 0x3710);
        Paragraph fileExtension = new Paragraph((String)FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("-16uepg7", FilesToSignTable.Lj("1r736fg", new StringBuilder(), hgbuinzg.x(cArray17, (short)24217, true, (short)2)), i), hgbuinzg.x(cArray18, (short)7686, false, (short)2))), (DOMElement)asicECell, this.view, () -> FilesToSignTable.Lj("-en0pji", FilesToSignTable.Lj("-1i4kpj8", (Object)this.filesToSignHandler)));
        char[] cArray19 = "\u4ec1\u02fc\udce6\ue1a0\uf906\u6e51\u1756\uc905\u7e49\u56f4\ua7a7\uca18\u9825\u7d5e\u45ce\ub58a\uec16\u9290\u7119\u253a\u6f61\u74e7\u04f6\u088f\u7392\u0f61\u1f9d".toCharArray();
        cArray19[11] = (char)(cArray19[11] ^ 0x120E);
        FilesToSignTable.Lj("43p6cn", fileExtension, hgbuinzg.x(cArray19, (short)17374, false, (short)2));
    }

    private void finalizeTableRefresh() {
        FilesToSignTable.Lj("12dh6d1", this.view);
        char[] cArray = "\u82c7\ub422\ufc44\u65de\u6e71\ub558\u9db0\u2ae9\u9360\u94a4\u4ab9\ufc54\u2d37\ude44\ucc57\u9aa5\uba52\u3b23\u3653\udb53\u4ad2\u2711\u4c49\ud395\u5fb2".toCharArray();
        cArray[9] = (char)(cArray[9] ^ 0x1C16);
        FilesToSignTable.Lj("-1m9aph1", this.view, hgbuinzg.x(cArray, (short)21120, false, (short)5));
        if (FilesToSignTable.Lj("roh6ci") != false) {
            FilesToSignTable.Lj("-7akpjd", this.view);
        }
    }

    public void showEmptyText() {
        FilesToSignTable.Lj("-l2kpgd", this.emptyText, true);
        FilesToSignTable.Lj("-l2kpgd", this.emptyTextDummy, true);
        FilesToSignTable.Lj("-l2kpgd", this.tableBodyContent, false);
    }

    public void hideEmptyText() {
        FilesToSignTable.Lj("-l2kpgd", this.emptyText, false);
        FilesToSignTable.Lj("-l2kpgd", this.emptyTextDummy, false);
        FilesToSignTable.Lj("-l2kpgd", this.tableBodyContent, true);
    }

    public void updateExtensions(boolean externallyCalled) {
        Iterator iterator = FilesToSignTable.Lj("s9l6fe", (Object)this.filesToSignHandler).iterator();
        while (iterator.hasNext()) {
            FileToSign fts;
            block8: {
                block9: {
                    block7: {
                        fts = (FileToSign)iterator.next();
                        if (FilesToSignTable.Lj("-1ik8pgh", SignatureFacade.SignatureType.PADES, this.signatureType) == false && FilesToSignTable.Lj("-1ik8pgh", SignatureFacade.SignatureType.XADES, this.signatureType) == false) break block7;
                        if (!externallyCalled) {
                            char[] cArray = "\u91b6\u299a".toCharArray();
                            cArray[0] = (char)(cArray[0] ^ 0x28CC);
                            char[] cArray2 = "\ua08a\u3468\u7a00\u528a\u8052\ub6c4\u37fc\u0594".toCharArray();
                            cArray2[3] = (char)(cArray2[3] ^ 0x425C);
                            FilesToSignTable.Lj("-2nupg6", fts, FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", new StringBuilder(), FilesToSignTable.Lj("-1khipjj", FilesToSignTable.Lj("-g5epj4", fts), 0, (int)FilesToSignTable.Lj("-rukpjc", FilesToSignTable.Lj("asn6f5", fts), hgbuinzg.x(cArray, (short)16343, false, (short)4)))), hgbuinzg.x(cArray2, (short)5162, true, (short)2))));
                        }
                        break block8;
                    }
                    Object dfe = FilesToSignTable.Lj("-en0pji", fts);
                    if (dfe == null) break block8;
                    char[] cArray = "\u9043\u2476\u45d9\u2793\u6a6d".toCharArray();
                    cArray[2] = (char)(cArray[2] ^ 0x6037);
                    if (FilesToSignTable.Lj("stv6cf", dfe, hgbuinzg.x(cArray, (short)29013, true, (short)0)) != false) break block9;
                    char[] cArray3 = "\uba8b\ub75e\u4327\ub295\u5a16".toCharArray();
                    cArray3[3] = (char)(cArray3[3] ^ 0x60D3);
                    if (FilesToSignTable.Lj("stv6cf", dfe, hgbuinzg.x(cArray3, (short)7765, false, (short)0)) == false) break block8;
                }
                FilesToSignTable.Lj("-2nupg6", fts, FilesToSignTable.Lj("asn6f5", fts));
            }
            this.destinationFileExtension = FilesToSignTable.Lj("-v9gpjg", this.signatureType);
            if (this.applyTsd) {
                this.destinationFileExtension = FilesToSignTable.Lj("8nr6fa", FilesToSignTable.Lj("1r736fg", FilesToSignTable.Lj("1r736fg", new StringBuilder(), this.destinationFileExtension), FilesToSignTable.Lj("-v9gpjg", SignatureFacade.SignatureType.TSD)));
            }
            FilesToSignTable.Lj("-1dagpj7", fts, this.destinationFileExtension);
        }
    }

    private static /* synthetic */ String lambda$drawFileToSignCell$2(String tooltipTextFinal) {
        return tooltipTextFinal;
    }

    static /* synthetic */ TimedMessage access$000(FilesToSignTable x0) {
        return x0.message;
    }

    static /* synthetic */ I18N access$100() {
        return i18n;
    }

    static /* synthetic */ Map access$200(FilesToSignTable x0) {
        return x0.filesToSignNameMap;
    }

    static {
        char[] cArray = "\u6997\u7dea\u4cbc\uf866\u1446\u4d9f\u8da4\u9971\u3f38\ucb06\uf03a\u9375\u3185\u08e0\u8c4e\u16a5\uc277\ub7ea\u8868\ua412\u1cf1\ub0d6\u8967\ue448\u864c\u5d71\u8508\uf0f3\u47a9\u156e\u7376\u1970\u5381\ued00\ufd7f\uc750\uf891\u21ec\u3ae2\ua8ac\u6ea9".toCharArray();
        cArray[9] = (char)(cArray[9] ^ 0x8B1);
        i18n = FilesToSignTable.Lj("nt16c8", iclyasmt.Z(cArray, (short)17363, true, 2));
        char[] cArray2 = "\u5d4a\u10c6\u3ce2\u0d62\u2154\ud991\u06c7\u9223\u30f0\u77ce".toCharArray();
        cArray2[3] = (char)(cArray2[3] ^ 0x243);
        TRASH_IMG = FilesToSignTable.Lj("55j6fm", iclyasmt.Z(cArray2, (short)17518, false, 5));
        char[] cArray3 = "\u2931\u9932\uaf3f\u5d24\u1666\u9e75\u79b8\udf84\ub104\u3516\u8db2\uf181\ub7fd\ue527\ud716\u7324".toCharArray();
        cArray3[4] = (char)(cArray3[4] ^ 0x15E9);
        TRASH_HOVER_IMG = FilesToSignTable.Lj("55j6fm", iclyasmt.Z(cArray3, (short)1688, false, 4));
        char[] cArray4 = "\u9380\u575a\u5451\u3eba\udbbf\u5f01\ucac0\ub9e3\ua460\u4d11".toCharArray();
        cArray4[7] = (char)(cArray4[7] ^ 0x62FD);
        ARROW_IMG = FilesToSignTable.Lj("55j6fm", iclyasmt.Z(cArray4, (short)10984, true, 0));
    }

    private static Object Lj(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(mzzpvrfg.T(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }

    public class FileToSignTableController
    extends InternalController {
        public FileToSignTableController(BaseController mainController, View view) {
            super(mainController, view);
        }

        @JSFunction
        public void showForbiddenCharMessage() {
            FileToSignTableController.sE("-q76rtt", FileToSignTableController.sE("-60srto", FilesToSignTable.this), (int)(FileToSignTableController.sE("d8542h", this.view) / 2 - 180), (int)(FileToSignTableController.sE("1l0p422", this.view) / 6));
            char[] cArray = "\u0142\ue80a\ua645\ufd24\ud5a4\uc6c7\u5a1b\uc674\ua4d4\ua35e\u1a02\u5f0e\u4ca7\u525a\u84f6\u8f61\u03dc\u242c\udb3a\u08fc\ua3f2\ua7ac\ubaca\uaa67\u8767\ue8ae\uce29\u1fe5\ub837\ue06e\u2b5e\u4bb5\u6dd9".toCharArray();
            cArray[23] = (char)(cArray[23] ^ 0x717);
            FileToSignTableController.sE("-5igru2", FileToSignTableController.sE("-60srto", FilesToSignTable.this), FileToSignTableController.sE("qef41t", FileToSignTableController.sE("-1ujgrts"), yxtospkn.f(cArray, (short)4656, (byte)2, (short)5), (Object[])new Object[0]));
            FileToSignTableController.sE("11gt41v", FileToSignTableController.sE("-60srto", FilesToSignTable.this));
        }

        @JSFunction
        public void updateFileToSignName(String id, String name) {
            if (id == null || FileToSignTableController.sE("12od420", id) != false || name == null || FileToSignTableController.sE("12od420", name) != false) {
                return;
            }
            FileToSign fts = (FileToSign)FileToSignTableController.sE("-17kurtn", FilesToSignTable.this).get(id);
            if (fts != null) {
                FileToSignTableController.sE("-2nupg6", fts, name);
            }
        }

        private static Object sE(Object object, Object object2, Object object3) {
            try {
                return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(mzzpvrfg.T(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
            }
            catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
                throw new BootstrapMethodError(reflectiveOperationException);
            }
        }
    }
}

