/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import esecurity.desktop.Listener;
import esecurity.desktop.Region;
import java.awt.geom.Point2D;

public class DragAndDropInnerArea {
    private Region area;
    private Listener<DragAndDropInnerArea> onDragEnter;
    private Listener<DragAndDropInnerArea> onDragLeave;
    private Listener<DragAndDropInnerArea> onResizeView;
    private Point2D resizeRatio;

    public DragAndDropInnerArea(Region area, Listener<DragAndDropInnerArea> onDragEnter, Listener<DragAndDropInnerArea> onDragLeave, Listener<DragAndDropInnerArea> onResizeView) {
        this.area = area;
        this.onDragEnter = onDragEnter;
        this.onDragLeave = onDragLeave;
        this.onResizeView = onResizeView;
    }

    public void setArea(Region area) {
        this.area = area;
    }

    public Region getArea() {
        return this.area;
    }

    public Point2D getResizeRatio() {
        return this.resizeRatio;
    }

    public void setOnDragEnter(Listener<DragAndDropInnerArea> onDragEnter) {
        this.onDragEnter = onDragEnter;
    }

    public void setOnDragLeave(Listener<DragAndDropInnerArea> onDragLeave) {
        this.onDragLeave = onDragLeave;
    }

    public void setOnResizeView(Listener<DragAndDropInnerArea> onResizeView) {
        this.onResizeView = onResizeView;
    }

    public void dragEnter() {
        if (this.onDragEnter != null) {
            this.onDragEnter.notify(this);
        }
    }

    public void dragLeave() {
        if (this.onDragLeave != null) {
            this.onDragLeave.notify(this);
        }
    }

    public void resizeView(Point2D resizeRatio) {
        if (this.onResizeView != null) {
            this.resizeRatio = resizeRatio;
            this.onResizeView.notify(this);
        }
    }

    public boolean contains(int x, int y) {
        return x >= this.area.getX() && x <= this.area.getX() + this.area.getWidth() && y >= this.area.getY() && y <= this.area.getY() + this.area.getHeight();
    }
}

