/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.cades;

import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.steps.SignatureValidationStep;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import esecurity.validator.steps.cades.CadesStepSignatureDPCM45Compliance;
import esecurity.validator.steps.cades.CadesStepSignatureETSICompliance;
import esecurity.validator.steps.core.StepFormat;
import esecurity.validator.steps.core.StepSignatureDigestAlgorithmCheck;
import esecurity.validator.steps.core.StepSignatureIntegrity;
import esecurity.validator.steps.core.StepSignatureIntegrityRelaxedCheck;
import esecurity.validator.steps.core.StepValidationProfile;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

@StepOrder(order=1)
@StepContext(formats={ValidationSignatureFormats.CADES})
public class CadesStepSignatureValidity
extends SignatureValidationStep {
    public CadesStepSignatureValidity() {
        this.subSteps.add(new StepFormat());
        this.subSteps.add(new StepSignatureIntegrity());
        this.subSteps.add(new StepSignatureIntegrityRelaxedCheck());
        this.subSteps.add(new CadesStepSignatureETSICompliance());
        this.subSteps.add(new StepSignatureDigestAlgorithmCheck());
        this.subSteps.add(new CadesStepSignatureDPCM45Compliance());
        this.subSteps.add(new StepValidationProfile());
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> messageLevel, ValidationContextParameters validationContextParameters) {
        if (validationContextParameters.getSignature() == null) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        if ((messageLevel = StepsUtils.retrieveWorstLevel(messageLevel)) == MessageLevel.ERROR) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0001_INVALID_SIGNATURE, new Object[0]);
        }
        if (validationContextParameters.getSignerCertificate() != null && validationContextParameters.getSignerCertificate().hasMessage(ValidatorMessageEnum.EC0003_CERT_NOT_RELIABLE)) {
            messageLevel = MessageLevel.WARNING;
        }
        return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), messageLevel, (EsecurityMessage)ValidatorMessageEnum.IS0005_SIGN_VALID, new Object[0]);
    }
}

